/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.util.ExceptionsUtil;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.UserSyncConvert;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.model.vo.query.user.sync.UserSyncRecordPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.user.sync.UserSyncRecordDetailRespVO;
import com.elitescloud.cloudt.system.provider.usersync.SyncUserResult;
import com.elitescloud.cloudt.system.provider.usersync.UserSyncProvider;
import com.elitescloud.cloudt.system.service.UserSyncMngService;
import com.elitescloud.cloudt.system.service.model.entity.SysUserSyncDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserSyncRecordDO;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserSyncRecordRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserSyncRepoProc;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
public class UserSyncMngServiceImpl
implements UserSyncMngService {
    private static final Logger logger = LoggerFactory.getLogger(UserSyncMngServiceImpl.class);
    @Autowired
    private UserSyncRepoProc syncRepoProc;
    @Autowired
    private UserSyncRecordRepoProc syncRecordRepoProc;
    @Autowired
    private UserRepoProc userRepoProc;
    @Autowired
    private List<UserSyncProvider<? extends Serializable, ? extends Serializable>> syncProviderList;

    @Override
    public ApiResult<PagingVO<UserSyncRecordDetailRespVO>> pageQuery(UserSyncRecordPageQueryVO queryVO) {
        String defaultOuterSysCode = this.getDefaultOuterSysCode();
        PagingVO<UserSyncRecordDetailRespVO> pageData = this.syncRepoProc.pageMng(queryVO, defaultOuterSysCode);
        return ApiResult.ok(pageData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> syncUser(String outerSysCode, Long userId, Object syncData) {
        String failReasonDetail;
        Assert.notNull((Object)userId, (String)"\u8d26\u53f7ID\u4e3a\u7a7a");
        Assert.hasText((String)outerSysCode, (String)"\u5916\u90e8\u7cfb\u7edf\u7f16\u7801\u4e3a\u7a7a");
        UserSyncProvider<?, ?> syncProvider = this.findSyncProvider(outerSysCode);
        Assert.notNull(syncProvider, (String)"\u5c1a\u672a\u914d\u7f6e\u8be5\u540c\u6b65\u65b9\u5f0f");
        SysUserBasicDTO userDTO = this.userRepoProc.getBasicDto(userId);
        Assert.notNull((Object)userDTO, (String)"\u540c\u6b65\u8d26\u53f7\u4e0d\u5b58\u5728");
        Object toSyncData = syncProvider.convertSyncData(HttpServletUtil.currentRequest(), userDTO, (Serializable)syncData);
        SysUserSyncRecordDO record = this.saveSyncRecord(syncProvider, userDTO, toSyncData);
        SysUserSyncDO userSync = this.saveSync(record);
        Throwable exp = null;
        SyncUserResult syncUserResult = null;
        try {
            syncUserResult = syncProvider.syncUser(userId, toSyncData);
            String string = failReasonDetail = exp == null ? null : ExceptionsUtil.stackTraceAllToString(exp);
        }
        catch (Exception e) {
            String failReasonDetail2;
            try {
                logger.error("\u540c\u6b65\u8d26\u53f7\u5f02\u5e38\uff1a{}, {}, {}", new Object[]{outerSysCode, userId, userDTO.getUsername(), e});
                exp = e;
                String string = failReasonDetail2 = exp == null ? null : ExceptionsUtil.stackTraceAllToString((Throwable)exp);
            }
            catch (Throwable throwable) {
                String failReasonDetail3;
                String string = failReasonDetail3 = exp == null ? null : ExceptionsUtil.stackTraceAllToString(exp);
                if (syncUserResult == null) {
                    syncUserResult = new SyncUserResult(userId);
                    syncUserResult.setSuccess(exp == null);
                    syncUserResult.setFailMsg(exp == null ? null : exp.getMessage());
                }
                this.syncRepoProc.updateSyncResult(userSync.getId(), syncUserResult, failReasonDetail3);
                this.syncRecordRepoProc.updateSyncResult(record.getId(), syncUserResult, failReasonDetail3);
                throw throwable;
            }
            if (syncUserResult == null) {
                syncUserResult = new SyncUserResult(userId);
                syncUserResult.setSuccess(exp == null);
                syncUserResult.setFailMsg(exp == null ? null : exp.getMessage());
            }
            this.syncRepoProc.updateSyncResult(userSync.getId(), syncUserResult, failReasonDetail2);
            this.syncRecordRepoProc.updateSyncResult(record.getId(), syncUserResult, failReasonDetail2);
        }
        if (syncUserResult == null) {
            syncUserResult = new SyncUserResult(userId);
            syncUserResult.setSuccess(exp == null);
            syncUserResult.setFailMsg(exp == null ? null : exp.getMessage());
        }
        this.syncRepoProc.updateSyncResult(userSync.getId(), syncUserResult, failReasonDetail);
        this.syncRecordRepoProc.updateSyncResult(record.getId(), syncUserResult, failReasonDetail);
        return ApiResult.ok((Object)userId);
    }

    @Override
    public ApiResult<List<UserSyncRecordDetailRespVO>> listSyncRecord(String outerSysCode, Long userId) {
        Assert.notNull((Object)userId, (String)"\u8d26\u53f7ID\u4e3a\u7a7a");
        Assert.hasText((String)outerSysCode, (String)"\u7cfb\u7edf\u7f16\u7801\u4e3a\u7a7a");
        List<SysUserSyncRecordDO> recordDoList = this.syncRecordRepoProc.listSyncRecord(outerSysCode, userId);
        if (recordDoList.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        List respVoList = recordDoList.stream().sorted(Comparator.comparing(SysUserSyncRecordDO::getSyncTime).reversed()).map(t -> {
            UserSyncRecordDetailRespVO respVO = UserSyncConvert.INSTANCE.do2respVO((SysUserSyncRecordDO)t);
            respVO.setId(t.getUserId());
            respVO.setFullName(t.getFullName());
            respVO.setSync(Boolean.TRUE.equals(t.getSyncSuccess()));
            return respVO;
        }).collect(Collectors.toList());
        return ApiResult.ok(respVoList);
    }

    private SysUserSyncRecordDO saveSyncRecord(UserSyncProvider<?, ?> provider, SysUserBasicDTO userBasicDTO, Object syncData) {
        SysUserSyncRecordDO recordDO = new SysUserSyncRecordDO();
        recordDO.setOuterSysCode(provider.sysCode());
        recordDO.setUserId(userBasicDTO.getId());
        recordDO.setUsername(userBasicDTO.getUsername());
        recordDO.setLastName(userBasicDTO.getLastName());
        recordDO.setFirstName(userBasicDTO.getFirstName());
        recordDO.setMobile(userBasicDTO.getMobile());
        recordDO.setEmail(userBasicDTO.getEmail());
        recordDO.setIdCard(userBasicDTO.getIdCard());
        recordDO.setSyncTime(LocalDateTime.now());
        recordDO.setSyncSuccess(Boolean.valueOf(false));
        recordDO.setSyncUrl(provider.getSyncUrl());
        recordDO.setSyncData((Map)JSONUtil.convertObj((Object)syncData, (TypeReference)new TypeReference<Map<String, Object>>(){}));
        this.syncRecordRepoProc.save((Serializable)recordDO);
        return recordDO;
    }

    private SysUserSyncDO saveSync(SysUserSyncRecordDO recordDO) {
        SysUserSyncDO userSyncDO = this.syncRepoProc.getUserSync(recordDO.getUserId(), recordDO.getOuterSysCode());
        if (userSyncDO == null) {
            userSyncDO = new SysUserSyncDO();
            userSyncDO.setUserId(recordDO.getUserId());
            userSyncDO.setOuterSysCode(recordDO.getOuterSysCode());
        }
        userSyncDO.setSyncTime(recordDO.getSyncTime());
        userSyncDO.setSyncSuccess(Boolean.valueOf(false));
        userSyncDO.setFailReason(null);
        userSyncDO.setSyncUrl(recordDO.getSyncUrl());
        userSyncDO.setSyncData(recordDO.getSyncData());
        this.syncRepoProc.save((Serializable)userSyncDO);
        return userSyncDO;
    }

    private UserSyncProvider<?, ?> findSyncProvider(String outerSysCode) {
        if (CollUtil.isEmpty(this.syncProviderList) || CharSequenceUtil.isBlank((CharSequence)outerSysCode)) {
            return null;
        }
        for (UserSyncProvider<? extends Serializable, ? extends Serializable> s : this.syncProviderList) {
            if (!outerSysCode.equals(s.sysCode())) continue;
            return s;
        }
        return null;
    }

    private String getDefaultOuterSysCode() {
        if (CollUtil.isEmpty(this.syncProviderList)) {
            return null;
        }
        for (UserSyncProvider<? extends Serializable, ? extends Serializable> s : this.syncProviderList) {
            if (Boolean.FALSE.equals(s.enabled())) continue;
            return s.sysCode();
        }
        return null;
    }
}

