/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.manager;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.cacheable.SysCacheEmployeeRpcService;
import com.elitescloud.cloudt.system.constant.UserType;
import com.elitescloud.cloudt.system.convert.EmployeeConvert;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.service.callback.EmployeeChangedCallback;
import com.elitescloud.cloudt.system.service.manager.OrgTreeManager;
import com.elitescloud.cloudt.system.service.manager.UserMngManager;
import com.elitescloud.cloudt.system.service.model.bo.SysEmployeeOrgSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysEmployeeSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysUserSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysEmployeeDO;
import com.elitescloud.cloudt.system.service.model.entity.SysEmployeeOrgDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.service.repo.EmployeeOrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.EmployeeRepoProc;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRoleRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserTypeRepoProc;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
public class EmployeeMngManager {
    private static final Logger log = LogManager.getLogger(EmployeeMngManager.class);
    private static final EmployeeConvert CONVERT = EmployeeConvert.INSTANCE;
    @Autowired
    private EmployeeRepoProc employeeRepoProc;
    @Autowired
    private EmployeeOrgRepoProc employeeOrgRepoProc;
    @Autowired
    private UserRepoProc userRepoProc;
    @Autowired
    private UserRoleRepoProc userRoleRepoProc;
    @Autowired
    private OrgRepoProc orgRepoProc;
    @Autowired
    private UserTypeRepoProc userTypeRepoProc;
    @Autowired
    private UserMngManager userMngManager;
    @Autowired
    private OrgTreeManager orgTreeManager;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    @Autowired
    private TenantClientProvider tenantClientProvider;
    @Autowired
    private ObjectProvider<EmployeeChangedCallback> employeeChangedCallbacks;
    @Autowired
    private SysCacheEmployeeRpcService cacheEmployeeRpcService;

    public SysEmployeeDO upsert(@NotNull SysEmployeeSaveBO saveBO) {
        Long employeeId;
        boolean hasUser;
        boolean bl = hasUser = saveBO.getWithoutLoginAccount() == null || saveBO.getWithoutLoginAccount() == false;
        if (hasUser) {
            this.setUserChangedSource();
            if (saveBO.getUserId() != null && saveBO.getUserId() == -1L) {
                saveBO.setUserId(null);
            }
            if (this.isBoundUser(saveBO.getId(), saveBO.getUserId())) {
                throw new IllegalArgumentException("\u8be5\u8d26\u53f7\u5df2\u4e0e\u5176\u4ed6\u5458\u5de5\u7ed1\u5b9a");
            }
            SysUserSaveBO userSaveBO = saveBO.getUserSaveBO();
            if (userSaveBO != null) {
                userSaveBO.setId(saveBO.getUserId());
                userSaveBO.setMobile(CharSequenceUtil.blankToDefault((CharSequence)userSaveBO.getMobile(), (String)saveBO.getPhone()));
                userSaveBO.setEmail(CharSequenceUtil.blankToDefault((CharSequence)userSaveBO.getEmail(), (String)saveBO.getEmailWork()));
                SysUserDO userDO = this.userMngManager.upsert(userSaveBO);
                saveBO.setUserId(userDO.getId());
                saveBO.setPhone(CharSequenceUtil.blankToDefault((CharSequence)saveBO.getPhone(), (String)userSaveBO.getMobile()));
                saveBO.setEmailWork(CharSequenceUtil.blankToDefault((CharSequence)saveBO.getEmailWork(), (String)userSaveBO.getEmail()));
            }
        }
        boolean isAdd = saveBO.getId() == null;
        SysEmployeeDO employeeOld = isAdd ? null : (SysEmployeeDO)this.employeeRepoProc.get(saveBO.getId());
        Long oldUserId = employeeOld == null ? null : employeeOld.getUserId();
        SysEmployeeDO employeeDO = isAdd ? this.checkForInsert(saveBO, hasUser) : this.checkForUpdate(saveBO, employeeOld, hasUser);
        this.checkForEmployeeOrg(saveBO, employeeDO);
        if (isAdd && hasUser && (employeeId = this.employeeRepoProc.getIdByUserId(saveBO.getUserId())) != null) {
            isAdd = false;
            saveBO.setId(employeeId);
            employeeDO.setId(employeeId);
        }
        employeeDO.setExtensionInfo(saveBO.getExtensionInfo());
        this.employeeRepoProc.save((Serializable)employeeDO);
        if (hasUser) {
            this.userMngManager.updateUserType(employeeDO.getUserId(), UserType.EMPLOYEE.getValue(), employeeDO.getId().toString());
        }
        this.saveEmployeeOrg(employeeDO.getId(), saveBO.getOrgInfoList());
        if (!isAdd && !Objects.equals(oldUserId, employeeDO.getUserId())) {
            this.updateUserIdOfEmployee(employeeDO.getId(), employeeDO.getUserId());
        }
        if (Boolean.FALSE.equals(saveBO.getEnabled())) {
            this.updateEnabled(employeeDO.getId(), false);
        }
        boolean finalIsAdd = isAdd;
        this.employeeChangedCallbacks.forEach(t -> t.onUpsert(finalIsAdd, saveBO, employeeDO));
        this.clearCache();
        return employeeDO;
    }

    public void check(@NotNull SysEmployeeSaveBO saveBO) {
        boolean hasUser;
        boolean bl = hasUser = saveBO.getWithoutLoginAccount() == null || saveBO.getWithoutLoginAccount() == false;
        if (saveBO.getUserSaveBO() != null && hasUser) {
            this.userMngManager.check(saveBO.getUserSaveBO());
        }
        boolean isAdd = saveBO.getId() == null;
        SysEmployeeDO employeeOld = isAdd ? null : (SysEmployeeDO)this.employeeRepoProc.get(saveBO.getId());
        SysEmployeeDO employeeDO = isAdd ? this.checkForInsert(saveBO, hasUser) : this.checkForUpdate(saveBO, employeeOld, hasUser);
        this.checkForEmployeeOrg(saveBO, employeeDO);
        if (isAdd && hasUser) {
            Assert.notNull((Object)saveBO.getUserId(), (String)"\u672a\u77e5\u5458\u5de5\u8d26\u53f7\u4fe1\u606f");
        }
    }

    public SysEmployeeDO upsert(@NotNull SysUserSaveBO userSaveBO, Long orgId) {
        this.setUserChangedSource();
        SysUserDO userDO = this.userMngManager.upsert(userSaveBO);
        Long rootOrgId = null;
        SysEmployeeDO employeeDO = this.employeeRepoProc.getByUserId(userDO.getId()).orElse(null);
        if (employeeDO == null) {
            Assert.notNull((Object)orgId, (String)"\u7ec4\u7ec7ID\u4e3a\u7a7a");
            rootOrgId = this.orgRepoProc.getRootId(orgId);
            Assert.notNull((Object)rootOrgId, (String)"\u672a\u67e5\u8be2\u5230\u6839\u7ec4\u7ec7");
            employeeDO = new SysEmployeeDO();
            employeeDO.setUserId(userDO.getId());
            employeeDO.setRootOrgId(rootOrgId);
            employeeDO.setUsername(userDO.getUsername());
            employeeDO.setLastName(userDO.getLastName());
            employeeDO.setFirstName(userDO.getFirstName());
            employeeDO.setGender(userDO.getGender());
            employeeDO.setNickName(userDO.getNickName());
            employeeDO.setBirthDate(userDO.getBirthDate());
            employeeDO.setJoinTime(LocalDateTime.now());
            employeeDO.setPhone(CharSequenceUtil.blankToDefault((CharSequence)userDO.getMobile(), (String)""));
            employeeDO.setEmailWork(CharSequenceUtil.blankToDefault((CharSequence)userDO.getEmail(), (String)""));
            employeeDO.setMobile(CharSequenceUtil.blankToDefault((CharSequence)userDO.getMobile(), (String)""));
            employeeDO.setEmail(CharSequenceUtil.blankToDefault((CharSequence)userDO.getEmail(), (String)""));
            employeeDO.setIdCard(userDO.getIdCard());
            employeeDO.setEnabled(Boolean.valueOf(false));
            employeeDO.setSortNo(Integer.valueOf(1));
            employeeDO.setProvinceCode(userDO.getProvinceCode());
            employeeDO.setCityCode(userDO.getCityCode());
            employeeDO.setCountyCode(userDO.getCountyCode());
            employeeDO.setAddress(userDO.getAddress());
            employeeDO.setPersonalSign(userDO.getPersonalSign());
            employeeDO.setAvatarUrl(userDO.getAvatarUrl());
            employeeDO.setAvatarCode(userDO.getAvatarCode());
            this.employeeRepoProc.save((Serializable)employeeDO);
            SysEmployeeDO finalEmployeeDO = employeeDO;
            this.employeeChangedCallbacks.forEach(t -> t.onUpsert(true, null, finalEmployeeDO));
        } else {
            employeeDO.setUserId(userDO.getId());
            employeeDO.setUsername(userDO.getUsername());
            employeeDO.setLastName(userDO.getLastName());
            employeeDO.setFirstName(userDO.getFirstName());
            employeeDO.setGender(userDO.getGender());
            employeeDO.setNickName(userDO.getNickName());
            employeeDO.setBirthDate(userDO.getBirthDate());
            employeeDO.setPhone(CharSequenceUtil.blankToDefault((CharSequence)employeeDO.getPhone(), (String)userDO.getMobile()));
            employeeDO.setEmailWork(CharSequenceUtil.blankToDefault((CharSequence)employeeDO.getEmailWork(), (String)userDO.getEmail()));
            employeeDO.setMobile(userDO.getMobile());
            employeeDO.setEmail(userDO.getEmail());
            employeeDO.setIdCard(userDO.getIdCard());
            employeeDO.setProvinceCode(userDO.getProvinceCode());
            employeeDO.setCityCode(userDO.getCityCode());
            employeeDO.setCountyCode(userDO.getCountyCode());
            employeeDO.setAddress(userDO.getAddress());
            employeeDO.setPersonalSign(userDO.getPersonalSign());
            employeeDO.setAvatarUrl(userDO.getAvatarUrl());
            employeeDO.setAvatarCode(userDO.getAvatarCode());
            this.employeeRepoProc.save((Serializable)employeeDO);
        }
        if (orgId != null) {
            this.addEmployeeOrg(employeeDO.getId(), orgId, rootOrgId);
        }
        this.clearCache();
        return employeeDO;
    }

    public void saveEmployeeOrg(@NotNull Long employeeId, List<SysEmployeeOrgSaveBO> orgInfoList) {
        Set<Long> orgIdsToDel;
        if (CollUtil.isEmpty(orgInfoList)) {
            return;
        }
        Set orgIds = orgInfoList.stream().map(SysEmployeeOrgSaveBO::getOrgId).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<Long, SysEmployeeOrgDO> orgOldMap = this.employeeOrgRepoProc.getEmployeeOrgByEmployeeId(employeeId).stream().collect(Collectors.toMap(SysEmployeeOrgDO::getOrgId, t -> t, (t1, t2) -> t1));
        Set<Long> orgOldIds = orgOldMap.keySet();
        Long rootOrgId = this.employeeRepoProc.getRootOrgId(employeeId);
        Assert.notNull((Object)rootOrgId, (String)"\u672a\u77e5\u5458\u5de5\u7684\u6839\u7ec4\u7ec7");
        if (orgInfoList.isEmpty()) {
            Set<Long> orgIdsToDel2 = orgOldIds.stream().filter(t -> t.longValue() != rootOrgId.longValue()).collect(Collectors.toSet());
            this.employeeOrgRepoProc.delete((long)employeeId, orgIdsToDel2);
            return;
        }
        Long userId = this.employeeRepoProc.getRealUserId(employeeId);
        LocalDateTime nowTime = LocalDateTime.now();
        ArrayList<SysEmployeeOrgDO> empOrgListToSave = new ArrayList<SysEmployeeOrgDO>();
        HashSet<Long> existsOrgIds = new HashSet<Long>();
        for (SysEmployeeOrgSaveBO orgInfo : orgInfoList) {
            Assert.isTrue((!existsOrgIds.contains(orgInfo.getOrgId()) ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\u7684\u5458\u5de5\u7ec4\u7ec7");
            existsOrgIds.add(orgInfo.getOrgId());
            SysEmployeeOrgDO employeeOrgDO = orgOldMap.get(orgInfo.getOrgId());
            if (employeeOrgDO != null) {
                if (!Objects.equals(employeeOrgDO.getLeaderUserId(), orgInfo.getLeaderUserId())) {
                    employeeOrgDO.setLeaderUserId(orgInfo.getLeaderUserId());
                    if (orgInfo.getLeaderUserId() != null) {
                        employeeOrgDO.setLeaderEmployeeId(this.employeeRepoProc.getIdByUserId(orgInfo.getLeaderUserId()));
                    } else {
                        employeeOrgDO.setLeaderEmployeeId(null);
                    }
                }
                employeeOrgDO.setPositionId(orgInfo.getPositionId());
                employeeOrgDO.setUserId(userId);
                employeeOrgDO.setDef(Boolean.valueOf(orgInfo.getDef() != null && orgInfo.getDef() != false));
                employeeOrgDO.setAssignee(Boolean.valueOf(orgInfo.getAssignee() != null && orgInfo.getAssignee() != false));
                empOrgListToSave.add(employeeOrgDO);
                continue;
            }
            employeeOrgDO = new SysEmployeeOrgDO();
            employeeOrgDO.setUserId(userId);
            employeeOrgDO.setEmployeeId(employeeId);
            employeeOrgDO.setRootOrgId(rootOrgId);
            employeeOrgDO.setOrgId(orgInfo.getOrgId());
            employeeOrgDO.setLeaderUserId(orgInfo.getLeaderUserId());
            employeeOrgDO.setPositionId(orgInfo.getPositionId());
            if (orgInfo.getLeaderUserId() != null) {
                employeeOrgDO.setLeaderEmployeeId(this.employeeRepoProc.getIdByUserId(orgInfo.getLeaderUserId()));
            }
            employeeOrgDO.setJoinTime(nowTime);
            employeeOrgDO.setDef(Boolean.valueOf(orgInfo.getDef() != null && orgInfo.getDef() != false));
            employeeOrgDO.setAssignee(Boolean.valueOf(orgInfo.getAssignee() != null && orgInfo.getAssignee() != false));
            empOrgListToSave.add(employeeOrgDO);
        }
        if (!empOrgListToSave.isEmpty()) {
            long defSize = empOrgListToSave.stream().filter(t -> Boolean.TRUE.equals(t.getDef())).count();
            Assert.isTrue((defSize < 2L ? 1 : 0) != 0, (String)"\u9ed8\u8ba4\u7ec4\u7ec7\u53ea\u80fd\u6709\u4e00\u4e2a");
            this.employeeOrgRepoProc.save(empOrgListToSave);
        }
        if (!(orgIdsToDel = orgOldIds.stream().filter(t -> !orgIds.contains(t)).collect(Collectors.toSet())).isEmpty()) {
            this.employeeOrgRepoProc.delete((long)employeeId, orgIdsToDel);
        }
        this.clearCache();
    }

    public void updateEnabled(Long employeeId, Boolean enabled) {
        if (enabled == null) {
            enabled = true;
        }
        this.employeeRepoProc.updateEnabled(employeeId, enabled);
        Long userId = this.employeeRepoProc.getUserId(employeeId);
        if (userId != null) {
            this.setUserChangedSource();
            this.userMngManager.updateEnabled(userId, enabled);
        }
        Boolean finalEnabled = enabled;
        this.employeeChangedCallbacks.forEach(t -> t.onEnabled(employeeId, finalEnabled.booleanValue()));
        this.clearCache();
    }

    public void updateMobile(Long id, String mobile, Boolean updateUser) {
        Long userId;
        this.employeeRepoProc.updateMobile(id, mobile);
        if (Boolean.TRUE.equals(updateUser) && (userId = this.employeeRepoProc.getUserId(id)) != null) {
            this.setUserChangedSource();
            this.userMngManager.updateMobile(userId, mobile);
        }
        this.clearCache();
    }

    public void updateEmail(Long id, String email, Boolean updateUser) {
        Long userId;
        this.employeeRepoProc.updateEmail(id, email);
        if (Boolean.TRUE.equals(updateUser) && (userId = this.employeeRepoProc.getUserId(id)) != null) {
            this.setUserChangedSource();
            this.userMngManager.updateEmail(userId, email);
        }
        this.clearCache();
    }

    public void deleteEmployee(Long employeeId, Boolean keepUser) {
        if (!this.employeeRepoProc.exists(employeeId)) {
            return;
        }
        List<String> underlingCodes = this.employeeOrgRepoProc.getUnderlingCodes(employeeId, null);
        if (!underlingCodes.isEmpty()) {
            throw new BusinessException("\u5f53\u524d\u5458\u5de5\u8fd8\u6709\u4e0b\u5c5e[" + underlingCodes.get(0) + "]\uff0c\u8bf7\u5148\u89e3\u9664\u9886\u5bfc\u5173\u7cfb");
        }
        Long userId = this.employeeRepoProc.getUserId(employeeId);
        this.employeeRepoProc.delete(employeeId);
        this.employeeOrgRepoProc.deleteByEmployeeId(employeeId);
        this.employeeOrgRepoProc.deleteByLeaderEmployeeId(employeeId);
        if (keepUser == null) {
            keepUser = false;
        }
        if (userId != null) {
            this.userRoleRepoProc.deleteByUser(userId);
            if (keepUser.booleanValue()) {
                SysTenantDTO tenant = this.tenantClientProvider.getSessionTenant();
                Long tenantId = tenant == null ? TenantConstant.DEFAULT_TENANT_ID : tenant.getId();
                this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
                    this.userTypeRepoProc.delete(userId, Set.of(UserType.EMPLOYEE.getValue()), tenantId);
                    return null;
                });
            } else {
                this.setUserChangedSource();
                this.userMngManager.delete(userId);
            }
        }
        this.employeeChangedCallbacks.forEach(t -> t.onDelete(employeeId));
        this.clearCache();
    }

    public void deleteEmployeeByUser(Long userId) {
        Long employeeId = this.employeeRepoProc.getIdByUserId(userId);
        if (employeeId == null) {
            return;
        }
        this.employeeRepoProc.delete(employeeId);
        this.employeeOrgRepoProc.deleteByEmployeeId(employeeId);
        this.employeeOrgRepoProc.deleteByLeaderEmployeeId(employeeId);
        this.clearCache();
    }

    private void clearCache() {
        this.cacheEmployeeRpcService.clearCache();
        this.orgTreeManager.clearCache();
    }

    private void updateUserIdOfEmployee(long employeeId, Long userId) {
        this.employeeOrgRepoProc.updateUserIdOfEmployee(employeeId, userId);
    }

    private boolean isBoundUser(Long userId, Long employeeId) {
        if (userId == null || userId == -1L) {
            return false;
        }
        Long existsEmployeeId = this.employeeRepoProc.getIdByUserId(userId);
        if (existsEmployeeId == null) {
            return false;
        }
        return employeeId == null || employeeId.longValue() != existsEmployeeId.longValue();
    }

    private void copyUserInfo(SysEmployeeDO employeeDO, SysUserDO userDO) {
        employeeDO.setUserId(userDO.getId());
        employeeDO.setUsername(userDO.getUsername());
        employeeDO.setLastName(userDO.getLastName());
        employeeDO.setFirstName(userDO.getFirstName());
        employeeDO.setGender(userDO.getGender());
        employeeDO.setNickName(userDO.getNickName());
        employeeDO.setBirthDate(userDO.getBirthDate());
        employeeDO.setMobile(userDO.getMobile());
        employeeDO.setEmail(userDO.getEmail());
        employeeDO.setIdCard(userDO.getIdCard());
        employeeDO.setCountryCode(userDO.getCountryCode());
        employeeDO.setProvinceCode(userDO.getProvinceCode());
        employeeDO.setCityCode(userDO.getCityCode());
        employeeDO.setCountyCode(userDO.getCountyCode());
        employeeDO.setAddress(userDO.getAddress());
        employeeDO.setPersonalSign(userDO.getPersonalSign());
        employeeDO.setAvatarUrl(userDO.getAvatarUrl());
        employeeDO.setAvatarCode(userDO.getAvatarCode());
    }

    private void copyUserInfo(SysEmployeeDO employeeDO, SysUserSaveBO userBO) {
        if (userBO == null) {
            return;
        }
        employeeDO.setUserId(userBO.getId());
        employeeDO.setUsername(userBO.getUsername());
        employeeDO.setLastName(CharSequenceUtil.blankToDefault((CharSequence)userBO.getFullName(), (String)userBO.getUsername()));
        employeeDO.setGender(userBO.getGender());
        employeeDO.setNickName(userBO.getNickName());
        employeeDO.setBirthDate(userBO.getBirthDate());
        employeeDO.setMobile(userBO.getMobile());
        employeeDO.setEmail(userBO.getEmail());
        employeeDO.setIdCard(userBO.getIdCard());
        if (userBO.getAreaBO() != null) {
            employeeDO.setCountryCode(userBO.getAreaBO().getCountryCode());
            employeeDO.setProvinceCode(userBO.getAreaBO().getProvinceCode());
            employeeDO.setCityCode(userBO.getAreaBO().getCityCode());
            employeeDO.setCountyCode(userBO.getAreaBO().getCountyCode());
        }
        employeeDO.setAddress(userBO.getAddress());
        employeeDO.setPersonalSign(userBO.getPersonalSign());
        employeeDO.setAvatarUrl(userBO.getAvatarUrl());
        employeeDO.setAvatarCode(userBO.getAvatarCode());
    }

    private SysEmployeeDO checkForInsert(SysEmployeeSaveBO saveBO, boolean hasUser) {
        SysEmployeeDO employeeDO = CONVERT.saveBO2Do(saveBO);
        if (hasUser) {
            Assert.notNull((Object)saveBO.getUserId(), (String)"\u672a\u77e5\u5458\u5de5\u8d26\u53f7\u4fe1\u606f");
            SysUserDO userInfo = this.userRepoCall(repo -> (SysUserDO)repo.get(saveBO.getUserId()));
            Assert.notNull((Object)userInfo, (String)"\u8d26\u53f7\u4fe1\u606f\u4e0d\u5b58\u5728");
            this.copyUserInfo(employeeDO, userInfo);
            String code = this.employeeRepoProc.getCodeByUserId(userInfo.getId());
            Assert.isTrue((boolean)CharSequenceUtil.isBlank((CharSequence)code), (String)("\u8be5\u8d26\u53f7\u5df2\u7ed1\u5b9a\u5458\u5de5\uff1a" + code));
        } else {
            this.copyUserInfo(employeeDO, saveBO.getUserSaveBO());
            employeeDO.setUserId(Long.valueOf(-1L));
            employeeDO.setUsername("");
        }
        Assert.hasText((String)saveBO.getCode(), (String)"\u5458\u5de5\u7f16\u53f7\u4e3a\u7a7a");
        boolean exists = this.employeeRepoProc.existsCode(saveBO.getCode());
        Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u5458\u5de5\u7f16\u53f7\u5df2\u5b58\u5728");
        employeeDO.setEmailWork(CharSequenceUtil.blankToDefault((CharSequence)saveBO.getEmailWork(), (String)saveBO.getUserSaveBO().getEmail()));
        employeeDO.setPhone(CharSequenceUtil.blankToDefault((CharSequence)saveBO.getPhone(), (String)saveBO.getUserSaveBO().getMobile()));
        employeeDO.setJoinTime((LocalDateTime)ObjectUtil.defaultIfNull((Object)saveBO.getJoinTime(), (Object)LocalDateTime.now()));
        if (employeeDO.getEnabled() == null) {
            employeeDO.setEnabled(Boolean.valueOf(true));
        }
        if (employeeDO.getServed() == null) {
            employeeDO.setServed(Boolean.valueOf(true));
        }
        if (employeeDO.getSortNo() == null) {
            employeeDO.setSortNo(Integer.valueOf(1));
        }
        return employeeDO;
    }

    private SysEmployeeDO checkForUpdate(SysEmployeeSaveBO saveBO, SysEmployeeDO employeeOld, boolean hasUser) {
        Assert.notNull((Object)employeeOld, (String)"\u4fee\u6539\u7684\u5458\u5de5\u4fe1\u606f\u4e0d\u5b58\u5728");
        SysEmployeeDO employeeDO = (SysEmployeeDO)this.employeeRepoProc.get(saveBO.getId());
        CONVERT.saveBO2DO(saveBO, employeeDO);
        if (hasUser) {
            if (employeeDO.getUserId() == null || employeeDO.getUserId() == -1L) {
                employeeDO.setUserId(employeeOld.getUserId());
            } else if (employeeDO.getUserId().longValue() != employeeOld.getUserId().longValue()) {
                throw new BusinessException("\u5458\u5de5\u8d26\u53f7\u4fe1\u606f\u4e0d\u4e00\u81f4");
            }
            SysUserDO userInfo = this.userRepoCall(repo -> (SysUserDO)repo.get(saveBO.getUserId()));
            Assert.notNull((Object)userInfo, (String)"\u8d26\u53f7\u4fe1\u606f\u4e0d\u5b58\u5728");
            this.copyUserInfo(employeeDO, userInfo);
        } else {
            if (employeeDO.getUserId() != null && employeeDO.getUserId() != -1L) {
                throw new BusinessException("\u5df2\u6709\u8d26\u53f7\uff0c\u4e0d\u53ef\u4fee\u6539\u4e3a\u65e0\u8d26\u53f7");
            }
            this.copyUserInfo(employeeDO, saveBO.getUserSaveBO());
            employeeDO.setUserId(Long.valueOf(-1L));
            employeeDO.setUsername("");
        }
        boolean exists = false;
        Assert.hasText((String)employeeDO.getCode(), (String)"\u5458\u5de5\u7f16\u53f7\u4e3a\u7a7a");
        if (!employeeDO.getCode().equals(employeeOld.getCode())) {
            exists = this.employeeRepoProc.existsCode(employeeDO.getCode());
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u5458\u5de5\u7f16\u53f7\u5df2\u5b58\u5728");
        }
        if (employeeDO.getJoinTime() == null) {
            employeeDO.setJoinTime(employeeOld.getJoinTime());
        }
        if (employeeDO.getEnabled() == null) {
            employeeDO.setEnabled(Boolean.valueOf(true));
        }
        if (employeeDO.getServed() == null) {
            employeeDO.setServed(Boolean.valueOf(true));
        }
        if (employeeDO.getSortNo() == null) {
            employeeDO.setSortNo(Integer.valueOf(0));
        }
        return employeeDO;
    }

    private void checkForEmployeeOrg(SysEmployeeSaveBO saveBO, SysEmployeeDO employeeDO) {
        Assert.notEmpty((Collection)saveBO.getOrgInfoList(), (String)"\u5458\u5de5\u7684\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        Long orgId = saveBO.getOrgInfoList().stream().map(SysEmployeeOrgSaveBO::getOrgId).filter(Objects::nonNull).findAny().orElse(null);
        Assert.notNull((Object)orgId, (String)"\u8bf7\u9009\u62e9\u5458\u5de5\u7684\u7ec4\u7ec7");
        Long rootOrgId = this.orgRepoProc.getRootId(orgId);
        Assert.notNull((Object)rootOrgId, (String)"\u672a\u77e5\u7ec4\u7ec7\u6240\u5c5e\u6839\u7ec4\u7ec7");
        employeeDO.setRootOrgId(rootOrgId);
    }

    private void addEmployeeOrg(Long employeeId, Long orgId, Long rootOrgId) {
        List<Long> orgIds;
        if (rootOrgId == null) {
            rootOrgId = this.orgRepoProc.getRootId(orgId);
            Assert.notNull((Object)rootOrgId, (String)"\u6839\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        }
        if ((orgIds = this.employeeOrgRepoProc.getOrgIdByEmployeeId(employeeId)).contains(orgId)) {
            return;
        }
        Long userId = this.employeeRepoProc.getRealUserId(employeeId);
        LocalDateTime nowTime = LocalDateTime.now();
        SysEmployeeOrgDO employeeOrgDO = new SysEmployeeOrgDO();
        employeeOrgDO.setUserId(userId);
        employeeOrgDO.setEmployeeId(employeeId);
        employeeOrgDO.setRootOrgId(rootOrgId);
        employeeOrgDO.setOrgId(orgId);
        employeeOrgDO.setJoinTime(nowTime);
        employeeOrgDO.setDef(Boolean.valueOf(false));
        employeeOrgDO.setAssignee(Boolean.valueOf(false));
        this.employeeOrgRepoProc.save((Serializable)employeeOrgDO);
    }

    private Set<Long> obtainOrgIdsOfChanged(Collection<Long> orgIds1, Collection<Long> orgIds2) {
        if (CollectionUtils.isEmpty(orgIds1)) {
            return new HashSet<Long>((Collection)ObjectUtil.defaultIfNull(orgIds2, Collections.emptySet()));
        }
        if (CollectionUtils.isEmpty(orgIds2)) {
            return new HashSet<Long>((Collection)ObjectUtil.defaultIfNull(orgIds1, Collections.emptySet()));
        }
        HashSet<Long> result = new HashSet<Long>(64);
        for (Long id : orgIds1) {
            if (orgIds2.contains(id)) continue;
            result.add(id);
        }
        for (Long id : orgIds2) {
            if (orgIds1.contains(id)) continue;
            result.add(id);
        }
        return result;
    }

    private <T> T userRepoCall(Function<UserRepoProc, T> function) {
        return (T)this.tenantDataIsolateProvider.byDefaultDirectly(() -> function.apply(this.userRepoProc));
    }

    private void setUserChangedSource() {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request == null) {
            return;
        }
        request.setAttribute("cloudtSystemUserChanged", (Object)"employee");
    }
}

