/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.manager;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.model.bo.UserOrgBO;
import com.elitescloud.cloudt.system.service.repo.EmployeeOrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.EmployeeRepoProc;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.TenantOrgRepoProc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotEmpty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
public class EmployeeOrgManager {
    @Autowired
    private EmployeeOrgRepoProc employeeOrgRepoProc;
    @Autowired
    private EmployeeRepoProc employeeRepoProc;
    @Autowired
    private OrgRepoProc orgRepoProc;
    @Autowired
    private TenantOrgRepoProc tenantOrgRepoProc;

    public List<List<SysOrgBasicDTO>> queryOrgWithParentsByUser(Long userId) {
        List<Long> orgIds = this.employeeOrgRepoProc.getOrgIdByUserId(userId);
        if (orgIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<SysOrgBasicDTO>> orgList = new ArrayList<List<SysOrgBasicDTO>>(64);
        for (Long orgId : orgIds) {
            List<SysOrgBasicDTO> orgs = this.orgRepoProc.getBasicDtoOfParents(orgId);
            boolean existsDisabled = orgs.stream().anyMatch(t -> t.getEnabled() == false);
            if (existsDisabled) continue;
            orgList.add(orgs);
        }
        return orgList;
    }

    public Map<SysOrgBasicDTO, Long> getTenantOrg(Long orgId) {
        List<SysOrgBasicDTO> orgs = this.orgRepoProc.getBasicDtoOfParents(orgId);
        if (orgs.isEmpty()) {
            return Collections.emptyMap();
        }
        boolean existsDisabled = orgs.stream().anyMatch(t -> t.getEnabled() == false);
        if (existsDisabled) {
            return Collections.emptyMap();
        }
        Set<Long> orgIds = orgs.stream().map(SysOrgBasicDTO::getId).collect(Collectors.toSet());
        Map<Long, Long> tenantAdminIdMap = this.queryTenantOrgAdmin(orgIds);
        SysOrgBasicDTO orgTemp = null;
        Long adminId = null;
        for (int i = orgs.size() - 1; i >= 0; --i) {
            orgTemp = orgs.get(i);
            adminId = tenantAdminIdMap.get(orgTemp.getId());
            if (!tenantAdminIdMap.containsKey(orgTemp.getId())) continue;
            HashMap<SysOrgBasicDTO, Long> result = new HashMap<SysOrgBasicDTO, Long>(4);
            result.put(orgTemp, adminId);
            return result;
        }
        return Collections.emptyMap();
    }

    public UserOrgBO queryOrgByUser(Long userId) {
        UserOrgBO userOrgBO = new UserOrgBO();
        userOrgBO.setUserId(userId);
        Boolean enabled = this.employeeRepoProc.getEnabledByUserId(userId);
        if (!Boolean.TRUE.equals(enabled)) {
            return userOrgBO;
        }
        List<List<SysOrgBasicDTO>> orgWithParents = this.queryOrgWithParentsByUser(userId);
        if (orgWithParents.isEmpty()) {
            userOrgBO.setOrgList(Collections.emptyList());
            return userOrgBO;
        }
        Long defOrgId = this.employeeOrgRepoProc.getDefOrgByUserId(userId);
        List<SysOrgBasicDTO> orgList = orgWithParents.stream().map(t -> (SysOrgBasicDTO)t.get(t.size() - 1)).collect(Collectors.toList());
        userOrgBO.setOrgList(orgList);
        if (defOrgId == null) {
            userOrgBO.setOrg(orgList.get(0));
        } else {
            SysOrgBasicDTO defOrg = orgList.stream().filter(t -> defOrgId.longValue() == t.getId().longValue()).findFirst().orElse(orgList.get(0));
            userOrgBO.setOrg(defOrg);
        }
        List<SysOrgBasicDTO> firstOrgs = orgWithParents.get(0);
        Set<Long> firstOrgIds = firstOrgs.stream().map(SysOrgBasicDTO::getId).collect(Collectors.toSet());
        Map<Long, Long> tenantAdminIdMap = this.queryTenantOrgAdmin(firstOrgIds);
        if (!tenantAdminIdMap.isEmpty()) {
            Long adminId = null;
            SysOrgBasicDTO orgTemp = null;
            for (int i = firstOrgs.size() - 1; i >= 0; --i) {
                orgTemp = firstOrgs.get(i);
                adminId = tenantAdminIdMap.get(orgTemp.getId());
                if (!tenantAdminIdMap.containsKey(orgTemp.getId())) continue;
                userOrgBO.setTenantOrg(orgTemp);
                userOrgBO.setTenantOrgAdminId(adminId);
                break;
            }
        }
        return userOrgBO;
    }

    public IdCodeNameParam getPositionOfUser(Long userId, Long orgId) {
        return this.employeeOrgRepoProc.getPositionByUserIdAndOrg(userId, orgId);
    }

    public Map<Long, Long> queryTenantOrgAdmin(Set<Long> orgIds) {
        return this.tenantOrgRepoProc.queryAdmin(orgIds);
    }

    public Set<Long> queryChildrenOrgId(GeneralUserDetails currentUser) {
        if (currentUser == null) {
            currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        }
        if (currentUser.isSystemAdmin()) {
            return Collections.emptySet();
        }
        if (currentUser.isTenantAdmin()) {
            return this.orgRepoProc.queryAllOrgIds(currentUser.getTenantId(), true);
        }
        if (currentUser.isTenantOrgAdmin()) {
            return this.orgRepoProc.queryOrgIdsByBelong(currentUser.getTenantOrgId(), true);
        }
        return currentUser.getOrgId() == null ? Collections.emptySet() : this.orgRepoProc.queryOrgIdsByBelong(currentUser.getOrgId(), true);
    }

    public boolean hasPermissionOfMng(GeneralUserDetails currentUser, @NotEmpty Collection<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return true;
        }
        if (currentUser == null) {
            currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        }
        if (currentUser.isSystemAdmin()) {
            return true;
        }
        Set<Long> permissionOrgIds = this.queryChildrenOrgId(currentUser);
        if (permissionOrgIds.isEmpty()) {
            return false;
        }
        for (Long orgId : orgIds) {
            if (permissionOrgIds.contains(orgId)) continue;
            return false;
        }
        return true;
    }
}

