/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.manager;

import com.elitescloud.boot.common.param.TreeRespParam;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.constant.OrgTreeNodeType;
import com.elitescloud.cloudt.context.util.CollectionUtil;
import com.elitescloud.cloudt.context.util.TreeDataUtil;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.resp.OrgTreeNodeRespVO;
import com.elitescloud.cloudt.system.service.repo.EmployeeRepoProc;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
public class OrgTreeManager {
    @Autowired
    private OrgRepoProc orgRepoProc;
    @Autowired
    private EmployeeRepoProc employeeRepoProc;
    @Autowired
    private RedisUtils redisUtils;

    public List<OrgTreeNodeRespVO> getTreeCacheable(Long orgIdBelong, boolean tree, boolean includeDisabled, boolean includeEmployee) {
        StringJoiner keyJoiner = new StringJoiner("__").add("orgIdBelong=" + (orgIdBelong == null ? "" : orgIdBelong.toString())).add("tree=" + tree).add("includeDisabled=" + includeDisabled).add("includeEmployee=" + includeEmployee);
        String key = keyJoiner.toString();
        Object result = this.redisUtils.hget("cloudtSystemOrgTree", key);
        if (result != null) {
            return (List)result;
        }
        List<OrgTreeNodeRespVO> treeData = this.getTree(orgIdBelong, tree, includeDisabled, includeEmployee);
        this.redisUtils.hset("cloudtSystemOrgTree", key, treeData);
        return treeData;
    }

    public List<OrgTreeNodeRespVO> getTree(Long orgIdBelong, boolean tree, boolean includeDisabled, boolean includeEmployee) {
        TreeDataUtil treeDataUtil;
        List<OrgTreeNodeRespVO> orgList = this.orgRepoProc.getOrgTree(orgIdBelong, includeDisabled);
        if (orgList.isEmpty()) {
            return orgList;
        }
        List employeeNodeList = null;
        if (includeEmployee) {
            Map<Long, String> orgIdCodeMap = orgList.stream().collect(Collectors.toMap(TreeRespParam::getId, TreeRespParam::getCode, (t1, t2) -> t1));
            employeeNodeList = this.employeeRepoProc.queryEmployee(null, orgIdBelong, null, includeDisabled).stream().filter(t -> t.getOrgId() != null).map(t -> this.employee2OrgTreeNode((SysEmployeeBasicDTO)t, orgIdCodeMap)).collect(Collectors.toList());
            orgList.addAll(employeeNodeList);
        }
        if (tree) {
            treeDataUtil = new TreeDataUtil(orgList, TreeRespParam::getId, TreeRespParam::getParentId, TreeRespParam::setChildren, Comparator.comparingInt(TreeRespParam::getSortNo));
            List roots = treeDataUtil.getRoots();
            for (OrgTreeNodeRespVO root : roots) {
                root.setParentCode(null);
                root.setParentId(Long.valueOf(-1L));
            }
            return roots;
        }
        treeDataUtil = new TreeDataUtil(orgList, TreeRespParam::getId, TreeRespParam::getParentId, TreeRespParam::setChildren);
        List roots = treeDataUtil.getRoots();
        for (OrgTreeNodeRespVO root : roots) {
            root.setParentCode(null);
            root.setParentId(Long.valueOf(-1L));
        }
        return CollectionUtil.expandTree((List)roots, TreeRespParam::getChildren);
    }

    public List<OrgTreeNodeRespVO> getTreeAsync(Long parentId, boolean includeDisabled, boolean includeEmployee) {
        List<OrgTreeNodeRespVO> orgList;
        if (parentId == null) {
            parentId = -1L;
        }
        if ((orgList = this.orgRepoProc.getOrgTreeByParentId(parentId, includeDisabled)).isEmpty()) {
            if (parentId == -1L) {
                return orgList;
            }
            if (includeEmployee) {
                String orgCode = this.orgRepoProc.getCodeById(parentId);
                HashMap<Long, String> orgIdCodeMap = new HashMap<Long, String>(4);
                orgIdCodeMap.put(parentId, orgCode);
                return this.employeeRepoProc.queryEmployee(parentId, null, null, includeDisabled).stream().map(t -> this.employee2OrgTreeNode((SysEmployeeBasicDTO)t, (Map<Long, String>)orgIdCodeMap)).collect(Collectors.toList());
            }
        }
        if (includeEmployee) {
            Set<Long> orgIdOfNoChild = orgList.stream().filter(t -> t.getHasChildren() == false).map(TreeRespParam::getId).collect(Collectors.toSet());
            if (!orgIdOfNoChild.isEmpty()) {
                Map<Long, Integer> countMap = this.employeeRepoProc.countEmployee(orgIdOfNoChild, includeDisabled);
                for (OrgTreeNodeRespVO respVO : orgList) {
                    if (respVO.getHasChildren().booleanValue()) continue;
                    respVO.setHasChildren(Boolean.valueOf(countMap.getOrDefault(respVO.getId(), 0) > 0));
                }
            }
            String orgCode = this.orgRepoProc.getCodeById(parentId);
            HashMap<Long, String> orgIdCodeMap = new HashMap<Long, String>(4);
            orgIdCodeMap.put(parentId, orgCode);
            List employeeList = this.employeeRepoProc.queryEmployee(parentId, null, null, includeDisabled).stream().map(t -> this.employee2OrgTreeNode((SysEmployeeBasicDTO)t, (Map<Long, String>)orgIdCodeMap)).collect(Collectors.toList());
            orgList.addAll(employeeList);
        }
        return orgList;
    }

    public void clearCache() {
        this.redisUtils.hdel("cloudtSystemOrgTree");
    }

    private OrgTreeNodeRespVO employee2OrgTreeNode(SysEmployeeBasicDTO employee, Map<Long, String> orgIdCodeMap) {
        OrgTreeNodeRespVO respVO = new OrgTreeNodeRespVO();
        respVO.setId(employee.getId());
        respVO.setCode(employee.getCode());
        respVO.setName(employee.getFullName() + "[" + employee.getCode() + "]");
        respVO.setRealName(employee.getFullName());
        respVO.setNodeType(OrgTreeNodeType.EMPLOYEE.getValue());
        respVO.setNodeTypeName(OrgTreeNodeType.EMPLOYEE.getDescription());
        respVO.setDataType(employee.getType());
        respVO.setSortNo(employee.getSortNo());
        respVO.setParentId(employee.getOrgId());
        respVO.setParentCode(orgIdCodeMap.get(employee.getOrgId()));
        respVO.setHasChildren(Boolean.valueOf(false));
        respVO.setChildren(Collections.emptyList());
        respVO.setUserId(employee.getUserId());
        return respVO;
    }
}

