/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.manager;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.system.service.common.constant.SyncDataType;
import com.elitescloud.cloudt.system.service.convert.SysSyncConvert;
import com.elitescloud.cloudt.system.service.model.bo.SysSyncSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysSyncDO;
import com.elitescloud.cloudt.system.service.repo.SyncRepoProc;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SysSyncManager {
    @Autowired
    private SyncRepoProc syncRepoProc;

    @Transactional(rollbackFor={Exception.class})
    public Long save(SysSyncSaveBO saveBO) {
        Assert.notNull((Object)saveBO, (String)"\u4fdd\u5b58\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        SysSyncDO syncDO = this.saveBo2Do(saveBO);
        if (Boolean.FALSE.equals(syncDO.getSyncSuccess())) {
            syncDO.setOuterDataKey(null);
        }
        this.syncRepoProc.save((Serializable)syncDO);
        return syncDO.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateSyncResult(long id, boolean success, String outerDataKey, String failReason) {
        this.syncRepoProc.updateSyncResult(id, success, outerDataKey, failReason);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(@NotNull SyncDataType dataType, @NotBlank String dataKey, String outerApp) {
        Assert.notNull((Object)dataKey, (String)"\u6570\u636e\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)dataKey, (String)"\u6570\u636e\u6807\u8bc6\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)outerApp, (String)"\u5916\u90e8\u7cfb\u7edf\u6807\u8bc6\u4e3a\u7a7a", (Object[])new Object[0]);
        this.syncRepoProc.delete(dataType.name(), dataKey, outerApp);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(long id) {
        this.syncRepoProc.delete(id);
    }

    private SysSyncDO saveBo2Do(SysSyncSaveBO saveBO) {
        SysSyncDO syncDO = SysSyncConvert.INSTANCE.bo2DO(saveBO);
        Assert.notBlank((CharSequence)syncDO.getDataType(), (String)"\u540c\u6b65\u7684\u6570\u636e\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)syncDO.getDataKey(), (String)"\u540c\u6b65\u7684\u6570\u636e\u552f\u4e00\u6807\u8bc6\u4e3a\u7a7a", (Object[])new Object[0]);
        ObjUtil.ifNull((Object)syncDO.getSyncOuter(), (Object)true, arg_0 -> ((SysSyncDO)syncDO).setSyncOuter(arg_0));
        Assert.notBlank((CharSequence)syncDO.getOuterApp(), (String)"\u5916\u90e8\u7cfb\u7edf\u6807\u8bc6\u4e3a\u7a7a", (Object[])new Object[0]);
        ObjUtil.ifNull((Object)syncDO.getSyncDataTime(), LocalDateTime::now, arg_0 -> ((SysSyncDO)syncDO).setSyncDataTime(arg_0));
        ObjUtil.ifNull((Object)syncDO.getManual(), (Object)true, arg_0 -> ((SysSyncDO)syncDO).setManual(arg_0));
        ObjUtil.ifNull((Object)syncDO.getSyncSuccess(), (Object)false, arg_0 -> ((SysSyncDO)syncDO).setSyncSuccess(arg_0));
        return syncDO;
    }
}

