/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.boot.model.dto.SysBusinessOperationDTO;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.convert.BusinessObjectConvert;
import com.elitescloud.cloudt.system.model.bo.BusinessOperationBO;
import com.elitescloud.cloudt.system.model.bo.OperationRequestInfoBO;
import com.elitescloud.cloudt.system.model.vo.query.businessobject.BusinessOperationPageQueryVO;
import com.elitescloud.cloudt.system.service.common.constant.OpenApiSourceEnum;
import com.elitescloud.cloudt.system.service.model.entity.QSysBusinessObjectDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysBusinessOperationDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformAppDO;
import com.elitescloud.cloudt.system.service.model.entity.SysBusinessOperationDO;
import com.google.common.base.Functions;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Repository
public class BusinessOperationRepoProc
extends BaseRepoProc<SysBusinessOperationDO> {
    private static final QSysBusinessOperationDO QDO = QSysBusinessOperationDO.sysBusinessOperationDO;

    public BusinessOperationRepoProc() {
        super((EntityPathBase)QDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteForGatherByOpenApiCode(@NotBlank String openApiCode) {
        BooleanExpression predicate = BusinessOperationRepoProc.QDO.openApiCode.eq((Object)openApiCode).and((Predicate)BusinessOperationRepoProc.QDO.dataSource.in((Object[])new String[]{OpenApiSourceEnum.GATHER_PULL.name(), OpenApiSourceEnum.GATHER_PUSH.name()}));
        super.delete((Predicate)predicate);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByCodes(@NotBlank String openApiCode, @NotEmpty Collection<String> operationCodes) {
        super.delete((Predicate)BusinessOperationRepoProc.QDO.operationCode.in(operationCodes).and((Predicate)BusinessOperationRepoProc.QDO.openApiCode.eq((Object)openApiCode)));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByBusinessObjectId(long businessObjectId) {
        super.delete((Predicate)BusinessOperationRepoProc.QDO.businessObjectId.eq((Object)businessObjectId));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByBusinessObjectId(Collection<Long> businessObjectIds) {
        super.delete((Predicate)BusinessOperationRepoProc.QDO.businessObjectId.in(businessObjectIds));
    }

    public String getPermissionRefByOperationCode(@NotBlank String operationCode) {
        return (String)super.getValueByValue((Path)BusinessOperationRepoProc.QDO.permissionRef, (Path)BusinessOperationRepoProc.QDO.operationCode, (Object)operationCode);
    }

    public String getBusinessObjectCodeByOperationCode(@NotBlank String operationCode) {
        return (String)super.getValueByValue((Path)BusinessOperationRepoProc.QDO.businessObjectCode, (Path)BusinessOperationRepoProc.QDO.operationCode, (Object)operationCode);
    }

    public Map<String, Long> getIdAndCodeByOpenApiCode(@NotBlank String openApiCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{BusinessOperationRepoProc.QDO.id, BusinessOperationRepoProc.QDO.operationCode}).from((EntityPath)QDO)).where((Predicate)BusinessOperationRepoProc.QDO.openApiCode.eq((Object)openApiCode))).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)BusinessOperationRepoProc.QDO.operationCode), t -> (Long)t.get((Expression)BusinessOperationRepoProc.QDO.id), (t1, t2) -> t1));
    }

    public Map<Long, Long> countByBusinessObject(Collection<Long> businessObjectIds) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{BusinessOperationRepoProc.QDO.businessObjectId, BusinessOperationRepoProc.QDO.businessObjectId.count()}).from((EntityPath)QDO)).where((Predicate)BusinessOperationRepoProc.QDO.businessObjectId.in(businessObjectIds))).groupBy((Expression)BusinessOperationRepoProc.QDO.businessObjectId)).fetch().stream().collect(Collectors.toMap(t -> (Long)t.get((Expression)BusinessOperationRepoProc.QDO.businessObjectId), t -> (Long)t.get((Expression)BusinessOperationRepoProc.QDO.businessObjectId.count()), (t1, t2) -> t1));
    }

    public Map<Long, Long> countBusinessObjectOfPermissionEnabled() {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{BusinessOperationRepoProc.QDO.businessObjectId, BusinessOperationRepoProc.QDO.businessObjectId.count()}).from((EntityPath)QDO)).where(this.predicateForPermission())).groupBy((Expression)BusinessOperationRepoProc.QDO.businessObjectId)).fetch().stream().collect(Collectors.toMap(t -> (Long)t.get((Expression)BusinessOperationRepoProc.QDO.businessObjectId), t -> (Long)t.get((Expression)BusinessOperationRepoProc.QDO.businessObjectId.count()), (t1, t2) -> t1));
    }

    public BusinessOperationBO getSimpleBO(@NotBlank String operationCode) {
        return (BusinessOperationBO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanSimpleBO()).from((EntityPath)QDO)).where((Predicate)BusinessOperationRepoProc.QDO.operationCode.eq((Object)operationCode))).limit(1L)).fetchOne();
    }

    public List<SysBusinessOperationDO> listByOpenApiCode(@NotBlank String openApiCode) {
        return super.getList((Predicate)BusinessOperationRepoProc.QDO.openApiCode.eq((Object)openApiCode), new OrderSpecifier[0]);
    }

    public List<SysBusinessOperationDO> listByBusinessObjectCode(@NotBlank String businessObjectCode) {
        return super.getListByValue((Path)BusinessOperationRepoProc.QDO.businessObjectCode, (Object)businessObjectCode, new OrderSpecifier[0]);
    }

    public List<IdCodeNameParam> listByBusinessObjectId(long businessObjectId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{BusinessOperationRepoProc.QDO.id, BusinessOperationRepoProc.QDO.operationCode, BusinessOperationRepoProc.QDO.operationDescription, BusinessOperationRepoProc.QDO.customName}).from((EntityPath)QDO)).where((Predicate)BusinessOperationRepoProc.QDO.businessObjectId.eq((Object)businessObjectId))).fetch().stream().map(t -> new IdCodeNameParam((Long)t.get((Expression)BusinessOperationRepoProc.QDO.id), (String)t.get((Expression)BusinessOperationRepoProc.QDO.operationCode), CharSequenceUtil.blankToDefault((CharSequence)((CharSequence)t.get((Expression)BusinessOperationRepoProc.QDO.customName)), (String)((String)t.get((Expression)BusinessOperationRepoProc.QDO.operationDescription))))).collect(Collectors.toList());
    }

    public PagingVO<SysBusinessOperationDO> pageMng(BusinessOperationPageQueryVO queryVO) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)BusinessOperationRepoProc.QDO.businessObjectId, (Object)queryVO.getBusinessObjectId()).andLike((StringExpression)BusinessOperationRepoProc.QDO.operationCode, queryVO.getOperationCode()).andLike((StringExpression)BusinessOperationRepoProc.QDO.operationDescription, queryVO.getOperationDescription()).andLike((StringExpression)BusinessOperationRepoProc.QDO.apiUrl, queryVO.getApiUrl()).andEq((SimpleExpression)BusinessOperationRepoProc.QDO.permissionEnabled, (Object)queryVO.getPermissionEnabled()).build();
        return super.queryByPage(predicate, queryVO.getPageRequest());
    }

    public List<BusinessOperationBO> listSimpleByAppCode(@NotEmpty Collection<String> appCodes, Boolean enabled, boolean permissionOnly) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)BusinessOperationRepoProc.QDO.appCode, appCodes).and(permissionOnly, this::predicateForPermission).andEq((SimpleExpression)BusinessOperationRepoProc.QDO.enabled, (Object)enabled).build();
        List dataList = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanSimpleBO()).from((EntityPath)QDO)).where(predicate)).fetch();
        this.fillOperationBo(dataList, predicate);
        return dataList;
    }

    public List<BusinessOperationBO> listSimple(@NotEmpty Collection<String> operationCodes, Boolean enabled) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)BusinessOperationRepoProc.QDO.permissionRef, operationCodes).andEq((SimpleExpression)BusinessOperationRepoProc.QDO.enabled, (Object)enabled).build();
        List dataList = super.getList(this.qBeanSimpleBO(), predicate, new OrderSpecifier[0]);
        this.fillOperationBo(dataList, predicate);
        return dataList;
    }

    public List<OperationRequestInfoBO> listRequestInfo(@NotEmpty Collection<String> operationCodes, Boolean enabled) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)BusinessOperationRepoProc.QDO.operationCode, operationCodes).andEq((SimpleExpression)BusinessOperationRepoProc.QDO.enabled, (Object)enabled).build();
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanRequestInfoBO()).from((EntityPath)QDO)).where(predicate)).fetch();
    }

    public List<BusinessOperationBO> listSimpleByRef(@NotEmpty Collection<String> operationCodes) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)BusinessOperationRepoProc.QDO.permissionRef, operationCodes).andEq((SimpleExpression)BusinessOperationRepoProc.QDO.enabled, (Object)true).andEq((SimpleExpression)BusinessOperationRepoProc.QDO.permissionEnabled, (Object)true).build();
        List dataList = super.getList(this.qBeanSimpleBO(), predicate, new OrderSpecifier[0]);
        this.fillOperationBo(dataList, predicate);
        return dataList;
    }

    public List<BusinessOperationBO> listSimpleByType(boolean permissionOnly) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().and(permissionOnly, this::predicateForPermission).build();
        List dataList = super.getList(this.qBeanSimpleBO(), predicate, new OrderSpecifier[0]);
        this.fillOperationBo(dataList, predicate);
        return dataList;
    }

    public List<BusinessOperationBO> listSimpleByBusinessObjectCodes(@NotEmpty Collection<String> businessObjectCodes) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)BusinessOperationRepoProc.QDO.businessObjectCode, businessObjectCodes).build();
        return super.getList(this.qBeanSimpleBO(), predicate, new OrderSpecifier[0]);
    }

    public List<SysBusinessOperationDTO> allDtoList(Boolean enabled) {
        return super.all().stream().filter(t -> {
            if (enabled == null) {
                return true;
            }
            return t.getEnabled() == enabled;
        }).map(t -> {
            SysBusinessOperationDTO operationDTO = BusinessObjectConvert.INSTANCE.do2Dto((SysBusinessOperationDO)t);
            operationDTO.setOperationDescription(CharSequenceUtil.blankToDefault((CharSequence)t.getCustomName(), (String)t.getOperationDescription()));
            return operationDTO;
        }).collect(Collectors.toList());
    }

    public Map<String, String> getNamesByBusinessObject(@NotEmpty Collection<String> businessObjectCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{BusinessOperationRepoProc.QDO.operationCode, BusinessOperationRepoProc.QDO.customName, BusinessOperationRepoProc.QDO.operationDescription}).from((EntityPath)QDO)).where((Predicate)BusinessOperationRepoProc.QDO.businessObjectCode.in(businessObjectCodes))).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)BusinessOperationRepoProc.QDO.operationCode), t -> CharSequenceUtil.blankToDefault((CharSequence)((CharSequence)t.get((Expression)BusinessOperationRepoProc.QDO.customName)), (String)((String)t.get((Expression)BusinessOperationRepoProc.QDO.operationDescription))), (t1, t2) -> t1));
    }

    private void fillOperationBo(List<BusinessOperationBO> operationList, Predicate predicate) {
        Set businessObjectCodes;
        if (operationList.isEmpty()) {
            return;
        }
        boolean existsRef = operationList.stream().map(BusinessOperationBO::getPermissionRef).anyMatch(StringUtils::hasText);
        if (existsRef) {
            Map<String, String> operationCodeNameMap = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{BusinessOperationRepoProc.QDO.operationCode, BusinessOperationRepoProc.QDO.operationDescription, BusinessOperationRepoProc.QDO.customName}).from((EntityPath)QDO)).where(predicate)).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)BusinessOperationRepoProc.QDO.operationCode), t -> CharSequenceUtil.blankToDefault((CharSequence)((CharSequence)t.get((Expression)BusinessOperationRepoProc.QDO.customName)), (String)((String)t.get((Expression)BusinessOperationRepoProc.QDO.operationDescription))), (t1, t2) -> t1));
            operationList.parallelStream().filter(t -> StringUtils.hasText((String)t.getPermissionRef())).forEach(t -> t.setPermissionRefName((String)operationCodeNameMap.get(t.getPermissionRef())));
        }
        if (!(businessObjectCodes = operationList.stream().map(BusinessOperationBO::getBusinessObjectCode).collect(Collectors.toSet())).isEmpty()) {
            QSysBusinessObjectDO QDO_BO = QSysBusinessObjectDO.sysBusinessObjectDO;
            QSysPlatformAppDO QDO_APP = QSysPlatformAppDO.sysPlatformAppDO;
            Map obMap = ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{QDO_BO.code, QDO_BO.name, QDO_BO.customName, QDO_APP.appName}).from((EntityPath)QDO_BO)).leftJoin((EntityPath)QDO_APP)).on((Predicate)QDO_APP.appCode.eq((Expression)QDO_BO.appCode))).where((Predicate)QDO_BO.code.in(businessObjectCodes))).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)QDO_BO.code), Functions.identity(), (t1, t2) -> t1));
            for (BusinessOperationBO operationBO : operationList) {
                ObjUtil.ifNotNull((Object)((Tuple)obMap.get(operationBO.getBusinessObjectCode())), tuple -> {
                    operationBO.setBusinessObjectName(CharSequenceUtil.blankToDefault((CharSequence)((CharSequence)tuple.get((Expression)QDO_BO.customName)), (String)((String)tuple.get((Expression)QDO_BO.name))));
                    operationBO.setAppName((String)tuple.get((Expression)QDO_APP.appName));
                });
            }
        }
    }

    private Predicate predicateForPermission() {
        return BusinessOperationRepoProc.QDO.operationType.in((Object[])SysBusinessOperationDO.TYPES_SELECT).and((Predicate)BusinessOperationRepoProc.QDO.permissionEnabled.eq(Boolean.valueOf(true)).or((Predicate)BusinessOperationRepoProc.QDO.fieldPermissionAutoFilter.eq(Boolean.valueOf(true))));
    }

    private QBean<BusinessOperationBO> qBeanSimpleBO() {
        return Projections.bean(BusinessOperationBO.class, (Expression[])new Expression[]{BusinessOperationRepoProc.QDO.id, BusinessOperationRepoProc.QDO.businessObjectCode, BusinessOperationRepoProc.QDO.businessObjectId, BusinessOperationRepoProc.QDO.operationCode, BusinessOperationRepoProc.QDO.appCode, BusinessOperationRepoProc.QDO.operationDescription, BusinessOperationRepoProc.QDO.customName, BusinessOperationRepoProc.QDO.displayOrder, BusinessOperationRepoProc.QDO.apiName, BusinessOperationRepoProc.QDO.apiDescription, BusinessOperationRepoProc.QDO.apiUrl, BusinessOperationRepoProc.QDO.apiMethod, BusinessOperationRepoProc.QDO.enabled, BusinessOperationRepoProc.QDO.permissionEnabled, BusinessOperationRepoProc.QDO.permissionRef});
    }

    private QBean<OperationRequestInfoBO> qBeanRequestInfoBO() {
        return Projections.bean(OperationRequestInfoBO.class, (Expression[])new Expression[]{BusinessOperationRepoProc.QDO.operationCode, BusinessOperationRepoProc.QDO.apiMethod, BusinessOperationRepoProc.QDO.apiUrl, BusinessOperationRepoProc.QDO.permissionRef});
    }
}

