/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.bo.BusinessParamBO;
import com.elitescloud.cloudt.system.service.model.entity.QSysBusinessObjectDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysBusinessOperationDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysBusinessParamDO;
import com.elitescloud.cloudt.system.service.model.entity.SysBusinessParamDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class BusinessParamRepoProc
extends BaseRepoProc<SysBusinessParamDO> {
    private static final QSysBusinessParamDO QDO = QSysBusinessParamDO.sysBusinessParamDO;
    private static final QSysBusinessObjectDO QDO_BUSINESS_OBJECT = QSysBusinessObjectDO.sysBusinessObjectDO;
    private static final QSysBusinessOperationDO QDO_OPERATION = QSysBusinessOperationDO.sysBusinessOperationDO;
    private static final QSysBusinessOperationDO QDO_BUSINESS_OPERATION = QSysBusinessOperationDO.sysBusinessOperationDO;

    public BusinessParamRepoProc() {
        super((EntityPathBase)QDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteForGatherByOpenApiCode(@NotBlank String openApiCode) {
        BooleanExpression subExpression = ((JPQLQuery)JPAExpressions.select((Expression)BusinessParamRepoProc.QDO_BUSINESS_OPERATION.id).from(new EntityPath[]{QDO_BUSINESS_OPERATION}).where(new Predicate[]{BusinessParamRepoProc.QDO_BUSINESS_OPERATION.id.eq((Expression)BusinessParamRepoProc.QDO.businessOperationId)})).notExists();
        super.delete((Predicate)BusinessParamRepoProc.QDO.openApiCode.eq((Object)openApiCode).and((Predicate)BusinessParamRepoProc.QDO.businessOperationId.eq((Object)-1L).or((Predicate)subExpression)));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByBusinessObject(long businessObjectId, Long operationId) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)BusinessParamRepoProc.QDO.businessObjectId, (Object)businessObjectId).andEq((SimpleExpression)BusinessParamRepoProc.QDO.businessOperationId, (Object)operationId).build();
        super.delete(predicate);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteForOperation(long businessObjectId) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)BusinessParamRepoProc.QDO.businessObjectId, (Object)businessObjectId).andNe((SimpleExpression)BusinessParamRepoProc.QDO.businessOperationId, (Object)-1L).build();
        super.delete(predicate);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteForOperation(Collection<Long> businessObjectIds) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)BusinessParamRepoProc.QDO.businessObjectId, businessObjectIds).andNe((SimpleExpression)BusinessParamRepoProc.QDO.businessOperationId, (Object)-1L).build();
        super.delete(predicate);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByBusinessObject(Collection<Long> businessObjectIds) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)BusinessParamRepoProc.QDO.businessObjectId, businessObjectIds).build();
        super.delete(predicate);
    }

    public void updateDataPermissionEnabled(long id, boolean enabled) {
        super.updateValue((Path)BusinessParamRepoProc.QDO.dataPermissionEnabled, (Object)enabled, id);
    }

    public void updateFieldPermissionEnabled(long id, boolean enabled) {
        super.updateValue((Path)BusinessParamRepoProc.QDO.fieldPermissionEnabled, (Object)enabled, id);
    }

    public List<SysBusinessParamDO> listByOpenApiCode(@NotBlank String openApiCode) {
        return super.getList((Predicate)BusinessParamRepoProc.QDO.openApiCode.eq((Object)openApiCode), new OrderSpecifier[0]);
    }

    public List<SysBusinessParamDO> listByBusinessObjectId(long businessObjectId) {
        return super.getList((Predicate)BusinessParamRepoProc.QDO.businessObjectId.eq((Object)businessObjectId), new OrderSpecifier[0]);
    }

    public List<SysBusinessParamDO> listByBusinessObjectId(long businessObjectId, Collection<String> fieldNames) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)BusinessParamRepoProc.QDO.businessObjectId, (Object)businessObjectId).andIn((SimpleExpression)BusinessParamRepoProc.QDO.fieldName, fieldNames).build();
        return super.getList(predicate, new OrderSpecifier[]{BusinessParamRepoProc.QDO.sortNo.asc()});
    }

    public List<BusinessParamBO> listSimpleBoByBusinessObjectCode(@NotBlank String businessObjectCode) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq(true, (SimpleExpression)BusinessParamRepoProc.QDO.businessObjectId, (SubQueryExpression)JPAExpressions.select((Expression)BusinessParamRepoProc.QDO_BUSINESS_OBJECT.id).from(new EntityPath[]{QDO_BUSINESS_OBJECT}).where(new Predicate[]{BusinessParamRepoProc.QDO_BUSINESS_OBJECT.code.eq((Object)businessObjectCode)})).build();
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanSimpleBO()).from((EntityPath)QDO)).where(predicate)).orderBy(BusinessParamRepoProc.QDO.sortNo.asc())).fetch();
    }

    public List<BusinessParamBO> listSimpleBoByBusinessObjectCode(@NotBlank String businessObjectCode, @NotBlank String appCode) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq(true, (SimpleExpression)BusinessParamRepoProc.QDO.businessObjectId, (SubQueryExpression)JPAExpressions.select((Expression)BusinessParamRepoProc.QDO_BUSINESS_OBJECT.id).from(new EntityPath[]{QDO_BUSINESS_OBJECT}).where(new Predicate[]{BusinessParamRepoProc.QDO_BUSINESS_OBJECT.code.eq((Object)businessObjectCode).and((Predicate)BusinessParamRepoProc.QDO_BUSINESS_OBJECT.appCode.eq((Object)appCode))})).build();
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanSimpleBO()).from((EntityPath)QDO)).where(predicate)).orderBy(BusinessParamRepoProc.QDO.sortNo.asc())).fetch();
    }

    public List<BusinessParamBO> listRelatedFieldByBusinessObjectCode(@NotBlank String businessObjectCode) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq(true, (SimpleExpression)BusinessParamRepoProc.QDO.businessObjectId, (SubQueryExpression)JPAExpressions.select((Expression)BusinessParamRepoProc.QDO_BUSINESS_OBJECT.id).from(new EntityPath[]{QDO_BUSINESS_OBJECT}).where(new Predicate[]{BusinessParamRepoProc.QDO_BUSINESS_OBJECT.code.eq((Object)businessObjectCode)})).andNotNull(true, (SimpleExpression)BusinessParamRepoProc.QDO.relatedBusinessObject).build();
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanSimpleBO()).from((EntityPath)QDO)).where(predicate)).orderBy(BusinessParamRepoProc.QDO.sortNo.asc())).fetch();
    }

    public List<BusinessParamBO> listSimpleBoByRelatedBusinessObject(@NotBlank String businessObjectCode) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)BusinessParamRepoProc.QDO.relatedBusinessObject, (Object)businessObjectCode).andNotNull(true, (SimpleExpression)BusinessParamRepoProc.QDO.relatedField).build();
        return super.getList(this.qBeanSimpleBO(), predicate, new OrderSpecifier[0]);
    }

    public List<BusinessParamBO> listSimpleBoByBusinessObjectCode(@NotEmpty Collection<String> businessObjectCodes) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)BusinessParamRepoProc.QDO.businessObjectId, (SubQueryExpression)JPAExpressions.select((Expression)BusinessParamRepoProc.QDO_BUSINESS_OBJECT.id).from(new EntityPath[]{QDO_BUSINESS_OBJECT}).where(new Predicate[]{BusinessParamRepoProc.QDO_BUSINESS_OBJECT.code.in(businessObjectCodes)})).build();
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanSimpleBO()).from((EntityPath)QDO)).where(predicate)).orderBy(BusinessParamRepoProc.QDO.sortNo.asc())).fetch();
    }

    public List<BusinessParamBO> listSimpleBoByBusinessOperationCode(@NotBlank String operationCode, Collection<String> fieldNames) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq(true, (SimpleExpression)BusinessParamRepoProc.QDO.businessObjectId, (SubQueryExpression)JPAExpressions.select((Expression)BusinessParamRepoProc.QDO_OPERATION.businessObjectId).from(new EntityPath[]{QDO_OPERATION}).where(new Predicate[]{BusinessParamRepoProc.QDO_OPERATION.operationCode.eq((Object)operationCode)})).andIn((SimpleExpression)BusinessParamRepoProc.QDO.fieldName, fieldNames).build();
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanSimpleBO()).from((EntityPath)QDO)).where(predicate)).orderBy(BusinessParamRepoProc.QDO.sortNo.asc())).fetch();
    }

    public Map<String, Map<String, String>> getNamesByBusinessObject(@NotEmpty Collection<String> businessObjectCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{BusinessParamRepoProc.QDO.businessObjectCode, BusinessParamRepoProc.QDO.fieldName, BusinessParamRepoProc.QDO.fieldDescription, BusinessParamRepoProc.QDO.customDescription}).from((EntityPath)QDO)).where((Predicate)BusinessParamRepoProc.QDO.businessObjectCode.in(businessObjectCodes))).fetch().stream().collect(Collectors.groupingBy(t -> (String)t.get((Expression)BusinessParamRepoProc.QDO.businessObjectCode), Collectors.toMap(t -> (String)t.get((Expression)BusinessParamRepoProc.QDO.fieldName), t -> CharSequenceUtil.blankToDefault((CharSequence)((CharSequence)t.get((Expression)BusinessParamRepoProc.QDO.customDescription)), (String)CharSequenceUtil.blankToDefault((CharSequence)((CharSequence)t.get((Expression)BusinessParamRepoProc.QDO.fieldDescription)), (String)((String)t.get((Expression)BusinessParamRepoProc.QDO.fieldName)))), (t1, t2) -> t1)));
    }

    private QBean<BusinessParamBO> qBeanSimpleBO() {
        return Projections.bean(BusinessParamBO.class, (Expression[])new Expression[]{BusinessParamRepoProc.QDO.id, BusinessParamRepoProc.QDO.businessObjectCode, BusinessParamRepoProc.QDO.enabled, BusinessParamRepoProc.QDO.entityClassName, BusinessParamRepoProc.QDO.tableName, BusinessParamRepoProc.QDO.fieldName, BusinessParamRepoProc.QDO.fieldJavaType, BusinessParamRepoProc.QDO.subTable, BusinessParamRepoProc.QDO.relatedMasField, BusinessParamRepoProc.QDO.masField, BusinessParamRepoProc.QDO.fieldDescription, BusinessParamRepoProc.QDO.customDescription, BusinessParamRepoProc.QDO.relatedBusinessObject, BusinessParamRepoProc.QDO.relatedField, BusinessParamRepoProc.QDO.valuesJson, BusinessParamRepoProc.QDO.userType, BusinessParamRepoProc.QDO.dataPermissionEnabled, BusinessParamRepoProc.QDO.fieldPermissionEnabled, BusinessParamRepoProc.QDO.baseField});
    }
}

