/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.model.vo.extend.query.CurrencyPageQueryVO;
import com.elitescloud.cloudt.system.dto.req.SysCurrencyQueryDTO;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformCurrencyDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformCurrencyDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class CurrencyRepoProc
extends BaseRepoProc<SysPlatformCurrencyDO> {
    private static final QSysPlatformCurrencyDO QDO = QSysPlatformCurrencyDO.sysPlatformCurrencyDO;

    public CurrencyRepoProc() {
        super((EntityPathBase)QDO);
    }

    public PagingVO<SysPlatformCurrencyDO> pageMng(CurrencyPageQueryVO queryVO, Collection<String> currCodes) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andLike(StringUtils.hasText((String)queryVO.getCurrCode()), (StringExpression)CurrencyRepoProc.QDO.currCode, queryVO.getCurrCode()).andLike(StringUtils.hasText((String)queryVO.getCurrName()), (StringExpression)CurrencyRepoProc.QDO.currName, queryVO.getCurrName()).andEq(true, (SimpleExpression)CurrencyRepoProc.QDO.enabled, (Object)true).andIn(CollUtil.isNotEmpty(currCodes), (SimpleExpression)CurrencyRepoProc.QDO.currCode, currCodes).build();
        return super.queryByPage(predicate, queryVO.getPageRequest(), CurrencyRepoProc.QDO.createTime.desc());
    }

    public Map<String, String> getNameByCurrCode(@NotEmpty Collection<String> currCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{CurrencyRepoProc.QDO.currName, CurrencyRepoProc.QDO.currCode}).from((EntityPath)QDO)).where((Predicate)CurrencyRepoProc.QDO.currCode.in(currCodes))).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)CurrencyRepoProc.QDO.currCode), t -> (String)t.get((Expression)CurrencyRepoProc.QDO.currName), (t1, t2) -> t1));
    }

    public SysPlatformCurrencyDO getByCode(@NotBlank String code) {
        return (SysPlatformCurrencyDO)super.getOneByValue((Path)CurrencyRepoProc.QDO.currCode, (Object)code);
    }

    public List<SysPlatformCurrencyDO> getByCodes(@NotEmpty Collection<String> codes) {
        return super.getListByValue((Path)CurrencyRepoProc.QDO.currCode, codes, new OrderSpecifier[0]);
    }

    public List<SysPlatformCurrencyDO> queryList(SysCurrencyQueryDTO queryDTO) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)CurrencyRepoProc.QDO.currCode, (Object)queryDTO.getCurrCode()).andIn((SimpleExpression)CurrencyRepoProc.QDO.currCode, (Collection)queryDTO.getCurrCodes()).andEq((SimpleExpression)CurrencyRepoProc.QDO.enabled, (Object)queryDTO.getEnabled()).andLike((StringExpression)CurrencyRepoProc.QDO.currName, queryDTO.getCurrName()).build();
        return super.getList(predicate, new OrderSpecifier[0]).stream().sorted(Comparator.comparing(BaseModel::getCreateTime, Comparator.nullsLast(LocalDateTime::compareTo))).collect(Collectors.toList());
    }
}

