/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.bo.EmployeeOrgBO;
import com.elitescloud.cloudt.system.model.entity.QSysPositionDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysEmployeeDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysEmployeeOrgDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysOrgDO;
import com.elitescloud.cloudt.system.service.model.entity.SysEmployeeOrgDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotEmpty;
import org.springframework.stereotype.Repository;

@Repository
public class EmployeeOrgRepoProc
extends BaseRepoProc<SysEmployeeOrgDO> {
    private static final QSysEmployeeOrgDO QDO = QSysEmployeeOrgDO.sysEmployeeOrgDO;
    private static final QSysOrgDO QDO_ORG = QSysOrgDO.sysOrgDO;
    private static final QSysEmployeeDO QDO_EMP = QSysEmployeeDO.sysEmployeeDO;
    private static final QSysPositionDO QDO_POST = QSysPositionDO.sysPositionDO;

    public EmployeeOrgRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void updateLeader(long employeeId, long orgId, Long leaderEmployeeId, Long leaderUserId) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)EmployeeOrgRepoProc.QDO.leaderEmployeeId, (Object)leaderEmployeeId).set((Path)EmployeeOrgRepoProc.QDO.leaderUserId, (Object)leaderUserId).where(new Predicate[]{EmployeeOrgRepoProc.QDO.employeeId.eq((Object)employeeId).and((Predicate)EmployeeOrgRepoProc.QDO.orgId.eq((Object)orgId))}).execute();
    }

    public void updateUserIdOfEmployee(long employeeId, Long userId) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)EmployeeOrgRepoProc.QDO.userId, (Object)userId).where(new Predicate[]{EmployeeOrgRepoProc.QDO.employeeId.eq((Object)employeeId)}).execute();
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)EmployeeOrgRepoProc.QDO.leaderUserId, (Object)userId).where(new Predicate[]{EmployeeOrgRepoProc.QDO.leaderEmployeeId.eq((Object)employeeId)}).execute();
    }

    public void deleteByEmployeeId(long employeeId) {
        super.deleteByValue((Path)EmployeeOrgRepoProc.QDO.employeeId, (Object)employeeId);
    }

    public void deleteByLeaderEmployeeId(long employeeId) {
        super.deleteByValue((Path)EmployeeOrgRepoProc.QDO.leaderEmployeeId, (Object)employeeId);
    }

    public void deleteByOrgId(long orgId) {
        super.deleteByValue((Path)EmployeeOrgRepoProc.QDO.orgId, (Object)orgId);
    }

    public void delete(long employeeId, @NotEmpty Collection<Long> orgIds) {
        this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{EmployeeOrgRepoProc.QDO.employeeId.eq((Object)employeeId).and((Predicate)EmployeeOrgRepoProc.QDO.orgId.in(orgIds))}).execute();
    }

    public void delete(long employeeId, long orgId) {
        this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{EmployeeOrgRepoProc.QDO.employeeId.eq((Object)employeeId).and((Predicate)EmployeeOrgRepoProc.QDO.orgId.eq((Object)orgId))}).execute();
    }

    public boolean existsEmployee(long orgId) {
        return super.exists((Path)EmployeeOrgRepoProc.QDO.orgId, (Object)orgId);
    }

    public List<Long> getOrgIdByEmployeeId(long employeeId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)EmployeeOrgRepoProc.QDO.orgId).from((EntityPath)QDO)).where((Predicate)EmployeeOrgRepoProc.QDO.employeeId.eq((Object)employeeId))).fetch();
    }

    public List<Long> getOrgIdByUserId(long userId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)EmployeeOrgRepoProc.QDO.orgId).from((EntityPath)QDO)).where((Predicate)EmployeeOrgRepoProc.QDO.userId.eq((Object)userId))).fetch();
    }

    public List<SysEmployeeOrgDO> getEmployeeOrgByEmployeeId(long employeeId) {
        return super.getListByValue((Path)EmployeeOrgRepoProc.QDO.employeeId, (Object)employeeId, new OrderSpecifier[0]);
    }

    public Map<Long, Long> getEmployeeOrgIdAndLeaderId(long employeeId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{EmployeeOrgRepoProc.QDO.orgId, EmployeeOrgRepoProc.QDO.leaderUserId}).from((EntityPath)QDO)).where((Predicate)EmployeeOrgRepoProc.QDO.employeeId.eq((Object)employeeId).and((Predicate)EmployeeOrgRepoProc.QDO.leaderUserId.isNotNull()))).fetch().stream().collect(Collectors.toMap(t -> (Long)t.get((Expression)EmployeeOrgRepoProc.QDO.orgId), t -> (Long)t.get((Expression)EmployeeOrgRepoProc.QDO.leaderUserId), (t1, t2) -> t1));
    }

    public Map<Long, List<IdCodeNameParam>> getEmployeeOrgs(@NotEmpty Collection<Long> employeeIds, Boolean enabled) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)EmployeeOrgRepoProc.QDO.employeeId, employeeIds).andEq(enabled != null, (SimpleExpression)EmployeeOrgRepoProc.QDO_ORG.enabled, (Object)enabled).build();
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{EmployeeOrgRepoProc.QDO.employeeId, EmployeeOrgRepoProc.QDO_ORG.id, EmployeeOrgRepoProc.QDO_ORG.code, EmployeeOrgRepoProc.QDO_ORG.name, EmployeeOrgRepoProc.QDO.createTime}).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_ORG)).on((Predicate)EmployeeOrgRepoProc.QDO.orgId.eq((Expression)EmployeeOrgRepoProc.QDO_ORG.id))).where(predicate)).fetch().stream().collect(Collectors.groupingBy(t -> (Long)t.get((Expression)EmployeeOrgRepoProc.QDO.employeeId), Collectors.collectingAndThen(Collectors.toList(), t -> t.stream().sorted(Comparator.comparing(tt -> (LocalDateTime)tt.get((Expression)EmployeeOrgRepoProc.QDO.createTime), Comparator.nullsFirst(LocalDateTime::compareTo))).map(tt -> new IdCodeNameParam((Long)tt.get((Expression)EmployeeOrgRepoProc.QDO_ORG.id), (String)tt.get((Expression)EmployeeOrgRepoProc.QDO_ORG.code), (String)tt.get((Expression)EmployeeOrgRepoProc.QDO_ORG.name))).collect(Collectors.toList()))));
    }

    public Map<Long, List<IdCodeNameParam>> getOrgsByUserId(Collection<Long> userIds, Boolean enabled) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)EmployeeOrgRepoProc.QDO.userId, userIds).andEq((SimpleExpression)EmployeeOrgRepoProc.QDO_ORG.enabled, (Object)enabled).build();
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{EmployeeOrgRepoProc.QDO.userId, EmployeeOrgRepoProc.QDO.orgId, EmployeeOrgRepoProc.QDO_ORG.code, EmployeeOrgRepoProc.QDO_ORG.name}).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_ORG)).on((Predicate)EmployeeOrgRepoProc.QDO_ORG.id.eq((Expression)EmployeeOrgRepoProc.QDO.orgId))).where(predicate)).fetch().stream().collect(Collectors.groupingBy(t -> (Long)t.get((Expression)EmployeeOrgRepoProc.QDO.userId), Collectors.mapping(t -> new IdCodeNameParam((Long)t.get((Expression)EmployeeOrgRepoProc.QDO.orgId), (String)t.get((Expression)EmployeeOrgRepoProc.QDO_ORG.code), (String)t.get((Expression)EmployeeOrgRepoProc.QDO_ORG.name)), Collectors.toList())));
    }

    public List<Long> getUserIdByLeaderUserId(long leaderUserId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)EmployeeOrgRepoProc.QDO.userId).from((EntityPath)QDO)).where((Predicate)EmployeeOrgRepoProc.QDO.leaderUserId.eq((Object)leaderUserId))).fetch();
    }

    public List<EmployeeOrgBO> getLeaders(@NotEmpty Collection<Long> employeeIds) {
        QBean qBean = Projections.bean(EmployeeOrgBO.class, (Expression[])new Expression[]{EmployeeOrgRepoProc.QDO.employeeId.as("ownerId"), EmployeeOrgRepoProc.QDO_EMP.type.as("employeeType"), EmployeeOrgRepoProc.QDO.leaderUserId.as("userId"), EmployeeOrgRepoProc.QDO.leaderEmployeeId.as("employeeId"), EmployeeOrgRepoProc.QDO_EMP.code.as("employeeCode"), EmployeeOrgRepoProc.QDO_EMP.username, EmployeeOrgRepoProc.QDO_EMP.firstName, EmployeeOrgRepoProc.QDO_EMP.lastName, EmployeeOrgRepoProc.QDO.orgId, EmployeeOrgRepoProc.QDO_ORG.code.as("orgCode"), EmployeeOrgRepoProc.QDO_ORG.name.as("orgName"), EmployeeOrgRepoProc.QDO_ORG.type.as("orgType"), EmployeeOrgRepoProc.QDO.def, EmployeeOrgRepoProc.QDO.assignee, EmployeeOrgRepoProc.QDO.positionId, EmployeeOrgRepoProc.QDO_POST.positionCode, EmployeeOrgRepoProc.QDO_POST.positionName});
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qBean).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_EMP)).on((Predicate)EmployeeOrgRepoProc.QDO_EMP.id.eq((Expression)EmployeeOrgRepoProc.QDO.leaderEmployeeId))).leftJoin((EntityPath)QDO_ORG)).on((Predicate)EmployeeOrgRepoProc.QDO_ORG.id.eq((Expression)EmployeeOrgRepoProc.QDO.orgId))).leftJoin((EntityPath)QDO_POST)).on((Predicate)EmployeeOrgRepoProc.QDO_POST.id.eq((Expression)EmployeeOrgRepoProc.QDO.positionId))).where((Predicate)EmployeeOrgRepoProc.QDO.employeeId.in(employeeIds))).fetch();
    }

    public List<String> getUnderlingCodes(long employeeId, Boolean enabled) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)EmployeeOrgRepoProc.QDO.leaderEmployeeId, (Object)employeeId).and(enabled != null, () -> EmployeeOrgRepoProc.QDO_ORG.enabled.eq(enabled).and((Predicate)EmployeeOrgRepoProc.QDO_EMP.enabled.eq(enabled))).and((Predicate)QDO_ORG.isNotNull().and((Predicate)QDO_EMP.isNotNull())).build();
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)EmployeeOrgRepoProc.QDO_EMP.code).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_EMP)).on((Predicate)EmployeeOrgRepoProc.QDO_EMP.id.eq((Expression)EmployeeOrgRepoProc.QDO.employeeId))).leftJoin((EntityPath)QDO_ORG)).on((Predicate)EmployeeOrgRepoProc.QDO_ORG.id.eq((Expression)EmployeeOrgRepoProc.QDO.orgId))).where(predicate)).fetch();
    }

    public List<EmployeeOrgBO> getUnderlings(@NotEmpty Collection<Long> employeeIds, Boolean enabled) {
        QBean qBean = Projections.bean(EmployeeOrgBO.class, (Expression[])new Expression[]{EmployeeOrgRepoProc.QDO.leaderEmployeeId.as("ownerId"), EmployeeOrgRepoProc.QDO_EMP.type.as("employeeType"), EmployeeOrgRepoProc.QDO.userId, EmployeeOrgRepoProc.QDO.employeeId, EmployeeOrgRepoProc.QDO_EMP.code.as("employeeCode"), EmployeeOrgRepoProc.QDO_EMP.username, EmployeeOrgRepoProc.QDO_EMP.firstName, EmployeeOrgRepoProc.QDO_EMP.lastName, EmployeeOrgRepoProc.QDO.orgId, EmployeeOrgRepoProc.QDO_ORG.code.as("orgCode"), EmployeeOrgRepoProc.QDO_ORG.name.as("orgName"), EmployeeOrgRepoProc.QDO_ORG.type.as("orgType"), EmployeeOrgRepoProc.QDO.positionId, EmployeeOrgRepoProc.QDO_POST.positionCode, EmployeeOrgRepoProc.QDO_POST.positionName});
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)EmployeeOrgRepoProc.QDO.leaderEmployeeId, employeeIds).and(enabled != null, () -> EmployeeOrgRepoProc.QDO_ORG.enabled.eq(enabled).and((Predicate)EmployeeOrgRepoProc.QDO_EMP.enabled.eq(enabled))).build();
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qBean).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_EMP)).on((Predicate)EmployeeOrgRepoProc.QDO_EMP.id.eq((Expression)EmployeeOrgRepoProc.QDO.employeeId))).leftJoin((EntityPath)QDO_ORG)).on((Predicate)EmployeeOrgRepoProc.QDO_ORG.id.eq((Expression)EmployeeOrgRepoProc.QDO.orgId))).leftJoin((EntityPath)QDO_POST)).on((Predicate)EmployeeOrgRepoProc.QDO_POST.id.eq((Expression)EmployeeOrgRepoProc.QDO.positionId))).where(predicate)).fetch();
    }

    public Long getDefOrg(long employeeId) {
        return (Long)super.getValue((Path)EmployeeOrgRepoProc.QDO.orgId, (Predicate)EmployeeOrgRepoProc.QDO.employeeId.eq((Object)employeeId).and((Predicate)EmployeeOrgRepoProc.QDO.def.eq(Boolean.valueOf(true))), new OrderSpecifier[0]);
    }

    public Long getDefOrgByUserId(long userId) {
        return (Long)super.getValue((Path)EmployeeOrgRepoProc.QDO.orgId, (Predicate)EmployeeOrgRepoProc.QDO.userId.eq((Object)userId).and((Predicate)EmployeeOrgRepoProc.QDO.def.eq(Boolean.valueOf(true))), new OrderSpecifier[0]);
    }

    public IdCodeNameParam getPositionByUserIdAndOrg(long userId, long orgId) {
        QBean qbean = Projections.bean(IdCodeNameParam.class, (Expression[])new Expression[]{EmployeeOrgRepoProc.QDO.positionId.as("id"), EmployeeOrgRepoProc.QDO_POST.positionCode.as("code"), EmployeeOrgRepoProc.QDO_POST.positionName.as("name")});
        return (IdCodeNameParam)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qbean).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_POST)).on((Predicate)EmployeeOrgRepoProc.QDO_POST.id.eq((Expression)EmployeeOrgRepoProc.QDO.positionId))).where((Predicate)EmployeeOrgRepoProc.QDO.userId.eq((Object)userId).and((Predicate)EmployeeOrgRepoProc.QDO.orgId.eq((Object)orgId)).and((Predicate)EmployeeOrgRepoProc.QDO.positionId.isNotNull()))).limit(1L)).fetchOne();
    }
}

