/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.boot.datasecurity.common.DataSecurityUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeePageQueryDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeePageRespDTO;
import com.elitescloud.cloudt.system.model.entity.QSysPositionDO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonEmployeePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.org.EmployeeListQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.org.EmployeePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeeListRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeePagedRespVO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.QOrgBuTreeEmployeeDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysEmpGroupDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysEmpGroupEmpDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysEmployeeDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysEmployeeOrgDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysOrgDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysRoleDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysUserRoleDO;
import com.elitescloud.cloudt.system.service.model.entity.SysEmployeeDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.MapPath;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.TemporalExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Repository
public class EmployeeRepoProc
extends BaseRepoProc<SysEmployeeDO> {
    private static final QSysEmployeeDO QDO = QSysEmployeeDO.sysEmployeeDO;
    private static final QSysEmployeeOrgDO QDO_EMPLOYEE_ORG = QSysEmployeeOrgDO.sysEmployeeOrgDO;
    private static final QSysOrgDO QDO_ORG = QSysOrgDO.sysOrgDO;
    private static final QSysUserRoleDO QDO_USER_ROLE = QSysUserRoleDO.sysUserRoleDO;
    private static final QSysRoleDO QDO_ROLE = QSysRoleDO.sysRoleDO;
    private static final QOrgBuTreeEmployeeDO QDO_TREE_EMP = QOrgBuTreeEmployeeDO.orgBuTreeEmployeeDO;
    private static final QSysPositionDO QDO_POSITION = QSysPositionDO.sysPositionDO;
    private static final QSysEmpGroupDO QDO_EMP_GROUP = QSysEmpGroupDO.sysEmpGroupDO;
    private static final QSysEmpGroupEmpDO QDO_EMP_GROUP_EMP = QSysEmpGroupEmpDO.sysEmpGroupEmpDO;
    @Autowired
    private OrgRepoProc orgRepoProc;

    public EmployeeRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void updateJsonField(EntityPathBase<?> entity, MapPath<String, String, StringPath> jsonField, Map<String, String> updates, Predicate predicate) {
        JPAUpdateClause update = this.jpaQueryFactory.update(entity);
        String jsonSetExpression = "extension_info";
        for (Map.Entry<String, String> entry : updates.entrySet()) {
            jsonSetExpression = String.format("JSON_SET(%s, '$.%s', '%s')", jsonSetExpression, entry.getKey(), entry.getValue());
        }
        update.set((Path)Expressions.stringPath((String)"extension_info"), (Expression)Expressions.stringTemplate((String)"JSON_SET(extension_info, '$.test5', '33333')", (Object[])new Object[0])).where(new Predicate[]{predicate}).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateEnabled(long id, Boolean enabled) {
        super.updateValue((Path)EmployeeRepoProc.QDO.enabled, (Object)enabled, id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateEnabledByUserId(long userId, Boolean enabled) {
        super.updateValueByValue((Path)EmployeeRepoProc.QDO.enabled, (Object)enabled, (Path)EmployeeRepoProc.QDO.userId, (Object)userId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateMobile(long id, String mobile) {
        super.updateValue((Path)EmployeeRepoProc.QDO.phone, (Object)mobile, id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateEmail(long id, String email) {
        super.updateValue((Path)EmployeeRepoProc.QDO.email, (Object)email, id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateUserInfo(SysUserDO user) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)EmployeeRepoProc.QDO.username, (Object)user.getUsername()).set((Path)EmployeeRepoProc.QDO.lastName, (Object)user.getLastName()).set((Path)EmployeeRepoProc.QDO.firstName, (Object)user.getFirstName()).set((Path)EmployeeRepoProc.QDO.gender, (Object)user.getGender()).set((Path)EmployeeRepoProc.QDO.nickName, (Object)user.getNickName()).set((Path)EmployeeRepoProc.QDO.birthDate, (Object)user.getBirthDate()).set((Path)EmployeeRepoProc.QDO.mobile, (Object)user.getMobile()).set((Path)EmployeeRepoProc.QDO.email, (Object)user.getEmail()).set((Path)EmployeeRepoProc.QDO.idCard, (Object)user.getIdCard()).set((Path)EmployeeRepoProc.QDO.countryCode, (Object)user.getCountryCode()).set((Path)EmployeeRepoProc.QDO.provinceCode, (Object)user.getProvinceCode()).set((Path)EmployeeRepoProc.QDO.cityCode, (Object)user.getCityCode()).set((Path)EmployeeRepoProc.QDO.countyCode, (Object)user.getCountyCode()).set((Path)EmployeeRepoProc.QDO.address, (Object)user.getAddress()).set((Path)EmployeeRepoProc.QDO.personalSign, (Object)user.getPersonalSign()).set((Path)EmployeeRepoProc.QDO.avatarUrl, (Object)user.getAvatarUrl()).set((Path)EmployeeRepoProc.QDO.avatarCode, (Object)user.getAvatarCode()).where(new Predicate[]{EmployeeRepoProc.QDO.userId.eq((Object)user.getId())}).execute();
    }

    public boolean existsCode(String code) {
        return super.exists((Path)EmployeeRepoProc.QDO.code, (Object)code);
    }

    public boolean existsEmail(Long rootOrgId, String email) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)EmployeeRepoProc.QDO.id).from((EntityPath)QDO)).where((Predicate)EmployeeRepoProc.QDO.email.eq((Object)email).and((Predicate)EmployeeRepoProc.QDO.rootOrgId.eq((Object)rootOrgId)))).limit(1L)).fetchOne() != null;
    }

    public Boolean getEnabled(long id) {
        return (Boolean)super.getValue((Path)EmployeeRepoProc.QDO.enabled, id);
    }

    public Boolean getEnabledByUserId(long userId) {
        return (Boolean)super.getValueByValue((Path)EmployeeRepoProc.QDO.enabled, (Path)EmployeeRepoProc.QDO.userId, (Object)userId);
    }

    public boolean needSyncOuter(long id) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)EmployeeRepoProc.QDO_ORG.id).from((EntityPath)QDO_ORG)).where((Predicate)EmployeeRepoProc.QDO_ORG.id.in((SubQueryExpression)JPAExpressions.select((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.orgId).from(new EntityPath[]{QDO_EMPLOYEE_ORG}).where(new Predicate[]{EmployeeRepoProc.QDO_EMPLOYEE_ORG.employeeId.eq((Object)id)})).and((Predicate)EmployeeRepoProc.QDO_ORG.syncOuter.eq(Boolean.valueOf(true))))).fetchOne() != null;
    }

    public Long getUserId(Long id) {
        Long userId = (Long)super.getValue((Path)EmployeeRepoProc.QDO.userId, id.longValue());
        if (userId == null || userId == -1L) {
            return null;
        }
        return userId;
    }

    public String getUsername(long id) {
        return (String)super.getValue((Path)EmployeeRepoProc.QDO.username, id);
    }

    public Long getRealUserId(Long id) {
        return (Long)super.getValue((Path)EmployeeRepoProc.QDO.userId, id.longValue());
    }

    public Map<Long, Long> getUserIdsIgnoreNoUser(Collection<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{EmployeeRepoProc.QDO.id, EmployeeRepoProc.QDO.userId}).from((EntityPath)QDO)).where((Predicate)EmployeeRepoProc.QDO.id.in(ids))).fetch().stream().filter(t -> {
            Long userId = (Long)t.get((Expression)EmployeeRepoProc.QDO.userId);
            return userId != null && userId != -1L;
        }).collect(Collectors.toMap(t -> (Long)t.get((Expression)EmployeeRepoProc.QDO.id), t -> (Long)t.get((Expression)EmployeeRepoProc.QDO.userId), (t1, t2) -> t1));
    }

    public Map<Long, Long> getUserIds(Collection<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{EmployeeRepoProc.QDO.id, EmployeeRepoProc.QDO.userId}).from((EntityPath)QDO)).where((Predicate)EmployeeRepoProc.QDO.id.in(ids))).fetch().stream().collect(Collectors.toMap(t -> (Long)t.get((Expression)EmployeeRepoProc.QDO.id), t -> (Long)t.get((Expression)EmployeeRepoProc.QDO.userId), (t1, t2) -> t1));
    }

    public Long getRootOrgId(Long id) {
        return (Long)super.getValue((Path)EmployeeRepoProc.QDO.rootOrgId, id.longValue());
    }

    public Long getIdByUserId(long userId) {
        return super.getIdByValue((Path)EmployeeRepoProc.QDO.userId, (Object)userId);
    }

    public Long getIdByUserId(long userId, boolean enabled) {
        return (Long)super.getValue((Path)EmployeeRepoProc.QDO.id, (Predicate)EmployeeRepoProc.QDO.userId.eq((Object)userId).and((Predicate)EmployeeRepoProc.QDO.enabled.eq(Boolean.valueOf(enabled))), new OrderSpecifier[0]);
    }

    public String getEmailByUserId(long userId) {
        return (String)super.getValueByValue((Path)EmployeeRepoProc.QDO.email, (Path)EmployeeRepoProc.QDO.userId, (Object)userId);
    }

    public String getCodeByUserId(long userId) {
        return (String)super.getValueByValue((Path)EmployeeRepoProc.QDO.code, (Path)EmployeeRepoProc.QDO.userId, (Object)userId);
    }

    public String getCode(long id) {
        return (String)super.getValue((Path)EmployeeRepoProc.QDO.code, id);
    }

    public Long getIdByCode(@NotBlank String code) {
        return super.getIdByValue((Path)EmployeeRepoProc.QDO.code, (Object)code);
    }

    public Optional<SysEmployeeDO> getByUserId(Long userId) {
        return super.getOneOptionalByValue((Path)EmployeeRepoProc.QDO.userId, (Object)userId);
    }

    public Optional<SysEmployeeDO> getByCode(@NotBlank String code) {
        return super.getOneOptionalByValue((Path)EmployeeRepoProc.QDO.code, (Object)code);
    }

    public List<SysEmployeeDO> getByCode(@NotEmpty Collection<String> codes) {
        return super.getListByValue((Path)EmployeeRepoProc.QDO.code, codes, new OrderSpecifier[0]);
    }

    public PagingVO<EmployeePagedRespVO> pageMng(EmployeePageQueryVO queryVO, Set<Long> userIds) {
        Predicate predicateAuth = DataSecurityUtil.predicateForJPA(SysEmployeeDO.class);
        Predicate customFieldPredicate = CustomFieldJpaServiceUtil.getPredicate((List)queryVO.getConditions(), SysEmployeeDO.class);
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)EmployeeRepoProc.QDO.userId, userIds).andEq((SimpleExpression)EmployeeRepoProc.QDO.username, (Object)queryVO.getUsername()).andLike((StringExpression)EmployeeRepoProc.QDO.code, queryVO.getCode()).andLike((StringExpression)EmployeeRepoProc.QDO.lastName, queryVO.getFullName()).andEq((SimpleExpression)EmployeeRepoProc.QDO.gender, (Object)queryVO.getGender()).andLike((StringExpression)EmployeeRepoProc.QDO.phone, queryVO.getMobile()).andLike((StringExpression)EmployeeRepoProc.QDO.email, queryVO.getEmail()).andEq((SimpleExpression)EmployeeRepoProc.QDO.type, (Object)queryVO.getType()).and(queryVO.getHasAccount() != null, () -> queryVO.getHasAccount() != false ? EmployeeRepoProc.QDO.userId.ne((Object)-1L) : EmployeeRepoProc.QDO.userId.eq((Object)-1L)).andOnNotNull((Object)queryVO.getOrgId(), () -> EmployeeRepoProc.QDO.id.in((SubQueryExpression)JPAExpressions.select((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.employeeId).from(new EntityPath[]{QDO_EMPLOYEE_ORG}).where(new Predicate[]{EmployeeRepoProc.QDO_EMPLOYEE_ORG.orgId.eq((Object)queryVO.getOrgId())}))).and(queryVO.getOrgId() == null && queryVO.getOrgIdBelong() != null, () -> EmployeeRepoProc.QDO.id.in((SubQueryExpression)JPAExpressions.select((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.employeeId).from(new EntityPath[]{QDO_EMPLOYEE_ORG}).leftJoin((EntityPath)QDO_ORG).on(new Predicate[]{EmployeeRepoProc.QDO_ORG.id.eq((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.orgId)}).where(new Predicate[]{this.orgRepoProc.predicateOfOrgChildren(queryVO.getOrgIdBelong())}))).andEq((SimpleExpression)EmployeeRepoProc.QDO.enabled, (Object)queryVO.getEnabled()).and(predicateAuth).and(customFieldPredicate).build();
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanEmployeePagedRespVO()).from((EntityPath)QDO)).where(predicate);
        return this.queryByPage(jpaQuery, queryVO.getPageRequest());
    }

    public List<EmployeePagedRespVO> listMngOfPage(Collection<Long> ids) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)EmployeeRepoProc.QDO.id, ids).build();
        return super.getList(this.qBeanEmployeePagedRespVO(), predicate, new OrderSpecifier[0]);
    }

    public PagingVO<EmployeePagedRespVO> pageQuery(CommonEmployeePageQueryVO queryVO, Set<Long> userIds, Set<Long> userIdsOfDisabled) {
        Long orgId = queryVO.getOrgId();
        Long orgIdBelong = queryVO.getOrgIdBelong();
        GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        if (Boolean.TRUE.equals(queryVO.getCurrentTenantOrg()) ? (orgIdBelong = (Long)ObjectUtil.defaultIfNull((Object)currentUser.getTenantOrgId(), (Object)currentUser.getOrgId())) == null : Boolean.TRUE.equals(queryVO.getCurrentOrg()) && (orgId = currentUser.getOrgId()) == null) {
            return PagingVO.empty();
        }
        SubQueryExpression orgIdSubQuery = null;
        if (orgId != null) {
            orgIdSubQuery = (SubQueryExpression)JPAExpressions.select((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.employeeId).from(new EntityPath[]{QDO_EMPLOYEE_ORG}).where(new Predicate[]{EmployeeRepoProc.QDO_EMPLOYEE_ORG.orgId.eq((Object)orgId)});
        }
        SubQueryExpression orgIdBelongSubQuery = null;
        if (orgIdBelong != null && orgId == null) {
            orgIdBelongSubQuery = (SubQueryExpression)JPAExpressions.select((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.employeeId).from(new EntityPath[]{QDO_EMPLOYEE_ORG}).leftJoin((EntityPath)QDO_ORG).on(new Predicate[]{EmployeeRepoProc.QDO_ORG.id.eq((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.orgId)}).where(new Predicate[]{this.orgRepoProc.predicateOfOrgChildren(orgIdBelong)});
        }
        SubQueryExpression userIdOfRoleSubQuery = null;
        if (StringUtils.hasText((String)queryVO.getRoleCode())) {
            userIdOfRoleSubQuery = (SubQueryExpression)JPAExpressions.select((Expression)EmployeeRepoProc.QDO_USER_ROLE.userId).from(new EntityPath[]{QDO_USER_ROLE}).where(new Predicate[]{EmployeeRepoProc.QDO_USER_ROLE.roleId.in((SubQueryExpression)JPAExpressions.select((Expression)EmployeeRepoProc.QDO_ROLE.id).from(new EntityPath[]{QDO_ROLE}).where(new Predicate[]{EmployeeRepoProc.QDO_ROLE.code.eq((Object)queryVO.getRoleCode())}))});
        }
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)EmployeeRepoProc.QDO.userId, userIds).andLike((StringExpression)EmployeeRepoProc.QDO.code, queryVO.getCode()).andLike((StringExpression)EmployeeRepoProc.QDO.lastName, queryVO.getFullName()).andLike(new StringExpression[]{EmployeeRepoProc.QDO.code, EmployeeRepoProc.QDO.lastName, EmployeeRepoProc.QDO.firstName}, queryVO.getKeyword()).andEq((SimpleExpression)EmployeeRepoProc.QDO.gender, (Object)queryVO.getGender()).andLike((StringExpression)EmployeeRepoProc.QDO.phone, queryVO.getMobile()).andLike((StringExpression)EmployeeRepoProc.QDO.email, queryVO.getEmail()).andEq(true, (SimpleExpression)EmployeeRepoProc.QDO.enabled, (Object)((Boolean)ObjectUtil.defaultIfNull((Object)queryVO.getEnabled(), (Object)true))).andEq(true, (SimpleExpression)EmployeeRepoProc.QDO.served, (Object)((Boolean)ObjectUtil.defaultIfNull((Object)queryVO.getServed(), (Object)true))).and(queryVO.getHasAccount() != null, () -> queryVO.getHasAccount() != false ? EmployeeRepoProc.QDO.userId.ne((Object)-1L) : EmployeeRepoProc.QDO.userId.eq((Object)-1L)).andEq((SimpleExpression)EmployeeRepoProc.QDO.type, (Object)queryVO.getType()).andBetween(true, (TemporalExpression)EmployeeRepoProc.QDO.joinTime, (Comparable)queryVO.getJoinTimeStart(), (Comparable)queryVO.getJoinTimeEnd()).andIn(orgIdSubQuery != null, (SimpleExpression)EmployeeRepoProc.QDO.id, orgIdSubQuery).andIn(orgIdBelongSubQuery != null, (SimpleExpression)EmployeeRepoProc.QDO.id, orgIdBelongSubQuery).andIn(userIdOfRoleSubQuery != null, (SimpleExpression)EmployeeRepoProc.QDO.userId, userIdOfRoleSubQuery).and(CollUtil.isNotEmpty(userIdsOfDisabled), () -> {
            if (queryVO.getEnabled() == null) {
                return null;
            }
            return queryVO.getEnabled() != false ? EmployeeRepoProc.QDO.userId.notIn((Collection)userIdsOfDisabled) : EmployeeRepoProc.QDO.userId.in((Collection)userIdsOfDisabled);
        }).build();
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanEmployeePagedRespVO()).from((EntityPath)QDO)).where(predicate);
        return this.queryByPage(jpaQuery, queryVO.getPageRequest(), EmployeeRepoProc.QDO.createTime.asc());
    }

    public PagingVO<EmployeePageRespDTO> pageQuery(EmployeePageQueryDTO queryDTO, Set<Long> userIds, Set<Long> userIdsOfDisabled) {
        String keyword = StringUtils.hasText((String)queryDTO.getKeyword()) ? "%" + queryDTO.getKeyword() + "%" : null;
        SubQueryExpression orgIdSubQuery = null;
        SubQueryExpression orgIdBelongSubQuery = null;
        if (queryDTO.getOrgId() != null) {
            orgIdSubQuery = (SubQueryExpression)JPAExpressions.select((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.employeeId).from(new EntityPath[]{QDO_EMPLOYEE_ORG}).where(new Predicate[]{EmployeeRepoProc.QDO_EMPLOYEE_ORG.orgId.eq((Object)queryDTO.getOrgId())});
        } else if (StringUtils.hasText((String)queryDTO.getOrgCode())) {
            orgIdSubQuery = (SubQueryExpression)JPAExpressions.select((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.employeeId).from(new EntityPath[]{QDO_EMPLOYEE_ORG}).where(new Predicate[]{EmployeeRepoProc.QDO_EMPLOYEE_ORG.orgId.eq((Expression)JPAExpressions.select((Expression)EmployeeRepoProc.QDO_ORG.id).from(new EntityPath[]{QDO_ORG}).where(new Predicate[]{EmployeeRepoProc.QDO_ORG.code.eq((Object)queryDTO.getOrgCode())}))});
        } else if (queryDTO.getOrgIdBelong() != null) {
            orgIdBelongSubQuery = (SubQueryExpression)JPAExpressions.select((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.employeeId).from(new EntityPath[]{QDO_EMPLOYEE_ORG}).leftJoin((EntityPath)QDO_ORG).on(new Predicate[]{EmployeeRepoProc.QDO_ORG.id.eq((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.orgId)}).where(new Predicate[]{this.orgRepoProc.predicateOfOrgChildren(queryDTO.getOrgIdBelong())});
        } else if (StrUtil.isNotBlank((CharSequence)queryDTO.getOrgCodeBelong())) {
            Long orgIdBelong = this.getIdByCode(queryDTO.getOrgCodeBelong());
            if (orgIdBelong == null) {
                return PagingVO.empty();
            }
            orgIdBelongSubQuery = (SubQueryExpression)JPAExpressions.select((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.employeeId).from(new EntityPath[]{QDO_EMPLOYEE_ORG}).leftJoin((EntityPath)QDO_ORG).on(new Predicate[]{EmployeeRepoProc.QDO_ORG.id.eq((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.orgId)}).where(new Predicate[]{this.orgRepoProc.predicateOfOrgChildren(orgIdBelong)});
        }
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)EmployeeRepoProc.QDO.id, (Collection)queryDTO.getIds()).andIn((SimpleExpression)EmployeeRepoProc.QDO.code, (Collection)queryDTO.getCodes()).andIn((SimpleExpression)EmployeeRepoProc.QDO.userId, CollUtil.defaultIfEmpty(userIds, (Collection)queryDTO.getUserIds())).andEq((SimpleExpression)EmployeeRepoProc.QDO.type, (Object)queryDTO.getType()).andIn((SimpleExpression)EmployeeRepoProc.QDO.type, (Collection)queryDTO.getTypes()).andEq((SimpleExpression)EmployeeRepoProc.QDO.enabled, (Object)queryDTO.getEnabled()).andLike((StringExpression)EmployeeRepoProc.QDO.username, queryDTO.getUsername()).andLike((StringExpression)EmployeeRepoProc.QDO.username, (Collection)queryDTO.getUsernames()).andLike((StringExpression)EmployeeRepoProc.QDO.code, queryDTO.getCode()).andLike((StringExpression)EmployeeRepoProc.QDO.phone, queryDTO.getPhone()).andLike((StringExpression)EmployeeRepoProc.QDO.mobile, queryDTO.getMobile()).andLike((StringExpression)EmployeeRepoProc.QDO.emailWork, queryDTO.getEmailWork()).andLike((StringExpression)EmployeeRepoProc.QDO.email, queryDTO.getEmail()).andIn(orgIdSubQuery != null, (SimpleExpression)EmployeeRepoProc.QDO.id, orgIdSubQuery).andIn(orgIdBelongSubQuery != null, (SimpleExpression)EmployeeRepoProc.QDO.id, orgIdBelongSubQuery).and(keyword != null, () -> EmployeeRepoProc.QDO.code.like(keyword).or((Predicate)EmployeeRepoProc.QDO.lastName.like(keyword))).andLike(new StringExpression[]{EmployeeRepoProc.QDO.mobile, EmployeeRepoProc.QDO.username}, queryDTO.getUsernameOrMobile()).andLike((StringExpression)EmployeeRepoProc.QDO.firstName, queryDTO.getFirstName()).andLike((StringExpression)EmployeeRepoProc.QDO.lastName, queryDTO.getLastName()).andEq((SimpleExpression)EmployeeRepoProc.QDO.served, (Object)queryDTO.getServed()).and(Boolean.TRUE.equals(queryDTO.getWithoutLeader()), () -> ((JPQLQuery)JPAExpressions.select((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.id).from(new EntityPath[]{QDO_EMPLOYEE_ORG}).where(new Predicate[]{EmployeeRepoProc.QDO_EMPLOYEE_ORG.employeeId.eq((Expression)EmployeeRepoProc.QDO.id).and((Predicate)EmployeeRepoProc.QDO_EMPLOYEE_ORG.leaderEmployeeId.isNotNull())})).notExists()).and(Boolean.FALSE.equals(queryDTO.getWithoutLeader()), () -> ((JPQLQuery)JPAExpressions.select((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.id).from(new EntityPath[]{QDO_EMPLOYEE_ORG}).where(new Predicate[]{EmployeeRepoProc.QDO_EMPLOYEE_ORG.employeeId.eq((Expression)EmployeeRepoProc.QDO.id).and((Predicate)EmployeeRepoProc.QDO_EMPLOYEE_ORG.leaderEmployeeId.isNotNull())})).exists()).and(Boolean.TRUE.equals(queryDTO.getWithoutMobile()), () -> EmployeeRepoProc.QDO.mobile.isNull().or((Predicate)EmployeeRepoProc.QDO.mobile.eq((Object)""))).and(Boolean.FALSE.equals(queryDTO.getWithoutMobile()), () -> EmployeeRepoProc.QDO.mobile.isNotNull().and((Predicate)EmployeeRepoProc.QDO.mobile.ne((Object)""))).and(CollUtil.isNotEmpty(userIdsOfDisabled), () -> {
            if (queryDTO.getEnabled() == null) {
                return null;
            }
            return queryDTO.getEnabled() != false ? EmployeeRepoProc.QDO.userId.notIn((Collection)userIdsOfDisabled) : EmployeeRepoProc.QDO.userId.in((Collection)userIdsOfDisabled);
        }).build();
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanEmployeePageRespDTO()).from((EntityPath)QDO)).where(predicate);
        PagingVO pageData = this.queryByPage(jpaQuery, queryDTO.getPageRequest(), EmployeeRepoProc.QDO.createTime.desc());
        if (pageData.isEmpty()) {
            return pageData;
        }
        if (Boolean.TRUE.equals(queryDTO.getWithUnderlingNum())) {
            List employeeIds = pageData.stream().map(EmployeePageRespDTO::getId).collect(Collectors.toList());
            BooleanExpression subPredicate = EmployeeRepoProc.QDO_EMPLOYEE_ORG.leaderEmployeeId.in(employeeIds);
            if (queryDTO.getEnabled() != null) {
                subPredicate = subPredicate.and((Predicate)((JPQLQuery)JPAExpressions.select((Expression)EmployeeRepoProc.QDO.id).from(new EntityPath[]{QDO}).where(new Predicate[]{EmployeeRepoProc.QDO.id.eq((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.employeeId).and((Predicate)EmployeeRepoProc.QDO.enabled.eq(queryDTO.getEnabled()))})).exists());
            }
            Map<Long, Long> employeeSubMap = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{EmployeeRepoProc.QDO_EMPLOYEE_ORG.employeeId, EmployeeRepoProc.QDO_EMPLOYEE_ORG.leaderEmployeeId}).from((EntityPath)QDO_EMPLOYEE_ORG)).where((Predicate)subPredicate)).fetch().stream().collect(Collectors.groupingBy(t -> (Long)t.get((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.leaderEmployeeId), Collectors.counting()));
            pageData.each(t -> t.setUnderlingNum(Integer.valueOf(employeeSubMap.getOrDefault(t.getId(), 0L).intValue())));
        }
        return pageData;
    }

    public List<SysEmployeeBasicDTO> queryEmployee(Long orgId, Long orgIdBelong, Long rootOrgId, boolean includeDisabled) {
        BooleanExpression predicate = null;
        if (orgId != null) {
            predicate = EmployeeRepoProc.QDO_EMPLOYEE_ORG.orgId.eq((Object)orgId);
        } else if (orgIdBelong != null) {
            predicate = EmployeeRepoProc.QDO.id.in((SubQueryExpression)JPAExpressions.select((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.employeeId).from(new EntityPath[]{QDO_EMPLOYEE_ORG}).leftJoin((EntityPath)QDO_ORG).on(new Predicate[]{EmployeeRepoProc.QDO_ORG.id.eq((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.orgId)}).where(new Predicate[]{this.orgRepoProc.predicateOfOrgChildren(orgIdBelong)}));
        } else if (rootOrgId != null) {
            predicate = EmployeeRepoProc.QDO_EMPLOYEE_ORG.rootOrgId.eq((Object)rootOrgId);
        }
        if (!includeDisabled) {
            predicate = super.andPredicate((Predicate)predicate, (Predicate)EmployeeRepoProc.QDO.enabled.eq(Boolean.valueOf(true)));
        }
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanEmployeeBasicDTO()).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_EMPLOYEE_ORG)).on((Predicate)EmployeeRepoProc.QDO_EMPLOYEE_ORG.employeeId.eq((Expression)EmployeeRepoProc.QDO.id))).where((Predicate)predicate)).fetch();
    }

    public List<SysEmployeeBasicDTO> queryBasicByUserIds(Collection<Long> sysUserIds) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanEmployeeBasicDTO()).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_EMPLOYEE_ORG)).on((Predicate)EmployeeRepoProc.QDO_EMPLOYEE_ORG.employeeId.eq((Expression)EmployeeRepoProc.QDO.id))).where((Predicate)EmployeeRepoProc.QDO.userId.in(sysUserIds))).fetch();
    }

    public List<EmployeeListRespVO> listQuery(EmployeeListQueryVO queryVO) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andLike((StringExpression)EmployeeRepoProc.QDO.code, queryVO.getCodeLike()).andLike(new StringExpression[]{EmployeeRepoProc.QDO.lastName, EmployeeRepoProc.QDO.firstName}, queryVO.getFullNameLike()).andLike((StringExpression)EmployeeRepoProc.QDO.username, queryVO.getUsernameLike()).andLike(new StringExpression[]{EmployeeRepoProc.QDO.lastName, EmployeeRepoProc.QDO.firstName, EmployeeRepoProc.QDO.username}, queryVO.getFullNameOrUsernameLike()).andLike(new StringExpression[]{EmployeeRepoProc.QDO.code, EmployeeRepoProc.QDO.lastName, EmployeeRepoProc.QDO.firstName, EmployeeRepoProc.QDO.username}, queryVO.getCodeOrFullNameOrUsernameLike()).build();
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)EmployeeRepoProc.QDO.enabled.eq(Boolean.valueOf(true)).and((Predicate)EmployeeRepoProc.QDO.served.eq(Boolean.valueOf(true))));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanEmployeeList()).from((EntityPath)QDO)).where(predicate)).fetch();
    }

    public Map<Long, Integer> countEmployee(Collection<Long> orgIds, boolean includeDisabled) {
        BooleanExpression predicate = EmployeeRepoProc.QDO_EMPLOYEE_ORG.orgId.in(orgIds);
        if (!includeDisabled) {
            predicate = super.andPredicate((Predicate)predicate, (Predicate)EmployeeRepoProc.QDO.enabled.eq(Boolean.valueOf(true)));
        }
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{EmployeeRepoProc.QDO_EMPLOYEE_ORG.employeeId, EmployeeRepoProc.QDO_EMPLOYEE_ORG.orgId}).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_EMPLOYEE_ORG)).on((Predicate)EmployeeRepoProc.QDO_EMPLOYEE_ORG.employeeId.eq((Expression)EmployeeRepoProc.QDO.id))).where((Predicate)predicate)).fetch().stream().collect(Collectors.groupingBy(t -> (Long)t.get((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.orgId), Collectors.collectingAndThen(Collectors.toList(), List::size)));
    }

    public List<SysEmployeeDO> queryList(EmployeeQueryDTO queryDTO) {
        SubQueryExpression tempSubQuery2;
        SubQueryExpression tempSubQuery1;
        SubQueryExpression orgIdSubQuery = null;
        SubQueryExpression orgIdBelongSubQuery = null;
        SubQueryExpression postIdSubQuery = null;
        SubQueryExpression empGroupSubQuery = null;
        if (queryDTO.getOrgId() != null || CharSequenceUtil.isNotBlank((CharSequence)queryDTO.getOrgCode()) || CollUtil.isNotEmpty((Collection)queryDTO.getOrgIds()) || CollUtil.isNotEmpty((Collection)queryDTO.getOrgCodes())) {
            tempSubQuery1 = StringUtils.hasText((String)queryDTO.getOrgCode()) ? (SubQueryExpression)JPAExpressions.select((Expression)EmployeeRepoProc.QDO_ORG.id).from(new EntityPath[]{QDO_ORG}).where(new Predicate[]{EmployeeRepoProc.QDO_ORG.code.eq((Object)queryDTO.getOrgCode())}) : null;
            tempSubQuery2 = CollUtil.isNotEmpty((Collection)queryDTO.getOrgCodes()) ? (SubQueryExpression)JPAExpressions.select((Expression)EmployeeRepoProc.QDO_ORG.id).from(new EntityPath[]{QDO_ORG}).where(new Predicate[]{EmployeeRepoProc.QDO_ORG.code.in((Collection)queryDTO.getOrgCodes())}) : null;
            orgIdSubQuery = (SubQueryExpression)JPAExpressions.select((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.employeeId).from(new EntityPath[]{QDO_EMPLOYEE_ORG}).where(new Predicate[]{BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.orgId, (Object)queryDTO.getOrgId()).andIn((SimpleExpression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.orgId, (Collection)queryDTO.getOrgIds()).andIn(tempSubQuery1 != null, (SimpleExpression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.orgId, tempSubQuery1).andIn(tempSubQuery2 != null, (SimpleExpression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.orgId, tempSubQuery2).build()});
        }
        if (orgIdSubQuery == null && (queryDTO.getOrgIdBelong() != null || CharSequenceUtil.isNotBlank((CharSequence)queryDTO.getOrgCodeBelong()))) {
            Long orgIdBelong;
            Long l = orgIdBelong = queryDTO.getOrgIdBelong() != null ? queryDTO.getOrgIdBelong() : (Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)EmployeeRepoProc.QDO_ORG.id).from((EntityPath)QDO_ORG)).where((Predicate)EmployeeRepoProc.QDO_ORG.code.eq((Object)queryDTO.getOrgCodeBelong()))).limit(1L)).fetchOne();
            if (orgIdBelong == null) {
                return Collections.emptyList();
            }
            orgIdBelongSubQuery = (SubQueryExpression)JPAExpressions.select((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.employeeId).from(new EntityPath[]{QDO_EMPLOYEE_ORG}).leftJoin((EntityPath)QDO_ORG).on(new Predicate[]{EmployeeRepoProc.QDO_ORG.id.eq((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.orgId)}).where(new Predicate[]{this.orgRepoProc.predicateOfOrgChildren(orgIdBelong)});
        }
        if (queryDTO.getPositionId() != null || CharSequenceUtil.isNotBlank((CharSequence)queryDTO.getPositionCode()) || CollUtil.isNotEmpty((Collection)queryDTO.getPositionIds()) || CollUtil.isNotEmpty((Collection)queryDTO.getPositionCodes())) {
            tempSubQuery1 = StringUtils.hasText((String)queryDTO.getPositionCode()) ? (SubQueryExpression)JPAExpressions.select(EmployeeRepoProc.QDO_POSITION.id).from(new EntityPath[]{QDO_POSITION}).where(new Predicate[]{EmployeeRepoProc.QDO_POSITION.positionCode.eq((Object)queryDTO.getPositionCode())}) : null;
            tempSubQuery2 = CollUtil.isNotEmpty((Collection)queryDTO.getPositionCodes()) ? (SubQueryExpression)JPAExpressions.select(EmployeeRepoProc.QDO_POSITION.id).from(new EntityPath[]{QDO_POSITION}).where(new Predicate[]{EmployeeRepoProc.QDO_POSITION.positionCode.in((Collection)queryDTO.getPositionCodes())}) : null;
            postIdSubQuery = (SubQueryExpression)JPAExpressions.select((Expression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.employeeId).from(new EntityPath[]{QDO_EMPLOYEE_ORG}).where(new Predicate[]{BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.positionId, (Object)queryDTO.getPositionId()).andIn((SimpleExpression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.positionId, (Collection)queryDTO.getPositionIds()).andIn(tempSubQuery1 != null, (SimpleExpression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.positionId, tempSubQuery1).andIn(tempSubQuery2 != null, (SimpleExpression)EmployeeRepoProc.QDO_EMPLOYEE_ORG.positionId, tempSubQuery2).build()});
        }
        if (queryDTO.getEmpGroupId() != null || CharSequenceUtil.isNotBlank((CharSequence)queryDTO.getEmpGroupCode()) || CollUtil.isNotEmpty((Collection)queryDTO.getEmpGroupIds()) || CollUtil.isNotEmpty((Collection)queryDTO.getEmpGroupCodes())) {
            empGroupSubQuery = (SubQueryExpression)JPAExpressions.select((Expression)EmployeeRepoProc.QDO_EMP_GROUP_EMP.empId).from(new EntityPath[]{QDO_EMP_GROUP_EMP}).leftJoin((EntityPath)QDO_EMP_GROUP).on(new Predicate[]{EmployeeRepoProc.QDO_EMP_GROUP.id.eq((Expression)EmployeeRepoProc.QDO_EMP_GROUP_EMP.groupId)}).where(new Predicate[]{BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)EmployeeRepoProc.QDO_EMP_GROUP.enabled, (Object)true).andEq((SimpleExpression)EmployeeRepoProc.QDO_EMP_GROUP.id, (Object)queryDTO.getEmpGroupId()).andIn((SimpleExpression)EmployeeRepoProc.QDO_EMP_GROUP.id, (Collection)queryDTO.getEmpGroupIds()).andEq((SimpleExpression)EmployeeRepoProc.QDO_EMP_GROUP.code, (Object)queryDTO.getEmpGroupCode()).andIn((SimpleExpression)EmployeeRepoProc.QDO_EMP_GROUP.code, (Collection)queryDTO.getEmpGroupCodes()).build()});
        }
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn(CollUtil.isNotEmpty((Collection)queryDTO.getIds()), (SimpleExpression)EmployeeRepoProc.QDO.id, (Collection)queryDTO.getIds()).andIn(CollUtil.isNotEmpty((Collection)queryDTO.getUserIds()), (SimpleExpression)EmployeeRepoProc.QDO.userId, (Collection)queryDTO.getUserIds()).andIn(CollUtil.isNotEmpty((Collection)queryDTO.getCodes()), (SimpleExpression)EmployeeRepoProc.QDO.code, (Collection)queryDTO.getCodes()).andIn(CollUtil.isNotEmpty((Collection)queryDTO.getPhones()), (SimpleExpression)EmployeeRepoProc.QDO.phone, (Collection)queryDTO.getPhones()).andIn(CollUtil.isNotEmpty((Collection)queryDTO.getEmails()), (SimpleExpression)EmployeeRepoProc.QDO.email, (Collection)queryDTO.getEmails()).andIn(orgIdSubQuery != null, (SimpleExpression)EmployeeRepoProc.QDO.id, orgIdSubQuery).andIn(orgIdBelongSubQuery != null, (SimpleExpression)EmployeeRepoProc.QDO.id, orgIdBelongSubQuery).andIn(postIdSubQuery != null, (SimpleExpression)EmployeeRepoProc.QDO.id, postIdSubQuery).andIn(empGroupSubQuery != null, (SimpleExpression)EmployeeRepoProc.QDO.id, empGroupSubQuery).andEq(StringUtils.hasText((String)queryDTO.getType()), (SimpleExpression)EmployeeRepoProc.QDO.type, (Object)queryDTO.getType()).andEq(StringUtils.hasText((String)queryDTO.getDuty()), (SimpleExpression)EmployeeRepoProc.QDO.duty, (Object)queryDTO.getDuty()).andEq(queryDTO.getServed() != null, (SimpleExpression)EmployeeRepoProc.QDO.served, (Object)queryDTO.getServed()).andEq(queryDTO.getEnabled() != null, (SimpleExpression)EmployeeRepoProc.QDO.enabled, (Object)queryDTO.getEnabled()).andLike((StringExpression)EmployeeRepoProc.QDO.firstName, queryDTO.getFirstName()).andLike((StringExpression)EmployeeRepoProc.QDO.lastName, queryDTO.getLastName()).andLike(new StringExpression[]{EmployeeRepoProc.QDO.username, EmployeeRepoProc.QDO.lastName}, queryDTO.getUsernameOrName()).and(StringUtils.hasText((String)queryDTO.getCodeOrName()), () -> EmployeeRepoProc.QDO.code.eq((Object)queryDTO.getCodeOrName()).or((Predicate)EmployeeRepoProc.QDO.lastName.like("%" + queryDTO.getCodeOrName() + "%"))).build();
        JPAQuery jpqQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)QDO).from((EntityPath)QDO)).where(predicate);
        if (queryDTO.getLimitSize() != null) {
            jpqQuery.limit((long)queryDTO.getLimitSize().intValue());
        }
        return jpqQuery.fetch();
    }

    public IdCodeNameParam getEmployeeName(long id, Boolean enabled) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)EmployeeRepoProc.QDO.id, (Object)id).andEq(enabled != null, (SimpleExpression)EmployeeRepoProc.QDO.enabled, (Object)enabled).build();
        Tuple t = (Tuple)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{EmployeeRepoProc.QDO.id, EmployeeRepoProc.QDO.code, EmployeeRepoProc.QDO.firstName, EmployeeRepoProc.QDO.lastName, EmployeeRepoProc.QDO.username}).from((EntityPath)QDO)).where(predicate)).fetchOne();
        if (t == null) {
            return null;
        }
        return new IdCodeNameParam((Long)t.get((Expression)EmployeeRepoProc.QDO.id), (String)t.get((Expression)EmployeeRepoProc.QDO.code), this.buildUserName((String)t.get((Expression)EmployeeRepoProc.QDO.firstName), (String)t.get((Expression)EmployeeRepoProc.QDO.lastName), (String)t.get((Expression)EmployeeRepoProc.QDO.username)));
    }

    public IdCodeNameParam getEmployeeNameByUserId(long userId, Boolean enabled) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)EmployeeRepoProc.QDO.userId, (Object)userId).andEq(enabled != null, (SimpleExpression)EmployeeRepoProc.QDO.enabled, (Object)enabled).build();
        Tuple t = (Tuple)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{EmployeeRepoProc.QDO.id, EmployeeRepoProc.QDO.code, EmployeeRepoProc.QDO.firstName, EmployeeRepoProc.QDO.lastName, EmployeeRepoProc.QDO.username}).from((EntityPath)QDO)).where(predicate)).fetchOne();
        if (t == null) {
            return null;
        }
        return new IdCodeNameParam((Long)t.get((Expression)EmployeeRepoProc.QDO.id), (String)t.get((Expression)EmployeeRepoProc.QDO.code), this.buildUserName((String)t.get((Expression)EmployeeRepoProc.QDO.firstName), (String)t.get((Expression)EmployeeRepoProc.QDO.lastName), (String)t.get((Expression)EmployeeRepoProc.QDO.username)));
    }

    public List<IdCodeNameParam> queryEmployeeName(Collection<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{EmployeeRepoProc.QDO.id, EmployeeRepoProc.QDO.code, EmployeeRepoProc.QDO.firstName, EmployeeRepoProc.QDO.lastName, EmployeeRepoProc.QDO.username}).from((EntityPath)QDO)).where((Predicate)EmployeeRepoProc.QDO.id.in(ids))).fetch().stream().map(t -> new IdCodeNameParam((Long)t.get((Expression)EmployeeRepoProc.QDO.id), (String)t.get((Expression)EmployeeRepoProc.QDO.code), this.buildUserName((String)t.get((Expression)EmployeeRepoProc.QDO.firstName), (String)t.get((Expression)EmployeeRepoProc.QDO.lastName), (String)t.get((Expression)EmployeeRepoProc.QDO.username)))).collect(Collectors.toList());
    }

    public List<IdCodeNameParam> queryEmployeeNameByUserIds(Collection<Long> userIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{EmployeeRepoProc.QDO.id, EmployeeRepoProc.QDO.code, EmployeeRepoProc.QDO.firstName, EmployeeRepoProc.QDO.lastName, EmployeeRepoProc.QDO.username}).from((EntityPath)QDO)).where((Predicate)EmployeeRepoProc.QDO.userId.in(userIds))).fetch().stream().map(t -> new IdCodeNameParam((Long)t.get((Expression)EmployeeRepoProc.QDO.id), (String)t.get((Expression)EmployeeRepoProc.QDO.code), this.buildUserName((String)t.get((Expression)EmployeeRepoProc.QDO.firstName), (String)t.get((Expression)EmployeeRepoProc.QDO.lastName), (String)t.get((Expression)EmployeeRepoProc.QDO.username)))).collect(Collectors.toList());
    }

    public List<IdCodeNameParam> queryEmployeeNameByCodes(Collection<String> codes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{EmployeeRepoProc.QDO.id, EmployeeRepoProc.QDO.code, EmployeeRepoProc.QDO.firstName, EmployeeRepoProc.QDO.lastName, EmployeeRepoProc.QDO.username}).from((EntityPath)QDO)).where((Predicate)EmployeeRepoProc.QDO.code.in(codes))).fetch().stream().map(t -> new IdCodeNameParam((Long)t.get((Expression)EmployeeRepoProc.QDO.id), (String)t.get((Expression)EmployeeRepoProc.QDO.code), this.buildUserName((String)t.get((Expression)EmployeeRepoProc.QDO.firstName), (String)t.get((Expression)EmployeeRepoProc.QDO.lastName), (String)t.get((Expression)EmployeeRepoProc.QDO.username)))).collect(Collectors.toList());
    }

    public List<EmployeeListRespVO> listEmployeeByRole(long roleId) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanEmployeeList()).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_USER_ROLE)).on((Predicate)EmployeeRepoProc.QDO_USER_ROLE.userId.eq((Expression)EmployeeRepoProc.QDO.userId).and((Predicate)EmployeeRepoProc.QDO.id.isNotNull()))).where((Predicate)EmployeeRepoProc.QDO_USER_ROLE.roleId.eq((Object)roleId).and((Predicate)EmployeeRepoProc.QDO.id.isNotNull()))).orderBy(EmployeeRepoProc.QDO_USER_ROLE.createTime.desc())).fetch();
    }

    private String buildUserName(String firstName, String lastName, String username) {
        if (CharSequenceUtil.isBlank((CharSequence)lastName)) {
            return CharSequenceUtil.blankToDefault((CharSequence)firstName, (String)username);
        }
        return lastName + CharSequenceUtil.blankToDefault((CharSequence)firstName, (String)"");
    }

    private QBean<EmployeePagedRespVO> qBeanEmployeePagedRespVO() {
        return Projections.bean(EmployeePagedRespVO.class, (Expression[])new Expression[]{EmployeeRepoProc.QDO.id, EmployeeRepoProc.QDO.userId, EmployeeRepoProc.QDO.code, EmployeeRepoProc.QDO.code, EmployeeRepoProc.QDO.duty, EmployeeRepoProc.QDO.type, EmployeeRepoProc.QDO.phone, EmployeeRepoProc.QDO.email, EmployeeRepoProc.QDO.enabled, EmployeeRepoProc.QDO.served, EmployeeRepoProc.QDO.joinTime, EmployeeRepoProc.QDO.username, EmployeeRepoProc.QDO.firstName, EmployeeRepoProc.QDO.lastName, EmployeeRepoProc.QDO.gender, EmployeeRepoProc.QDO.mobile, EmployeeRepoProc.QDO.phone, EmployeeRepoProc.QDO.email, EmployeeRepoProc.QDO.photo, EmployeeRepoProc.QDO.extensionInfo});
    }

    private QBean<SysEmployeeBasicDTO> qBeanEmployeeBasicDTO() {
        return Projections.bean(SysEmployeeBasicDTO.class, (Expression[])new Expression[]{EmployeeRepoProc.QDO.id, EmployeeRepoProc.QDO.userId, EmployeeRepoProc.QDO.rootOrgId, EmployeeRepoProc.QDO.lastName, EmployeeRepoProc.QDO.firstName, EmployeeRepoProc.QDO.gender, EmployeeRepoProc.QDO.code, EmployeeRepoProc.QDO.email, EmployeeRepoProc.QDO.phone, EmployeeRepoProc.QDO.type, EmployeeRepoProc.QDO.served, EmployeeRepoProc.QDO.photo, EmployeeRepoProc.QDO.enabled, EmployeeRepoProc.QDO.sortNo, EmployeeRepoProc.QDO_EMPLOYEE_ORG.orgId});
    }

    private QBean<EmployeePageRespDTO> qBeanEmployeePageRespDTO() {
        return Projections.bean(EmployeePageRespDTO.class, (Expression[])new Expression[]{EmployeeRepoProc.QDO.id, EmployeeRepoProc.QDO.code, EmployeeRepoProc.QDO.userId, EmployeeRepoProc.QDO.username, EmployeeRepoProc.QDO.firstName, EmployeeRepoProc.QDO.lastName, EmployeeRepoProc.QDO.gender, EmployeeRepoProc.QDO.type, EmployeeRepoProc.QDO.duty, EmployeeRepoProc.QDO.served, EmployeeRepoProc.QDO.enabled, EmployeeRepoProc.QDO.phone, EmployeeRepoProc.QDO.email});
    }

    private QBean<EmployeeListRespVO> qBeanEmployeeList() {
        return Projections.bean(EmployeeListRespVO.class, (Expression[])new Expression[]{EmployeeRepoProc.QDO.id, EmployeeRepoProc.QDO.userId, EmployeeRepoProc.QDO.code, EmployeeRepoProc.QDO.duty, EmployeeRepoProc.QDO.username, EmployeeRepoProc.QDO.lastName, EmployeeRepoProc.QDO.firstName, EmployeeRepoProc.QDO.emailWork, EmployeeRepoProc.QDO.phone, EmployeeRepoProc.QDO.mobile, EmployeeRepoProc.QDO.email});
    }
}

