/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.entity.QSysMqMessageDO;
import com.elitescloud.cloudt.system.model.entity.SysMqMessageDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.springframework.stereotype.Repository;

@Repository
public class MqMessageRepoProc
extends BaseRepoProc<SysMqMessageDO> {
    private static final QSysMqMessageDO QDO = QSysMqMessageDO.sysMqMessageDO;

    public MqMessageRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void deleteExpiredMessage(LocalDateTime expiredTime) {
        super.delete((Predicate)MqMessageRepoProc.QDO.createTime.before((Comparable)expiredTime));
    }

    public void updateSendResult(@NotBlank String messageId, boolean success, String failReason) {
        Long retryTimes = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)MqMessageRepoProc.QDO.id.count()).from((EntityPath)QDO)).where((Predicate)MqMessageRepoProc.QDO.originalMessageId.eq((Object)messageId))).fetchOne();
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)MqMessageRepoProc.QDO.success, (Object)success).set((Path)MqMessageRepoProc.QDO.failReason, (Object)failReason).set(MqMessageRepoProc.QDO.finishTime, (Object)LocalDateTime.now()).set(MqMessageRepoProc.QDO.retryTimes, (Object)((Long)ObjectUtil.defaultIfNull((Object)retryTimes, (Object)0L)).intValue()).where(new Predicate[]{MqMessageRepoProc.QDO.messageId.eq((Object)messageId)}).execute();
    }

    public void updateRetryFailResult(@NotBlank String messageId, String reason) {
        Long retryTimes = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)MqMessageRepoProc.QDO.id.count()).from((EntityPath)QDO)).where((Predicate)MqMessageRepoProc.QDO.originalMessageId.eq((Object)messageId))).fetchOne();
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)MqMessageRepoProc.QDO.remark, (Object)reason).set(MqMessageRepoProc.QDO.retryTimes, (Object)((Long)ObjectUtil.defaultIfNull((Object)retryTimes, (Object)0L)).intValue()).where(new Predicate[]{MqMessageRepoProc.QDO.messageId.eq((Object)messageId)}).execute();
    }

    public void updateRetrySendTime(@NotBlank String messageId, LocalDateTime sendTime) {
        this.jpaQueryFactory.update((EntityPath)QDO).set(MqMessageRepoProc.QDO.sendTime, (Object)sendTime).where(new Predicate[]{MqMessageRepoProc.QDO.messageId.eq((Object)messageId)}).execute();
    }

    public void updateLastRetryMessageId(@NotBlank String messageId, String lastRetryMessageId) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)MqMessageRepoProc.QDO.lastRetryMessageId, (Object)lastRetryMessageId).where(new Predicate[]{MqMessageRepoProc.QDO.messageId.eq((Object)messageId)}).execute();
    }

    public void updateConsumed(long id, LocalDateTime consumeTime) {
        QSysMqMessageDO sub = new QSysMqMessageDO("sub");
        Long retryTimes = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)MqMessageRepoProc.QDO.id.count()).from((EntityPath)QDO)).where((Predicate)MqMessageRepoProc.QDO.originalMessageId.eq((Expression)JPAExpressions.select((Expression)sub.messageId).from(new EntityPath[]{sub}).where(new Predicate[]{sub.id.eq((Object)id)})))).fetchOne();
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)MqMessageRepoProc.QDO.consumed, (Object)true).set(MqMessageRepoProc.QDO.consumeTime, (Object)consumeTime).set(MqMessageRepoProc.QDO.retryTimes, (Object)((Long)ObjectUtil.defaultIfNull((Object)retryTimes, (Object)0L)).intValue()).where(new Predicate[]{MqMessageRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    public void updateConsumedByMessageId(@NotBlank String messageId, LocalDateTime consumeTime) {
        Long retryTimes = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)MqMessageRepoProc.QDO.id.count()).from((EntityPath)QDO)).where((Predicate)MqMessageRepoProc.QDO.originalMessageId.eq((Object)messageId))).fetchOne();
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)MqMessageRepoProc.QDO.consumed, (Object)true).set(MqMessageRepoProc.QDO.consumeTime, (Object)consumeTime).set(MqMessageRepoProc.QDO.retryTimes, (Object)((Long)ObjectUtil.defaultIfNull((Object)retryTimes, (Object)0L)).intValue()).where(new Predicate[]{MqMessageRepoProc.QDO.messageId.eq((Object)messageId)}).execute();
    }

    public void deleteByMessageId(@NotBlank String messageId) {
        super.deleteByValue((Path)MqMessageRepoProc.QDO.messageId, (Object)messageId);
    }

    public String getOriginalMessageId(@NotBlank String messageId) {
        return (String)super.getValueByValue((Path)MqMessageRepoProc.QDO.originalMessageId, (Path)MqMessageRepoProc.QDO.messageId, (Object)messageId);
    }

    public Integer getVersionByMessageId(@NotBlank String messageId) {
        return (Integer)super.getValueByValue(MqMessageRepoProc.QDO.auditDataVersion, (Path)MqMessageRepoProc.QDO.messageId, (Object)messageId);
    }

    public Long getIdByMessageId(@NotBlank String messageId) {
        return super.getIdByValue((Path)MqMessageRepoProc.QDO.messageId, (Object)messageId);
    }

    public SysMqMessageDO getByMessageId(@NotBlank String messageId) {
        return (SysMqMessageDO)((Object)super.getOneByValue((Path)MqMessageRepoProc.QDO.messageId, (Object)messageId));
    }

    public List<SysMqMessageDO> listByMessageId(@NotEmpty Collection<String> messageIds) {
        return super.getListByValue((Path)MqMessageRepoProc.QDO.messageId, messageIds, new OrderSpecifier[0]);
    }
}

