/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysOuBasicDTO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonCompanyPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.org.OuPageQueryVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysOuDO;
import com.elitescloud.cloudt.system.service.model.entity.SysOuDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import org.springframework.stereotype.Repository;

@Repository
public class OuRepoProc
extends BaseRepoProc<SysOuDO> {
    private static final QSysOuDO QDO = QSysOuDO.sysOuDO;

    public OuRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void updateEnabled(long id, Boolean enabled) {
        super.updateValue((Path)OuRepoProc.QDO.enabled, (Object)enabled, id);
    }

    public boolean existsOuCode(@NotBlank String ouCode, Long id) {
        return super.exists((Path)OuRepoProc.QDO.ouCode, (Object)ouCode, id);
    }

    public Boolean getEnabled(long id) {
        return (Boolean)super.getValue((Path)OuRepoProc.QDO.enabled, id);
    }

    public String getOuName(long id) {
        return (String)super.getValue((Path)OuRepoProc.QDO.ouName, id);
    }

    public Map<Long, String> getNameMapById(@NotBlank Collection<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{OuRepoProc.QDO.id, OuRepoProc.QDO.ouName}).from((EntityPath)QDO)).where((Predicate)OuRepoProc.QDO.id.in(ids))).fetch().stream().collect(Collectors.toMap(t -> (Long)t.get((Expression)OuRepoProc.QDO.id), t -> (String)t.get((Expression)OuRepoProc.QDO.ouName), (t1, t2) -> t1));
    }

    public Map<String, String> getNameMapByOuCode(@NotBlank Collection<String> codes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{OuRepoProc.QDO.ouCode, OuRepoProc.QDO.ouName}).from((EntityPath)QDO)).where((Predicate)OuRepoProc.QDO.ouCode.in(codes))).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)OuRepoProc.QDO.ouCode), t -> (String)t.get((Expression)OuRepoProc.QDO.ouName), (t1, t2) -> t1));
    }

    public PagingVO<SysOuDO> pageMng(OuPageQueryVO queryVO) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andLike((StringExpression)OuRepoProc.QDO.ouCode, queryVO.getOuCode()).andLike((StringExpression)OuRepoProc.QDO.ouName, queryVO.getOuName()).andEq((SimpleExpression)OuRepoProc.QDO.ouType, (Object)queryVO.getOuType()).andEq(queryVO.getEnabled() != null, (SimpleExpression)OuRepoProc.QDO.enabled, (Object)queryVO.getEnabled()).build();
        return super.queryByPage(predicate, queryVO.getPageRequest());
    }

    public PagingVO<SysOuDO> pageQuery(CommonCompanyPageQueryVO queryVO) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andLike((StringExpression)OuRepoProc.QDO.ouCode, queryVO.getOuCode()).andLike((StringExpression)OuRepoProc.QDO.ouName, queryVO.getOuName()).andEq((SimpleExpression)OuRepoProc.QDO.ouType, (Object)queryVO.getOuType()).andEq(true, (SimpleExpression)OuRepoProc.QDO.enabled, (Object)true).build();
        return super.queryByPage(predicate, queryVO.getPageRequest());
    }

    public SysOuBasicDTO getOuBasic(long id) {
        return (SysOuBasicDTO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanOuBasicDTO()).from((EntityPath)QDO)).where((Predicate)OuRepoProc.QDO.id.eq((Object)id))).limit(1L)).fetchOne();
    }

    private QBean<SysOuBasicDTO> qBeanOuBasicDTO() {
        return Projections.bean(SysOuBasicDTO.class, (Expression[])new Expression[]{OuRepoProc.QDO.id, OuRepoProc.QDO.ouCode, OuRepoProc.QDO.ouName, OuRepoProc.QDO.pinyin, OuRepoProc.QDO.ouAbbr, OuRepoProc.QDO.ouType, OuRepoProc.QDO.enabled});
    }
}

