/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.bo.PermissionResBO;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType;
import com.elitescloud.cloudt.system.service.common.constant.PermissionOwnerTypeEnum;
import com.elitescloud.cloudt.system.service.model.entity.QSysPermissionResDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPermissionResDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Repository;

@Repository
public class PermissionResRepoProc
extends BaseRepoProc<SysPermissionResDO> {
    private static final QSysPermissionResDO QDO = QSysPermissionResDO.sysPermissionResDO;

    public PermissionResRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void delete(@NotNull BelongType.Belonger assigner, @NotNull PermissionOwnerTypeEnum ownerType, @NotBlank String ownerId) {
        BooleanExpression predicate = PermissionResRepoProc.QDO.ownerId.eq((Object)ownerId).and((Predicate)PermissionResRepoProc.QDO.ownerType.eq((Object)ownerType.name())).and((Predicate)PermissionResRepoProc.QDO.assignerId.eq((Object)assigner.getBelongId())).and((Predicate)PermissionResRepoProc.QDO.assignerType.eq((Object)assigner.getBelongType().getValue()));
        super.delete((Predicate)predicate);
    }

    public List<PermissionResBO.Res> listPermissionOfOwner(@NotNull BelongType.Belonger assigner, @NotNull PermissionOwnerTypeEnum ownerType, @NotBlank String ownerId) {
        BooleanExpression predicate = PermissionResRepoProc.QDO.ownerId.eq((Object)ownerId).and((Predicate)PermissionResRepoProc.QDO.ownerType.eq((Object)ownerType.name())).and((Predicate)PermissionResRepoProc.QDO.assignerId.eq((Object)assigner.getBelongId())).and((Predicate)PermissionResRepoProc.QDO.assignerType.eq((Object)assigner.getBelongType().getValue()));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{PermissionResRepoProc.QDO.resType, PermissionResRepoProc.QDO.resId}).from((EntityPath)QDO)).where((Predicate)predicate)).fetch().stream().map(t -> {
            PermissionResBO.Res res = new PermissionResBO.Res();
            res.setResTypeEnum(MenuTreeNodeType.valueOf((String)((String)t.get((Expression)PermissionResRepoProc.QDO.resType))));
            res.setResId((String)t.get((Expression)PermissionResRepoProc.QDO.resId));
            return res;
        }).collect(Collectors.toList());
    }

    public List<String> listMenuCodeByUsers(@NotNull PermissionOwnerTypeEnum ownerType, @NotBlank String ownerId, boolean includeMenu, boolean includeAction) {
        HashSet<String> resTypes = new HashSet<String>(4);
        if (includeMenu) {
            resTypes.add(MenuTreeNodeType.MENU.getValue());
        }
        if (includeAction) {
            resTypes.add(MenuTreeNodeType.ACTION.getValue());
        }
        if (resTypes.isEmpty() || CharSequenceUtil.isBlank((CharSequence)ownerId)) {
            return Collections.emptyList();
        }
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)PermissionResRepoProc.QDO.ownerId, (Object)ownerId).andEq((SimpleExpression)PermissionResRepoProc.QDO.ownerType, (Object)ownerType.name()).andIn((SimpleExpression)PermissionResRepoProc.QDO.resType, resTypes).build();
        return super.getValueList((Path)PermissionResRepoProc.QDO.resId, predicate, new OrderSpecifier[0]);
    }

    public List<String> listMenuCodeByUsers(@NotEmpty Map<String, PermissionOwnerTypeEnum> owners, boolean includeMenu, boolean includeAction) {
        HashSet<String> resTypes = new HashSet<String>(4);
        if (includeMenu) {
            resTypes.add(MenuTreeNodeType.MENU.getValue());
        }
        if (includeAction) {
            resTypes.add(MenuTreeNodeType.ACTION.getValue());
        }
        if (resTypes.isEmpty() || owners.isEmpty()) {
            return Collections.emptyList();
        }
        List predicateOwner = owners.entrySet().stream().map(entry -> PermissionResRepoProc.QDO.ownerId.eq((Object)((String)entry.getKey())).and((Predicate)PermissionResRepoProc.QDO.ownerType.eq((Object)((PermissionOwnerTypeEnum)entry.getValue()).name()))).collect(Collectors.toList());
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().and(ExpressionUtils.anyOf(predicateOwner)).andIn((SimpleExpression)PermissionResRepoProc.QDO.resType, resTypes).build();
        return super.getValueList((Path)PermissionResRepoProc.QDO.resId, predicate, new OrderSpecifier[0]);
    }
}

