/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.system.model.entity.QSysUserTerminalDO;
import com.elitescloud.cloudt.system.model.entity.SysUserTerminalDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;

@Repository
public class SysUserTerminalRepoProc
extends BaseRepoProc<SysUserTerminalDO> {
    private static final QSysUserTerminalDO QDO = QSysUserTerminalDO.sysUserTerminalDO;

    public SysUserTerminalRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void deleteById(List<Long> ids) {
        this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{SysUserTerminalRepoProc.QDO.id.in(ids)}).execute();
    }

    public void deleteByUserId(Long userId) {
        super.deleteByValue(SysUserTerminalRepoProc.QDO.userId, (Object)userId);
    }

    public void delete(Long userId, Collection<String> terminals) {
        this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{SysUserTerminalRepoProc.QDO.userId.eq((Object)userId).and((Predicate)SysUserTerminalRepoProc.QDO.terminalCode.in(terminals))}).execute();
    }

    public List<String> getTerminalStrByUserId(Long userId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)SysUserTerminalRepoProc.QDO.terminalCode).from((EntityPath)QDO)).where((Predicate)SysUserTerminalRepoProc.QDO.userId.eq((Object)userId))).fetch();
    }

    public List<Terminal> getTerminalByUserId(Long userId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)SysUserTerminalRepoProc.QDO.terminalCode).from((EntityPath)QDO)).where((Predicate)SysUserTerminalRepoProc.QDO.userId.eq((Object)userId))).fetch().stream().map(Terminal::valueOf).collect(Collectors.toList());
    }

    public Map<Long, List<Terminal>> getTerminalByUserId(List<Long> userIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{SysUserTerminalRepoProc.QDO.userId, SysUserTerminalRepoProc.QDO.terminalCode}).from((EntityPath)QDO)).where((Predicate)SysUserTerminalRepoProc.QDO.userId.in(userIds))).fetch().stream().collect(Collectors.groupingBy(tuple -> (Long)tuple.get(SysUserTerminalRepoProc.QDO.userId), Collectors.collectingAndThen(Collectors.toList(), t -> t.stream().map(tuple -> Terminal.valueOf((String)((String)tuple.get((Expression)SysUserTerminalRepoProc.QDO.terminalCode)))).collect(Collectors.toList()))));
    }

    public List<SysUserTerminalDO> queryByUserId(Long userId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)QDO).from((EntityPath)QDO)).where((Predicate)SysUserTerminalRepoProc.QDO.userId.eq((Object)userId))).fetch();
    }
}

