/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.org.TenantOrgPageQueryVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysOrgDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysTenantOrgDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantOrgDO;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class TenantOrgRepoProc
extends BaseRepoProc<SysTenantOrgDO> {
    private static final QSysTenantOrgDO QDO = QSysTenantOrgDO.sysTenantOrgDO;
    private static final QSysOrgDO QDO_ORG = QSysOrgDO.sysOrgDO;

    public TenantOrgRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void updateEnabled(Long id, Boolean enabled) {
        super.updateValue((Path)TenantOrgRepoProc.QDO.enabled, (Object)enabled, id.longValue());
    }

    public void updateAdminId(Long id, Long adminId) {
        super.updateValue((Path)TenantOrgRepoProc.QDO.adminId, (Object)adminId, id.longValue());
    }

    public SysTenantOrgDO getByOrgId(Long orgId) {
        return (SysTenantOrgDO)super.getOneByValue((Path)TenantOrgRepoProc.QDO.orgId, (Object)orgId);
    }

    public Boolean getEnabled(Long id) {
        return (Boolean)super.getValue((Path)TenantOrgRepoProc.QDO.enabled, id.longValue());
    }

    public Long getAdminId(Long id) {
        return (Long)super.getValue((Path)TenantOrgRepoProc.QDO.adminId, id.longValue());
    }

    public Map<Long, Long> queryAdmin(Collection<Long> orgIds) {
        List recordList = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{TenantOrgRepoProc.QDO.orgId, TenantOrgRepoProc.QDO.adminId}).from((EntityPath)QDO)).where((Predicate)TenantOrgRepoProc.QDO.orgId.in(orgIds).and((Predicate)TenantOrgRepoProc.QDO.enabled.eq(Boolean.valueOf(true))))).fetch();
        if (recordList.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Long> result = new HashMap<Long, Long>(recordList.size());
        for (Tuple tuple : recordList) {
            result.put((Long)tuple.get((Expression)TenantOrgRepoProc.QDO.orgId), (Long)tuple.get((Expression)TenantOrgRepoProc.QDO.adminId));
        }
        return result;
    }

    public PagingVO<SysTenantOrgDO> pageMng(TenantOrgPageQueryVO queryVO) {
        SubQueryExpression subQueryExpression = null;
        if (!CharSequenceUtil.isAllBlank((CharSequence[])new CharSequence[]{queryVO.getOrgCode(), queryVO.getOrgName()})) {
            Predicate subPredicate = BaseRepoProc.PredicateBuilder.builder().andLike(StringUtils.hasText((String)queryVO.getOrgCode()), (StringExpression)TenantOrgRepoProc.QDO_ORG.code, queryVO.getOrgCode()).and(StringUtils.hasText((String)queryVO.getOrgName()), () -> {
                String keyword = "%" + queryVO.getOrgName() + "%";
                return TenantOrgRepoProc.QDO_ORG.name.like(keyword).or((Predicate)TenantOrgRepoProc.QDO_ORG.shortName.like(keyword));
            }).build();
            subQueryExpression = (SubQueryExpression)JPAExpressions.select((Expression)TenantOrgRepoProc.QDO_ORG.id).from(new EntityPath[]{QDO_ORG}).where(new Predicate[]{subPredicate});
        }
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)QDO).from((EntityPath)QDO)).where(subQueryExpression == null ? null : TenantOrgRepoProc.QDO.orgId.in(subQueryExpression));
        return super.queryByPage(jpaQuery, queryVO.getPageRequest());
    }

    public Long getOrgIdByCode(@NotBlank String code, boolean includeDisabled) {
        if (includeDisabled) {
            return (Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)TenantOrgRepoProc.QDO.orgId).from((EntityPath)QDO)).where((Predicate)TenantOrgRepoProc.QDO.orgId.eq((Expression)((JPQLQuery)JPAExpressions.select((Expression)TenantOrgRepoProc.QDO_ORG.id).from(new EntityPath[]{QDO_ORG}).where(new Predicate[]{TenantOrgRepoProc.QDO_ORG.code.eq((Object)code)})).limit(1L)))).limit(1L)).fetchOne();
        }
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)TenantOrgRepoProc.QDO.orgId).from((EntityPath)QDO)).where((Predicate)TenantOrgRepoProc.QDO.orgId.eq((Expression)((JPQLQuery)JPAExpressions.select((Expression)TenantOrgRepoProc.QDO_ORG.id).from(new EntityPath[]{QDO_ORG}).where(new Predicate[]{TenantOrgRepoProc.QDO_ORG.code.eq((Object)code).and((Predicate)TenantOrgRepoProc.QDO_ORG.enabled.eq(Boolean.valueOf(true)))})).limit(1L)).and((Predicate)TenantOrgRepoProc.QDO.enabled.eq(Boolean.valueOf(true))))).limit(1L)).fetchOne();
    }
}

