/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.param.IdNameParam;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.constant.AccountType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.req.UserQueryDTO;
import com.elitescloud.cloudt.system.model.vo.query.user.UserListQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.user.UserPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.user.UserListRespVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysTenantUserDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysUserDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysUserOuterappDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysUserTypeDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.TemporalExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class UserRepoProc
extends BaseRepoProc<SysUserDO> {
    private static final Logger logger = LoggerFactory.getLogger(UserRepoProc.class);
    private static final QSysUserDO QDO = QSysUserDO.sysUserDO;
    private static final QSysTenantUserDO QDO_TENANT_USER = QSysTenantUserDO.sysTenantUserDO;
    private static final QSysUserTypeDO QDO_USER_TYPE = QSysUserTypeDO.sysUserTypeDO;
    private static final QSysUserOuterappDO QDO_USER_OUTERAPP = QSysUserOuterappDO.sysUserOuterappDO;
    private final TenantClientProvider tenantClientProvider;
    private final SystemProperties systemProperties;

    public UserRepoProc(TenantClientProvider tenantClientProvider, SystemProperties systemProperties) {
        super((EntityPathBase)QDO);
        this.tenantClientProvider = tenantClientProvider;
        this.systemProperties = systemProperties;
    }

    public void updateEnabled(long id, Boolean enabled) {
        super.updateValue((Path)UserRepoProc.QDO.enabled, (Object)enabled, id);
    }

    public void updateMobile(long id, String mobile) {
        super.updateValue((Path)UserRepoProc.QDO.mobile, (Object)mobile, id);
    }

    public void updateEmail(long id, String email) {
        super.updateValue((Path)UserRepoProc.QDO.email, (Object)email, id);
    }

    public void updateOuterKey(long id, String outerKey) {
        super.updateValue((Path)UserRepoProc.QDO.outerKey, (Object)outerKey, id);
    }

    public void updatePassword(long id, boolean needReset, @NotBlank String password) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)UserRepoProc.QDO.password, (Object)password).set((Path)UserRepoProc.QDO.needReset, (Object)needReset).where(new Predicate[]{UserRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    public void updateCasSyncResult(@NotBlank String userName, Long casUserId) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)UserRepoProc.QDO.casUserId, (Object)casUserId).set((Path)UserRepoProc.QDO.syncCas, (Object)false).where(new Predicate[]{UserRepoProc.QDO.username.eq((Object)userName)}).execute();
    }

    public void updateAvatar(Long id, String avatarUrl, String avatarCode) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)UserRepoProc.QDO.avatarUrl, (Object)avatarUrl).set((Path)UserRepoProc.QDO.avatarCode, (Object)avatarCode).where(new Predicate[]{UserRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    public void clearCasUserId(Collection<Long> ids) {
        this.jpaQueryFactory.update((EntityPath)QDO).setNull((Path)UserRepoProc.QDO.casUserId).set((Path)UserRepoProc.QDO.syncCas, (Object)true).where(new Predicate[]{UserRepoProc.QDO.id.in(ids)}).execute();
    }

    public void updateLoginTime(long id, LocalDateTime loginTime) {
        super.updateValue((Path)UserRepoProc.QDO.lastLoginTime, (Object)loginTime, id);
    }

    public Boolean getEnabled(long id) {
        Boolean userEnabled = (Boolean)super.getValue((Path)UserRepoProc.QDO.enabled, id);
        if (Boolean.FALSE.equals(userEnabled)) {
            return false;
        }
        if (this.supportTenant()) {
            Boolean tenantUserEnabled = (Boolean)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)UserRepoProc.QDO_TENANT_USER.enabled).from((EntityPath)QDO_TENANT_USER)).where((Predicate)UserRepoProc.QDO_TENANT_USER.sysUserId.eq((Object)id))).limit(1L)).fetchOne();
            return Boolean.TRUE.equals(tenantUserEnabled);
        }
        return userEnabled;
    }

    public Map<Long, Boolean> getEnabled(Long tenantId, @NotEmpty Collection<Long> ids) {
        if (tenantId == null || tenantId.longValue() == TenantConstant.DEFAULT_TENANT_ID.longValue()) {
            return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{UserRepoProc.QDO.id, UserRepoProc.QDO.enabled, UserRepoProc.QDO_TENANT_USER.enabled}).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_TENANT_USER)).on((Predicate)UserRepoProc.QDO_TENANT_USER.sysUserId.eq((Expression)UserRepoProc.QDO.id))).fetch().stream().collect(Collectors.toMap(t -> (Long)t.get((Expression)UserRepoProc.QDO.id), t -> Boolean.TRUE.equals(t.get((Expression)UserRepoProc.QDO.enabled)) && Boolean.TRUE.equals(t.get((Expression)UserRepoProc.QDO_TENANT_USER.enabled)), (t1, t2) -> t1));
        }
        return ((JPAQuery)this.jpaQueryFactory.select(new Expression[]{UserRepoProc.QDO.id, UserRepoProc.QDO.enabled}).from((EntityPath)QDO)).fetch().stream().collect(Collectors.toMap(t -> (Long)t.get((Expression)UserRepoProc.QDO.id), t -> Boolean.TRUE.equals(t.get((Expression)UserRepoProc.QDO.enabled)), (t1, t2) -> t1));
    }

    public String getUsername(long id) {
        return (String)super.getValue((Path)UserRepoProc.QDO.username, id);
    }

    public String getPassword(long id) {
        return (String)super.getValue((Path)UserRepoProc.QDO.password, id);
    }

    public Long getCasUserId(long id) {
        return (Long)super.getValue((Path)UserRepoProc.QDO.casUserId, id);
    }

    public boolean existsUsername(@NotBlank String username) {
        return this.exists((Path)UserRepoProc.QDO.username, username);
    }

    public boolean existsOuterKey(@NotBlank String outerKey) {
        return this.exists((Path)UserRepoProc.QDO.outerKey, outerKey);
    }

    public boolean existsUsername(@NotBlank String username, Long id) {
        return this.exists((Path)UserRepoProc.QDO.username, username, id);
    }

    public boolean existsOuterKey(@NotBlank String outerKey, Long id) {
        return this.exists((Path)UserRepoProc.QDO.outerKey, outerKey, id);
    }

    public boolean existsMobile(@NotBlank String mobile) {
        return this.exists((Path)UserRepoProc.QDO.mobile, mobile);
    }

    public boolean existsMobile(@NotBlank String mobile, Long id) {
        return this.exists((Path)UserRepoProc.QDO.mobile, mobile, id);
    }

    public boolean existsEmail(@NotBlank String email) {
        return this.exists((Path)UserRepoProc.QDO.email, email);
    }

    public boolean existsEmail(@NotBlank String email, Long id) {
        return this.exists((Path)UserRepoProc.QDO.email, email, id);
    }

    public boolean existsIdCard(@NotBlank String idCard) {
        return this.exists((Path)UserRepoProc.QDO.idCard, idCard);
    }

    public boolean existsIdCard(@NotBlank String idCard, Long id) {
        return this.exists((Path)UserRepoProc.QDO.idCard, idCard, id);
    }

    public Long getIdByUsername(@NotBlank String username) {
        return super.getIdByValue((Path)UserRepoProc.QDO.username, (Object)username);
    }

    public List<Long> getIdByUsername(@NotEmpty Collection<String> usernames) {
        return super.getIdsByValue((Path)UserRepoProc.QDO.username, usernames, new OrderSpecifier[0]);
    }

    public Map<String, Long> getIdAndUsernameByUsername(@NotEmpty Collection<String> usernames) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{UserRepoProc.QDO.id, UserRepoProc.QDO.username}).from((EntityPath)QDO)).where((Predicate)UserRepoProc.QDO.username.in(usernames))).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)UserRepoProc.QDO.username), t -> (Long)t.get((Expression)UserRepoProc.QDO.id), (t1, t2) -> t1));
    }

    public Map<Long, String> getUsernameAndId(@NotEmpty Collection<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{UserRepoProc.QDO.id, UserRepoProc.QDO.username}).from((EntityPath)QDO)).where((Predicate)UserRepoProc.QDO.id.in(ids))).fetch().stream().collect(Collectors.toMap(t -> (Long)t.get((Expression)UserRepoProc.QDO.id), t -> (String)t.get((Expression)UserRepoProc.QDO.username), (t1, t2) -> t1));
    }

    public List<Long> getIdByMobile(@NotBlank String mobile) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)UserRepoProc.QDO.id).from((EntityPath)QDO)).where((Predicate)UserRepoProc.QDO.mobile.eq((Object)mobile))).fetch();
    }

    public List<Long> getIdByEmail(@NotBlank String email) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)UserRepoProc.QDO.id).from((EntityPath)QDO)).where((Predicate)UserRepoProc.QDO.email.eq((Object)email))).fetch();
    }

    public List<Long> getIdByOuterKey(@NotBlank String outerKey) {
        return super.getIdsByValue((Path)UserRepoProc.QDO.outerKey, (Object)outerKey, new OrderSpecifier[0]);
    }

    public List<Long> getIdByIdCard(@NotBlank String idCard) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)UserRepoProc.QDO.id).from((EntityPath)QDO)).where((Predicate)UserRepoProc.QDO.idCard.eq((Object)idCard))).fetch();
    }

    public SysUserBasicDTO getBasicDto(long id) {
        SysUserBasicDTO user = (SysUserBasicDTO)((JPAQuery)((JPAQuery)this.jpaQueryUserBasic().where((Predicate)UserRepoProc.QDO.id.eq((Object)id))).limit(1L)).fetchOne();
        return this.replaceTenantInfoOfBasic(user);
    }

    public SysUserDO getByUsername(@NotBlank String username) {
        return (SysUserDO)super.getOneByValue((Path)UserRepoProc.QDO.username, (Object)username);
    }

    public SysUserBasicDTO getBasicDto(@NotBlank String username) {
        SysUserBasicDTO user = (SysUserBasicDTO)((JPAQuery)((JPAQuery)this.jpaQueryUserBasic().where((Predicate)UserRepoProc.QDO.username.eq((Object)username))).limit(1L)).fetchOne();
        return this.replaceTenantInfoOfBasic(user);
    }

    public List<SysUserBasicDTO> getBasicDto(Collection<Long> ids) {
        List userList = ((JPAQuery)this.jpaQueryUserBasic().where((Predicate)UserRepoProc.QDO.id.in(ids))).fetch();
        return this.replaceTenantInfoOfBasic(userList);
    }

    public List<SysUserBasicDTO> queryBasicDto(UserQueryDTO queryDTO) {
        Predicate predicate = this.buildPredicate(queryDTO);
        List userList = ((JPAQuery)this.jpaQueryUserBasic().where(predicate)).fetch();
        return this.replaceTenantInfoOfBasic(userList);
    }

    public List<UserListRespVO> queryUser(UserListQueryVO queryVO) {
        Predicate predicateUser = BaseRepoProc.PredicateBuilder.builder().andLike((StringExpression)UserRepoProc.QDO.username, queryVO.getUsernameLike()).andLike(new StringExpression[]{UserRepoProc.QDO.lastName, UserRepoProc.QDO.firstName}, queryVO.getFullNameLike()).andLike(new StringExpression[]{UserRepoProc.QDO.username, UserRepoProc.QDO.lastName, UserRepoProc.QDO.firstName}, queryVO.getFullNameOrUsernameLike()).build();
        long tenantId = this.filterTenant();
        Predicate predicateTenantUser = this.predicateOfTenantUser(tenantId);
        Predicate predicate = ExpressionUtils.and((Predicate)predicateUser, (Predicate)predicateTenantUser);
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanUserListVO()).from((EntityPath)QDO)).where(predicate)).fetch();
    }

    public List<UserListRespVO> queryUserList(Collection<Long> userIds) {
        long tenantId = this.filterTenant();
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)UserRepoProc.QDO.id, userIds).and(this.predicateOfTenantUser(tenantId)).build();
        return super.getList(this.qBeanUserListVO(), predicate, new OrderSpecifier[0]);
    }

    public List<SysUserDO> queryToSyncCas(int size) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)QDO).from((EntityPath)QDO)).where((Predicate)UserRepoProc.QDO.syncCas.eq(Boolean.valueOf(true)).or((Predicate)UserRepoProc.QDO.syncCas.isNull()))).limit((long)size)).fetch();
    }

    public List<Long> queryIdsOfDisabled() {
        long tenantId = this.filterTenant();
        if (tenantId == TenantConstant.DEFAULT_TENANT_ID) {
            return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)UserRepoProc.QDO.id).from((EntityPath)QDO)).where((Predicate)UserRepoProc.QDO.enabled.eq(Boolean.valueOf(false)))).fetch();
        }
        BooleanExpression tenantUserPredicate = ((JPQLQuery)JPAExpressions.select((Expression)UserRepoProc.QDO_TENANT_USER.id).from(new EntityPath[]{QDO_TENANT_USER}).where(new Predicate[]{UserRepoProc.QDO_TENANT_USER.sysUserId.eq((Expression)UserRepoProc.QDO.id).and((Predicate)UserRepoProc.QDO_TENANT_USER.sysTenantId.eq((Object)tenantId)).and((Predicate)UserRepoProc.QDO_TENANT_USER.enabled.eq(Boolean.valueOf(false)))})).exists();
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)UserRepoProc.QDO.id).from((EntityPath)QDO)).where((Predicate)UserRepoProc.QDO.enabled.eq(Boolean.valueOf(false)).or((Predicate)tenantUserPredicate))).fetch();
    }

    public PagingVO<SysUserDO> pageMng(@NotNull GeneralUserDetails currentUser, @NotNull UserPageQueryVO queryVO) {
        long tenantId = this.filterTenant();
        boolean isTenant = tenantId != TenantConstant.DEFAULT_TENANT_ID;
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)QDO).from((EntityPath)QDO);
        if (isTenant) {
            ((JPAQuery)jpaQuery.leftJoin((EntityPath)QDO_TENANT_USER)).on((Predicate)UserRepoProc.QDO_TENANT_USER.sysUserId.eq((Expression)UserRepoProc.QDO.id).and((Predicate)UserRepoProc.QDO_TENANT_USER.sysTenantId.eq((Object)tenantId)));
        }
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andLike((StringExpression)UserRepoProc.QDO.username, queryVO.getUsername()).andLike((StringExpression)UserRepoProc.QDO.mobile, queryVO.getMobile()).andLike((StringExpression)UserRepoProc.QDO.email, queryVO.getEmail()).andLike((StringExpression)UserRepoProc.QDO.lastName, queryVO.getFullName()).andEq(isTenant && queryVO.getEnabled() != null, (SimpleExpression)UserRepoProc.QDO_TENANT_USER.enabled, (Object)queryVO.getEnabled()).andEq(!isTenant && queryVO.getEnabled() != null, (SimpleExpression)UserRepoProc.QDO.enabled, (Object)queryVO.getEnabled()).andEq((SimpleExpression)UserRepoProc.QDO.sourceType, (Object)queryVO.getSourceType()).andEq(isTenant, (SimpleExpression)UserRepoProc.QDO_TENANT_USER.sysTenantId, (Object)tenantId).andNe(true, (SimpleExpression)UserRepoProc.QDO.id, (Object)currentUser.getUserId()).and(StringUtils.hasText((String)queryVO.getUserType()), () -> ((JPQLQuery)JPAExpressions.select((Expression)UserRepoProc.QDO_USER_TYPE.id).from(new EntityPath[]{QDO_USER_TYPE}).where(new Predicate[]{UserRepoProc.QDO_USER_TYPE.userId.eq((Expression)UserRepoProc.QDO.id).and((Predicate)UserRepoProc.QDO_USER_TYPE.type.eq((Object)queryVO.getUserType())).and(!isTenant ? null : UserRepoProc.QDO_USER_TYPE.sysTenantId.eq((Object)tenantId))})).exists()).and(CollUtil.isNotEmpty(queryVO.getUserTypeList()), () -> ((JPQLQuery)JPAExpressions.select((Expression)UserRepoProc.QDO_USER_TYPE.id).from(new EntityPath[]{QDO_USER_TYPE}).where(new Predicate[]{UserRepoProc.QDO_USER_TYPE.userId.eq((Expression)UserRepoProc.QDO.id).and((Predicate)UserRepoProc.QDO_USER_TYPE.type.in(queryVO.getUserTypeList())).and(!isTenant ? null : UserRepoProc.QDO_USER_TYPE.sysTenantId.eq((Object)tenantId))})).exists()).andEq((SimpleExpression)UserRepoProc.QDO.gender, (Object)queryVO.getGender()).andBetween((TemporalExpression)UserRepoProc.QDO.createTime, (Comparable)queryVO.getCreateTimeStart(), (Comparable)queryVO.getCreateTimeEnd()).build();
        jpaQuery.where(predicate);
        PagingVO pageData = this.queryByPage(jpaQuery, queryVO.getPageRequest());
        this.replaceTenantInfoOfDo(pageData.getRecords());
        return pageData;
    }

    public PagingVO<SysUserDO> pageQuery(@NotNull GeneralUserDetails currentUser, @NotNull UserPageQueryVO queryVO) {
        Long tenantId = (Boolean)ObjectUtil.defaultIfNull((Object)queryVO.getAllTenant(), (Object)false) == false ? (this.tenantClientProvider.enabledTenant() ? (Long)ObjectUtil.defaultIfNull((Object)currentUser.getTenantId(), (Object)TenantConstant.DEFAULT_TENANT_ID) : null) : null;
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)QDO).from((EntityPath)QDO);
        if (tenantId != null) {
            ((JPAQuery)jpaQuery.leftJoin((EntityPath)QDO_TENANT_USER)).on((Predicate)UserRepoProc.QDO_TENANT_USER.sysUserId.eq((Expression)UserRepoProc.QDO.id).and((Predicate)UserRepoProc.QDO_TENANT_USER.sysTenantId.eq((Object)tenantId)));
        }
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)UserRepoProc.QDO.id, (Collection)queryVO.getIdSet()).andRightLike(StringUtils.hasText((String)queryVO.getUsername()), (StringExpression)UserRepoProc.QDO.username, queryVO.getUsername()).andRightLike(StringUtils.hasText((String)queryVO.getMobile()), (StringExpression)UserRepoProc.QDO.mobile, queryVO.getMobile()).andRightLike(tenantId == null && StringUtils.hasText((String)queryVO.getEmail()), (StringExpression)UserRepoProc.QDO.email, queryVO.getEmail()).andLike(StringUtils.hasText((String)queryVO.getFullName()), (StringExpression)UserRepoProc.QDO.lastName, queryVO.getFullName()).andEq(tenantId == null && queryVO.getEnabled() != null, (SimpleExpression)UserRepoProc.QDO.enabled, (Object)queryVO.getEnabled()).and(tenantId != null && queryVO.getEnabled() != null, () -> UserRepoProc.QDO.enabled.eq(queryVO.getEnabled()).or((Predicate)UserRepoProc.QDO_TENANT_USER.enabled.eq(queryVO.getEnabled()))).andEq(StringUtils.hasText((String)queryVO.getSourceType()), (SimpleExpression)UserRepoProc.QDO.sourceType, (Object)queryVO.getSourceType()).andEq(tenantId != null, (SimpleExpression)UserRepoProc.QDO_TENANT_USER.sysTenantId, (Object)tenantId).and(StringUtils.hasText((String)queryVO.getUserType()), () -> ((JPQLQuery)JPAExpressions.select((Expression)UserRepoProc.QDO_USER_TYPE.id).from(new EntityPath[]{QDO_USER_TYPE}).where(new Predicate[]{UserRepoProc.QDO_USER_TYPE.userId.eq((Expression)UserRepoProc.QDO.id).and((Predicate)UserRepoProc.QDO_USER_TYPE.type.eq((Object)queryVO.getUserType())).and(tenantId == null ? null : UserRepoProc.QDO_USER_TYPE.sysTenantId.eq((Object)tenantId))})).exists()).and(CollUtil.isNotEmpty(queryVO.getUserTypeList()), () -> ((JPQLQuery)JPAExpressions.select((Expression)UserRepoProc.QDO_USER_TYPE.id).from(new EntityPath[]{QDO_USER_TYPE}).where(new Predicate[]{UserRepoProc.QDO_USER_TYPE.userId.eq((Expression)UserRepoProc.QDO.id).and((Predicate)UserRepoProc.QDO_USER_TYPE.type.in(queryVO.getUserTypeList())).and(tenantId == null ? null : UserRepoProc.QDO_USER_TYPE.sysTenantId.eq((Object)tenantId))})).exists()).andNe((Boolean)ObjectUtil.defaultIfNull((Object)queryVO.getIncludeSelf(), (Object)false) == false, (SimpleExpression)UserRepoProc.QDO.id, (Object)currentUser.getUserId()).andLike(new StringExpression[]{UserRepoProc.QDO.username, UserRepoProc.QDO.lastName, UserRepoProc.QDO.firstName}, queryVO.getKeyword()).build();
        jpaQuery.where(predicate);
        PagingVO pageData = this.queryByPage(jpaQuery, queryVO.getPageRequest());
        this.replaceTenantInfoOfDo(pageData.getRecords());
        return pageData;
    }

    public List<IdNameParam> queryUserName(Collection<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{UserRepoProc.QDO.id, UserRepoProc.QDO.firstName, UserRepoProc.QDO.lastName, UserRepoProc.QDO.username}).from((EntityPath)QDO)).where((Predicate)UserRepoProc.QDO.id.in(ids))).fetch().stream().map(t -> new IdNameParam((Long)t.get((Expression)UserRepoProc.QDO.id), this.buildUserName((String)t.get((Expression)UserRepoProc.QDO.firstName), (String)t.get((Expression)UserRepoProc.QDO.lastName), (String)t.get((Expression)UserRepoProc.QDO.username)))).collect(Collectors.toList());
    }

    public List<SysUserDO> queryByAccount(@NonNull String account) {
        if (this.systemProperties.getAccountTypes().isEmpty()) {
            logger.error("\u672a\u914d\u7f6e\u8d26\u53f7\u7c7b\u578b");
            return Collections.emptyList();
        }
        List accountTypes = this.systemProperties.getAccountTypes();
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq(accountTypes.contains(AccountType.USERNAME), (SimpleExpression)UserRepoProc.QDO.username, (Object)account).andEq(accountTypes.contains(AccountType.MOBILE), (SimpleExpression)UserRepoProc.QDO.mobile, (Object)account).andEq(accountTypes.contains(AccountType.EMAIL), (SimpleExpression)UserRepoProc.QDO.email, (Object)account).buildOr();
        return super.getList(predicate, new OrderSpecifier[0]);
    }

    public List<SysUserDO> queryByOpenId(String appId, @NonNull String openId) {
        if (CharSequenceUtil.isBlank((CharSequence)openId)) {
            return Collections.emptyList();
        }
        Predicate queryBuilder = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)UserRepoProc.QDO_USER_OUTERAPP.outerAppId, (Object)appId).andEq((SimpleExpression)UserRepoProc.QDO_USER_OUTERAPP.openId, (Object)openId).build();
        return ((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)QDO).where((Predicate)UserRepoProc.QDO.id.in((SubQueryExpression)JPAExpressions.select((Expression)UserRepoProc.QDO_USER_OUTERAPP.userId).from(new EntityPath[]{QDO_USER_OUTERAPP}).where(new Predicate[]{queryBuilder})))).fetch();
    }

    public List<SysUserDO> queryByEmail(@NonNull String email) {
        return super.getListByValue((Path)UserRepoProc.QDO.email, (Object)email, new OrderSpecifier[0]);
    }

    public List<SysUserDO> queryByMobile(@NonNull String mobile) {
        return super.getListByValue((Path)UserRepoProc.QDO.mobile, (Object)mobile, new OrderSpecifier[0]);
    }

    public String queryUserName(long id) {
        Tuple tuple = (Tuple)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{UserRepoProc.QDO.id, UserRepoProc.QDO.firstName, UserRepoProc.QDO.lastName, UserRepoProc.QDO.username}).from((EntityPath)QDO)).where((Predicate)UserRepoProc.QDO.id.eq((Object)id))).limit(1L)).fetchOne();
        if (tuple == null) {
            return null;
        }
        return this.buildUserName((String)tuple.get((Expression)UserRepoProc.QDO.firstName), (String)tuple.get((Expression)UserRepoProc.QDO.lastName), (String)tuple.get((Expression)UserRepoProc.QDO.username));
    }

    private String buildUserName(String firstName, String lastName, String username) {
        if (CharSequenceUtil.isBlank((CharSequence)lastName)) {
            return CharSequenceUtil.blankToDefault((CharSequence)firstName, (String)username);
        }
        return lastName + CharSequenceUtil.blankToDefault((CharSequence)firstName, (String)"");
    }

    private Predicate buildPredicate(UserQueryDTO queryDTO) {
        return BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)UserRepoProc.QDO.id, (Collection)queryDTO.getUserIds()).andIn((SimpleExpression)UserRepoProc.QDO.username, (Collection)queryDTO.getUsernames()).andLike((StringExpression)UserRepoProc.QDO.username, (Collection)queryDTO.getUsernameLike()).andRightLike((StringExpression)UserRepoProc.QDO.username, (Collection)queryDTO.getUsernameRightLike()).andIn((SimpleExpression)UserRepoProc.QDO.mobile, (Collection)queryDTO.getMobiles()).andLike((StringExpression)UserRepoProc.QDO.mobile, (Collection)queryDTO.getMobileLike()).andRightLike((StringExpression)UserRepoProc.QDO.mobile, (Collection)queryDTO.getMobileRightLike()).andIn((SimpleExpression)UserRepoProc.QDO.email, (Collection)queryDTO.getEmails()).andLike((StringExpression)UserRepoProc.QDO.email, (Collection)queryDTO.getEmailLike()).andRightLike((StringExpression)UserRepoProc.QDO.email, (Collection)queryDTO.getEmailRightLike()).andIn((SimpleExpression)UserRepoProc.QDO.outerKey, (Collection)queryDTO.getOuterKeys()).andLike((StringExpression)UserRepoProc.QDO.outerKey, (Collection)queryDTO.getOuterKeyLike()).andRightLike((StringExpression)UserRepoProc.QDO.outerKey, (Collection)queryDTO.getOuterKeyRightLike()).andIn((SimpleExpression)UserRepoProc.QDO.lastName, (Collection)queryDTO.getFullNames()).andLike((StringExpression)UserRepoProc.QDO.lastName, (Collection)queryDTO.getFullNameLike()).andRightLike((StringExpression)UserRepoProc.QDO.lastName, (Collection)queryDTO.getFullNameRightLike()).and(queryDTO.getEnabled() != null, () -> {
            if (this.supportTenant()) {
                if (queryDTO.getEnabled().booleanValue()) {
                    return UserRepoProc.QDO.enabled.eq(Boolean.valueOf(true)).and((Predicate)UserRepoProc.QDO_TENANT_USER.enabled.eq(Boolean.valueOf(true)));
                }
                return UserRepoProc.QDO.enabled.eq(Boolean.valueOf(false)).or((Predicate)UserRepoProc.QDO_TENANT_USER.enabled.eq(Boolean.valueOf(false)));
            }
            return UserRepoProc.QDO.enabled.eq(queryDTO.getEnabled());
        }).andIn(CollUtil.isNotEmpty((Collection)queryDTO.getUserTypes()), (SimpleExpression)UserRepoProc.QDO.id, () -> (SubQueryExpression)JPAExpressions.select((Expression)UserRepoProc.QDO_USER_TYPE.userId).from(new EntityPath[]{QDO_USER_TYPE}).where(new Predicate[]{UserRepoProc.QDO_USER_TYPE.type.in((Collection)queryDTO.getUserTypes())})).build();
    }

    private Predicate predicateOfTenantUser(long tenantId) {
        return BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)UserRepoProc.QDO.enabled, (Object)true).and(this.supportTenant(), () -> ((JPQLQuery)JPAExpressions.select((Expression)UserRepoProc.QDO_TENANT_USER.id).from(new EntityPath[]{QDO_TENANT_USER}).where(new Predicate[]{UserRepoProc.QDO_TENANT_USER.sysUserId.eq((Expression)UserRepoProc.QDO.id).and((Predicate)UserRepoProc.QDO_TENANT_USER.sysTenantId.eq((Object)tenantId)).and((Predicate)UserRepoProc.QDO_TENANT_USER.enabled.eq(Boolean.valueOf(true)))})).exists()).build();
    }

    private List<SysUserDO> replaceTenantInfoOfDo(List<SysUserDO> userList) {
        long tenantId = this.filterTenant();
        if (!userList.isEmpty() && TenantConstant.DEFAULT_TENANT_ID != tenantId) {
            Set userIds = userList.stream().map(BaseModel::getId).collect(Collectors.toSet());
            Map<Long, Boolean> tenantUserMap = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{UserRepoProc.QDO_TENANT_USER.sysUserId, UserRepoProc.QDO_TENANT_USER.enabled}).from((EntityPath)QDO_TENANT_USER)).where((Predicate)UserRepoProc.QDO_TENANT_USER.sysUserId.in(userIds).and((Predicate)UserRepoProc.QDO_TENANT_USER.sysTenantId.eq((Object)tenantId)))).fetch().stream().collect(Collectors.toMap(t -> (Long)t.get((Expression)UserRepoProc.QDO_TENANT_USER.sysUserId), t -> (Boolean)ObjectUtil.defaultIfNull((Object)((Boolean)t.get((Expression)UserRepoProc.QDO_TENANT_USER.enabled)), (Object)false), (t1, t2) -> t1));
            for (SysUserDO sysUserDO : userList) {
                if (!Boolean.TRUE.equals(sysUserDO.getEnabled())) continue;
                sysUserDO.setEnabled(tenantUserMap.getOrDefault(sysUserDO.getId(), true));
            }
        }
        return userList;
    }

    private List<SysUserBasicDTO> replaceTenantInfoOfBasic(List<SysUserBasicDTO> userList) {
        long tenantId = this.filterTenant();
        if (!userList.isEmpty() && TenantConstant.DEFAULT_TENANT_ID != tenantId) {
            Set userIds = userList.stream().map(SysUserBasicDTO::getId).collect(Collectors.toSet());
            Map<Long, Boolean> tenantUserMap = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{UserRepoProc.QDO_TENANT_USER.sysUserId, UserRepoProc.QDO_TENANT_USER.enabled}).from((EntityPath)QDO_TENANT_USER)).where((Predicate)UserRepoProc.QDO_TENANT_USER.sysUserId.in(userIds).and((Predicate)UserRepoProc.QDO_TENANT_USER.sysTenantId.eq((Object)tenantId)))).fetch().stream().collect(Collectors.toMap(t -> (Long)t.get((Expression)UserRepoProc.QDO_TENANT_USER.sysUserId), t -> (Boolean)ObjectUtil.defaultIfNull((Object)((Boolean)t.get((Expression)UserRepoProc.QDO_TENANT_USER.enabled)), (Object)false), (t1, t2) -> t1));
            for (SysUserBasicDTO userDto : userList) {
                userDto.setEnabled(tenantUserMap.getOrDefault(userDto.getId(), false));
            }
        }
        return userList;
    }

    private List<Long> filterUserIdByTenant(List<Long> ids, Boolean enabled) {
        long tenantId = this.filterTenant();
        if (CollUtil.isEmpty(ids) || TenantConstant.DEFAULT_TENANT_ID == tenantId) {
            return ids;
        }
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)UserRepoProc.QDO_TENANT_USER.sysUserId, ids).andEq((SimpleExpression)UserRepoProc.QDO_TENANT_USER.enabled, (Object)enabled).build();
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)UserRepoProc.QDO_TENANT_USER.sysUserId).from((EntityPath)QDO_TENANT_USER)).where(predicate)).fetch();
    }

    private SysUserBasicDTO replaceTenantInfoOfBasic(SysUserBasicDTO user) {
        long tenantId = this.filterTenant();
        if (user != null && TenantConstant.DEFAULT_TENANT_ID != tenantId) {
            Boolean enabled = (Boolean)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)UserRepoProc.QDO_TENANT_USER.enabled).from((EntityPath)QDO_TENANT_USER)).where((Predicate)UserRepoProc.QDO_TENANT_USER.sysUserId.eq((Object)user.getId()).and((Predicate)UserRepoProc.QDO_TENANT_USER.sysTenantId.eq((Object)tenantId)))).limit(1L)).fetchOne();
            user.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)enabled, (Object)false));
        }
        return user;
    }

    private long filterTenant() {
        SysTenantDTO tenant = this.tenantClientProvider.getCurrentTenant();
        return tenant == null ? TenantConstant.DEFAULT_TENANT_ID : tenant.getId();
    }

    private boolean supportTenant() {
        SysTenantDTO tenant = this.tenantClientProvider.getCurrentTenant();
        return tenant != null;
    }

    private QBean<SysUserBasicDTO> qBeanUserBasic() {
        return Projections.bean(SysUserBasicDTO.class, (Expression[])new Expression[]{UserRepoProc.QDO.id, UserRepoProc.QDO.username, UserRepoProc.QDO.lastName, UserRepoProc.QDO.firstName, UserRepoProc.QDO.gender, UserRepoProc.QDO.nickName, UserRepoProc.QDO.mobile, UserRepoProc.QDO.email, UserRepoProc.QDO.outerKey, UserRepoProc.QDO.enabled, UserRepoProc.QDO.idCard, UserRepoProc.QDO.avatarUrl, UserRepoProc.QDO.avatarCode});
    }

    private QBean<UserListRespVO> qBeanUserListVO() {
        return Projections.bean(UserListRespVO.class, (Expression[])new Expression[]{UserRepoProc.QDO.id, UserRepoProc.QDO.username, UserRepoProc.QDO.lastName, UserRepoProc.QDO.firstName, UserRepoProc.QDO.nickName, UserRepoProc.QDO.mobile, UserRepoProc.QDO.email});
    }

    private JPAQuery<SysUserBasicDTO> jpaQueryUserBasic() {
        boolean support = this.supportTenant();
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.qBeanUserBasic()).from((EntityPath)QDO);
        if (support) {
            return (JPAQuery)((JPAQuery)jpaQuery.leftJoin((EntityPath)QDO_TENANT_USER)).on((Predicate)UserRepoProc.QDO_TENANT_USER.sysUserId.eq((Expression)UserRepoProc.QDO.id));
        }
        return jpaQuery;
    }
}

