/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.common.param.IdCodeNameCheckParam;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import com.elitescloud.cloudt.system.service.model.entity.QSysEmployeeDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysRoleDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysUserRoleDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserRoleDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Repository;

@Repository
public class UserRoleRepoProc
extends BaseRepoProc<SysUserRoleDO> {
    private static final QSysUserRoleDO QDO = QSysUserRoleDO.sysUserRoleDO;
    private static final QSysRoleDO QDO_ROLE = QSysRoleDO.sysRoleDO;
    private static final QSysEmployeeDO QDO_EMP = QSysEmployeeDO.sysEmployeeDO;

    public UserRoleRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void deleteByUser(@NotNull Long userId) {
        super.deleteByValue((Path)UserRoleRepoProc.QDO.userId, (Object)userId);
    }

    public void deleteByRole(long roleId, boolean employeeOnly) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)UserRoleRepoProc.QDO.roleId, (Object)roleId).and(employeeOnly, () -> ((JPQLQuery)JPAExpressions.select((Expression)UserRoleRepoProc.QDO_EMP.id).from(new EntityPath[]{QDO_EMP}).where(new Predicate[]{UserRoleRepoProc.QDO_EMP.userId.eq((Expression)UserRoleRepoProc.QDO.userId)})).exists()).build();
        super.delete(predicate);
    }

    public void deleteRoleUser(long roleId, Collection<Long> userIds) {
        super.delete((Predicate)UserRoleRepoProc.QDO.roleId.eq((Object)roleId).and((Predicate)UserRoleRepoProc.QDO.userId.in(userIds)));
    }

    public void deleteRolesOfUser(long userId, BelongType.Belonger belonger) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)UserRoleRepoProc.QDO.userId, (Object)userId).and(belonger != null, () -> UserRoleRepoProc.QDO_ROLE.typeId.eq((Object)belonger.getBelongId()).and((Predicate)UserRoleRepoProc.QDO_ROLE.type.eq((Object)belonger.getBelongType().getValue()))).build();
        super.delete(predicate);
    }

    public List<SysUserRoleDO> getByUser(@NotNull Long userId, @NotNull BelongType.Belonger belonger) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq(true, (SimpleExpression)UserRoleRepoProc.QDO.userId, (Object)userId).andNotNull(true, (SimpleExpression)UserRoleRepoProc.QDO.userId).and(belonger != null, () -> UserRoleRepoProc.QDO_ROLE.type.eq((Object)belonger.getBelongType().getValue()).and((Predicate)UserRoleRepoProc.QDO_ROLE.typeId.eq((Object)belonger.getBelongId()))).andEq(true, (SimpleExpression)UserRoleRepoProc.QDO_ROLE.enabled, (Object)true).build();
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)QDO).from((EntityPath)QDO_ROLE)).leftJoin((EntityPath)QDO)).on((Predicate)UserRoleRepoProc.QDO.roleId.eq((Expression)UserRoleRepoProc.QDO_ROLE.id))).where(predicate)).fetch();
    }

    public List<IdCodeNameCheckParam> getByUser(@NotNull Long userId, @NotNull BelongType.Belonger belonger, boolean onlyOwn) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andNotNull(onlyOwn, (SimpleExpression)UserRoleRepoProc.QDO.userId).and(belonger != null, () -> UserRoleRepoProc.QDO_ROLE.type.eq((Object)belonger.getBelongType().getValue()).and((Predicate)UserRoleRepoProc.QDO_ROLE.typeId.eq((Object)belonger.getBelongId()))).andEq(true, (SimpleExpression)UserRoleRepoProc.QDO_ROLE.enabled, (Object)true).build();
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{UserRoleRepoProc.QDO_ROLE.id, UserRoleRepoProc.QDO_ROLE.code, UserRoleRepoProc.QDO_ROLE.name, UserRoleRepoProc.QDO.userId}).from((EntityPath)QDO_ROLE)).leftJoin((EntityPath)QDO)).on((Predicate)UserRoleRepoProc.QDO.roleId.eq((Expression)UserRoleRepoProc.QDO_ROLE.id).and((Predicate)UserRoleRepoProc.QDO.userId.eq((Object)userId)).and((Predicate)UserRoleRepoProc.QDO.deleteFlag.eq((Object)0)))).where(predicate)).fetch().stream().map(t -> {
            IdCodeNameCheckParam param = new IdCodeNameCheckParam();
            param.setId((Long)t.get((Expression)UserRoleRepoProc.QDO_ROLE.id));
            param.setCode((String)t.get((Expression)UserRoleRepoProc.QDO_ROLE.code));
            param.setName((String)t.get((Expression)UserRoleRepoProc.QDO_ROLE.name));
            param.setChecked(Boolean.valueOf(t.get((Expression)UserRoleRepoProc.QDO.userId) != null));
            return param;
        }).collect(Collectors.toList());
    }

    public List<IdCodeNameParam> getRoleOfUser(long userId, Long tenantId, Long tenantOrgId) {
        JPQLQuery roleIdQuery = (JPQLQuery)JPAExpressions.select((Expression)UserRoleRepoProc.QDO.roleId).from(new EntityPath[]{QDO}).where(new Predicate[]{UserRoleRepoProc.QDO.userId.eq((Object)userId)});
        QBean qBean = Projections.bean(IdCodeNameParam.class, (Expression[])new Expression[]{UserRoleRepoProc.QDO_ROLE.id, UserRoleRepoProc.QDO_ROLE.code, UserRoleRepoProc.QDO_ROLE.name});
        List roleList = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qBean).from((EntityPath)QDO_ROLE)).where((Predicate)UserRoleRepoProc.QDO_ROLE.id.in((SubQueryExpression)roleIdQuery).and((Predicate)UserRoleRepoProc.QDO_ROLE.enabled.eq(Boolean.valueOf(true))).and(this.buildPredicateOfBelonger(tenantId, tenantOrgId)))).fetch();
        if (roleList.isEmpty()) {
            return roleList;
        }
        ArrayList<IdCodeNameParam> resultList = new ArrayList<IdCodeNameParam>(roleList.size());
        HashSet<Long> existsCodes = new HashSet<Long>(4);
        for (IdCodeNameParam idCodeNameParam : roleList) {
            if (existsCodes.contains(idCodeNameParam.getId())) continue;
            existsCodes.add(idCodeNameParam.getId());
            resultList.add(idCodeNameParam);
        }
        return resultList;
    }

    public Map<Long, List<IdCodeNameParam>> getRoleOfUser(@NotEmpty Collection<Long> userIds, Long tenantId, Long tenantOrgId) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)UserRoleRepoProc.QDO.userId, userIds).andEq((SimpleExpression)UserRoleRepoProc.QDO_ROLE.enabled, (Object)true).and(this.buildPredicateOfBelonger(tenantId, tenantOrgId)).build();
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{UserRoleRepoProc.QDO.userId, UserRoleRepoProc.QDO_ROLE.id, UserRoleRepoProc.QDO_ROLE.code, UserRoleRepoProc.QDO_ROLE.name}).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_ROLE)).on((Predicate)UserRoleRepoProc.QDO.roleId.eq((Expression)UserRoleRepoProc.QDO_ROLE.id))).where(predicate)).fetch().stream().collect(Collectors.groupingBy(t -> (Long)t.get((Expression)UserRoleRepoProc.QDO.userId), Collectors.collectingAndThen(Collectors.toList(), t -> t.stream().map(tt -> new IdCodeNameParam((Long)tt.get((Expression)UserRoleRepoProc.QDO_ROLE.id), (String)tt.get((Expression)UserRoleRepoProc.QDO_ROLE.code), (String)tt.get((Expression)UserRoleRepoProc.QDO_ROLE.name))).collect(Collectors.toList()))));
    }

    public List<IdCodeNameParam> queryRolesParents(@NotEmpty Collection<String> roleCodes, Long tenantId, Long tenantOrgId) {
        Predicate predicateType = this.buildPredicateOfBelonger(tenantId, tenantOrgId);
        QSysRoleDO QDO_ROLE1 = new QSysRoleDO("role1");
        QBean qBean = Projections.bean(IdCodeNameParam.class, (Expression[])new Expression[]{UserRoleRepoProc.QDO_ROLE.id, UserRoleRepoProc.QDO_ROLE.code, UserRoleRepoProc.QDO_ROLE.name});
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qBean).from((EntityPath)QDO_ROLE)).where((Predicate)UserRoleRepoProc.QDO_ROLE.code.in((SubQueryExpression)JPAExpressions.select((Expression)QDO_ROLE1.parentCode).from(new EntityPath[]{QDO_ROLE1}).where(new Predicate[]{QDO_ROLE1.code.in(roleCodes).and((Predicate)QDO_ROLE1.enabled.eq(Boolean.valueOf(true))).and((Predicate)QDO_ROLE1.parentCode.isNotNull().and((Predicate)QDO_ROLE1.parentCode.ne((Object)"")))})).and((Predicate)UserRoleRepoProc.QDO_ROLE.enabled.eq(Boolean.valueOf(true))).and(predicateType))).fetch();
    }

    public boolean existsRole(long roleId) {
        return super.exists((Path)UserRoleRepoProc.QDO.roleId, (Object)roleId);
    }

    public Set<Long> getUserIdByRole(@NotBlank String roleCode) {
        JPQLQuery roleIdQuery = (JPQLQuery)JPAExpressions.select((Expression)UserRoleRepoProc.QDO_ROLE.id).from(new EntityPath[]{QDO_ROLE}).where(new Predicate[]{UserRoleRepoProc.QDO_ROLE.code.eq((Object)roleCode)});
        return new HashSet<Long>(((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)UserRoleRepoProc.QDO.userId).from((EntityPath)QDO)).where((Predicate)UserRoleRepoProc.QDO.roleId.eq((Expression)roleIdQuery))).fetch());
    }

    public Set<Long> getUserIdsByRole(long roleId) {
        return new HashSet<Long>(((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)UserRoleRepoProc.QDO.userId).from((EntityPath)QDO)).where((Predicate)UserRoleRepoProc.QDO.roleId.eq((Object)roleId))).fetch());
    }

    public Set<Long> getUserIdsByRole(long roleId, boolean employeeOnly) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)UserRoleRepoProc.QDO.roleId, (Object)roleId).and(employeeOnly, () -> ((JPQLQuery)JPAExpressions.select((Expression)UserRoleRepoProc.QDO_EMP.id).from(new EntityPath[]{QDO_EMP}).where(new Predicate[]{UserRoleRepoProc.QDO_EMP.userId.eq((Expression)UserRoleRepoProc.QDO.userId)})).exists()).build();
        return new HashSet<Long>(((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)UserRoleRepoProc.QDO.userId).from((EntityPath)QDO)).where(predicate)).fetch());
    }

    public Set<Long> getUserIdsByRole(Collection<Long> roleIds) {
        return new HashSet<Long>(((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)UserRoleRepoProc.QDO.userId).from((EntityPath)QDO)).where((Predicate)UserRoleRepoProc.QDO.roleId.in(roleIds))).fetch());
    }

    public Map<Long, Set<Long>> getUserIdByRole(Collection<Long> roleIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{UserRoleRepoProc.QDO.userId, UserRoleRepoProc.QDO.roleId}).from((EntityPath)QDO)).where((Predicate)UserRoleRepoProc.QDO.roleId.in(roleIds))).fetch().stream().collect(Collectors.groupingBy(t -> (Long)t.get((Expression)UserRoleRepoProc.QDO.roleId), Collectors.mapping(t -> (Long)t.get((Expression)UserRoleRepoProc.QDO.userId), Collectors.toSet())));
    }

    public Map<Long, Set<String>> getRoleCodesOfUser(@NotEmpty Collection<Long> userIds, BelongType.Belonger belonger) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)UserRoleRepoProc.QDO.userId, userIds).and(belonger != null, () -> UserRoleRepoProc.QDO_ROLE.typeId.eq((Object)belonger.getBelongId()).and((Predicate)UserRoleRepoProc.QDO_ROLE.type.eq((Object)belonger.getBelongType().getValue()))).build();
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{UserRoleRepoProc.QDO.userId, UserRoleRepoProc.QDO_ROLE.code}).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_ROLE)).on((Predicate)UserRoleRepoProc.QDO.roleId.eq((Expression)UserRoleRepoProc.QDO_ROLE.id))).where(predicate)).fetch().stream().collect(Collectors.groupingBy(t -> (Long)t.get((Expression)UserRoleRepoProc.QDO.userId), Collectors.mapping(t -> (String)t.get((Expression)UserRoleRepoProc.QDO_ROLE.code), Collectors.toSet())));
    }

    public List<IdCodeNameParam> getRolesOfUser(long userId, BelongType.Belonger belonger) {
        QBean qBean = Projections.bean(IdCodeNameParam.class, (Expression[])new Expression[]{UserRoleRepoProc.QDO_ROLE.id, UserRoleRepoProc.QDO_ROLE.code, UserRoleRepoProc.QDO_ROLE.name});
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)UserRoleRepoProc.QDO.userId, (Object)userId).and(belonger != null, () -> UserRoleRepoProc.QDO_ROLE.typeId.eq((Object)belonger.getBelongId()).and((Predicate)UserRoleRepoProc.QDO_ROLE.type.eq((Object)belonger.getBelongType().getValue()))).andEq((SimpleExpression)UserRoleRepoProc.QDO_ROLE.enabled, (Object)true).build();
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qBean).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_ROLE)).on((Predicate)UserRoleRepoProc.QDO.roleId.eq((Expression)UserRoleRepoProc.QDO_ROLE.id))).where(predicate)).fetch();
    }

    private Predicate buildPredicateOfBelonger(Long tenantId, Long tenantOrgId) {
        return BaseRepoProc.PredicateBuilder.builder().and((Predicate)UserRoleRepoProc.QDO_ROLE.typeId.eq((Object)"").and((Predicate)UserRoleRepoProc.QDO_ROLE.type.eq((Object)BelongType.CUSTOM.getValue()))).and(tenantId != null, () -> UserRoleRepoProc.QDO_ROLE.typeId.eq((Object)tenantId.toString()).and((Predicate)UserRoleRepoProc.QDO_ROLE.type.eq((Object)BelongType.TENANT.getValue()))).and(tenantOrgId != null, () -> UserRoleRepoProc.QDO_ROLE.typeId.eq((Object)tenantOrgId.toString()).and((Predicate)UserRoleRepoProc.QDO_ROLE.type.eq((Object)BelongType.TENANT_ORG.getValue()))).buildOr();
    }
}

