/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.bo.SysUserTypeBO;
import com.elitescloud.cloudt.system.service.model.entity.QSysUserTypeDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserTypeDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import org.springframework.stereotype.Repository;

@Repository
public class UserTypeRepoProc
extends BaseRepoProc<SysUserTypeDO> {
    private static final QSysUserTypeDO QDO = QSysUserTypeDO.sysUserTypeDO;

    public UserTypeRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void updateIdentityId(long userId, long tenantId, @NotBlank String userType, String identityId) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)UserTypeRepoProc.QDO.identityId, (Object)identityId).where(new Predicate[]{UserTypeRepoProc.QDO.userId.eq((Object)userId).and((Predicate)UserTypeRepoProc.QDO.type.eq((Object)userType)).and((Predicate)UserTypeRepoProc.QDO.sysTenantId.eq((Object)tenantId)).and((Predicate)UserTypeRepoProc.QDO.identityId.isNull().or((Predicate)UserTypeRepoProc.QDO.identityId.isEmpty()))}).execute();
    }

    public void deleteIdentityId(long userId, long tenantId, @NotBlank String userType, String identityId) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)UserTypeRepoProc.QDO.userId, (Object)userId).andEq((SimpleExpression)UserTypeRepoProc.QDO.sysTenantId, (Object)tenantId).andEq((SimpleExpression)UserTypeRepoProc.QDO.type, (Object)userType).and(true, () -> {
            if (CharSequenceUtil.isBlank((CharSequence)identityId)) {
                return UserTypeRepoProc.QDO.identityId.isNull().or((Predicate)UserTypeRepoProc.QDO.identityId.isEmpty());
            }
            return UserTypeRepoProc.QDO.identityId.eq((Object)identityId);
        }).build();
        super.delete(predicate);
    }

    public void deleteByUserId(Long userId, long tenantId) {
        super.delete((Predicate)UserTypeRepoProc.QDO.userId.eq((Object)userId).and((Predicate)UserTypeRepoProc.QDO.sysTenantId.eq((Object)tenantId)));
    }

    public void delete(Long userId, Collection<String> types, long tenantId) {
        this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{UserTypeRepoProc.QDO.userId.eq((Object)userId).and((Predicate)UserTypeRepoProc.QDO.type.in(types)).and((Predicate)UserTypeRepoProc.QDO.sysTenantId.eq((Object)tenantId))}).execute();
    }

    public Set<String> getUserType(Long userId, long tenantId) {
        return new HashSet<String>(((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)UserTypeRepoProc.QDO.type).from((EntityPath)QDO)).where((Predicate)UserTypeRepoProc.QDO.userId.eq((Object)userId).and((Predicate)UserTypeRepoProc.QDO.sysTenantId.eq((Object)tenantId)))).fetch());
    }

    public List<SysUserTypeDO> getUserTypeList(long userId, long tenantId) {
        return super.getList((Predicate)UserTypeRepoProc.QDO.userId.eq((Object)userId).and((Predicate)UserTypeRepoProc.QDO.sysTenantId.eq((Object)tenantId)), new OrderSpecifier[0]);
    }

    public List<SysUserTypeBO> getUserTypeBO(Long userId, long tenantId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanUserType()).from((EntityPath)QDO)).where((Predicate)UserTypeRepoProc.QDO.userId.eq((Object)userId).and((Predicate)UserTypeRepoProc.QDO.sysTenantId.eq((Object)tenantId)))).fetch();
    }

    public Map<Long, Set<String>> getUserTypes(Collection<Long> userId, long tenantId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{UserTypeRepoProc.QDO.userId, UserTypeRepoProc.QDO.type}).from((EntityPath)QDO)).where((Predicate)UserTypeRepoProc.QDO.userId.in(userId).and((Predicate)UserTypeRepoProc.QDO.sysTenantId.eq((Object)tenantId)))).fetch().stream().collect(Collectors.groupingBy(t -> (Long)t.get((Expression)UserTypeRepoProc.QDO.userId), Collectors.collectingAndThen(Collectors.toList(), t -> t.stream().map(tt -> (String)tt.get((Expression)UserTypeRepoProc.QDO.type)).collect(Collectors.toSet()))));
    }

    public Map<Long, List<SysUserTypeBO>> getUserTypeBos(Collection<Long> userId, long tenantId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{UserTypeRepoProc.QDO.userId, UserTypeRepoProc.QDO.type, UserTypeRepoProc.QDO.identityId}).from((EntityPath)QDO)).where((Predicate)UserTypeRepoProc.QDO.userId.in(userId).and((Predicate)UserTypeRepoProc.QDO.sysTenantId.eq((Object)tenantId)))).fetch().stream().collect(Collectors.groupingBy(t -> (Long)t.get((Expression)UserTypeRepoProc.QDO.userId), Collectors.collectingAndThen(Collectors.toList(), t -> t.stream().map(tt -> new SysUserTypeBO((String)tt.get((Expression)UserTypeRepoProc.QDO.type), (String)tt.get((Expression)UserTypeRepoProc.QDO.identityId))).collect(Collectors.toList()))));
    }

    private QBean<SysUserTypeBO> qBeanUserType() {
        return Projections.bean(SysUserTypeBO.class, (Expression[])new Expression[]{UserTypeRepoProc.QDO.type.as("userType"), UserTypeRepoProc.QDO.identityId});
    }
}

