/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.util;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.cloudt.system.service.SysLogService;
import com.elitescloud.cloudt.system.service.impl.SysLogServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtil {
    private static final Logger log = LoggerFactory.getLogger(LogUtil.class);
    private static final Logger logger = LoggerFactory.getLogger(LogUtil.class);
    private static SysLogService sysLogService;

    private static SysLogService getInstance() {
        if (sysLogService == null) {
            sysLogService = (SysLogService)SpringUtil.getBean(SysLogServiceImpl.class);
        }
        return sysLogService;
    }

    public static void info(String message) {
        LogUtil.getInstance().info(message);
    }

    public static void info(String message, Object param) {
        LogUtil.getInstance().info(message, param);
    }

    public static void error(String message) {
        LogUtil.getInstance().error(message, null, "");
    }

    public static void error(String message, String trackTypeError) {
        LogUtil.getInstance().error(message, null, trackTypeError);
    }

    public static void error(String message, Throwable ex) {
        LogUtil.getInstance().error(message, null, ex);
    }

    public static void error(String message, Object param, Throwable ex) {
        LogUtil.getInstance().error(message, param, ex);
    }

    public static void error(String message, Object param, String trackTypeError) {
        LogUtil.getInstance().error(message, param, trackTypeError);
    }

    public static void info(String trackType, String message, Object param) {
        LogUtil.getInstance().info(trackType, message, param);
    }

    public static void error(String trackType, String message, Object param, Throwable ex) {
        LogUtil.getInstance().error(trackType, message, param, ex);
    }

    public static void error(String trackType, String message, Object param, String trackTypeError) {
        LogUtil.getInstance().error(trackType, message, param, trackTypeError);
    }
}

