/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.ucenter.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.vo.param.GenerateTableParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.ReceiptSourceConfigPagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.resp.ReceiptSourceConfigDetailPagingRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.ReceiptSourceConfigPagingRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.ReceiptSourceConfigSaveVO;
import com.elitescloud.cloudt.ucenter.service.ReceiptSourceConfigService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/receipt/source/config"}, produces={"application/json"})
@Api(tags={"\u5355\u636e\u6765\u6e90\u914d\u7f6e"})
public class ReceiptSourceConfigController {
    private static final Logger log = LoggerFactory.getLogger(ReceiptSourceConfigController.class);
    private final ReceiptSourceConfigService receiptSourceConfigService;

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u5355\u636e\u6765\u6e90\u914d\u7f6e\u7f16\u8f91/\u4fee\u6539")
    @ApiOperationSupport(order=1)
    public ApiResult<Long> save(@RequestBody @Valid ReceiptSourceConfigSaveVO saveVO) {
        return ApiResult.ok((Object)this.receiptSourceConfigService.save(saveVO));
    }

    @DeleteMapping(value={"/delete"})
    @ApiOperation(value="\u5355\u636e\u6765\u6e90\u914d\u7f6e\u5220\u9664")
    @ApiOperationSupport(order=1)
    public ApiResult<?> delete(@RequestBody List<Long> ids) {
        return ApiResult.ok((Object)this.receiptSourceConfigService.delete(ids));
    }

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5355\u636e\u6765\u6e90\u914d\u7f6e\u5206\u9875\u67e5\u8be2")
    @ApiOperationSupport(order=1)
    public ApiResult<PagingVO<ReceiptSourceConfigPagingRespVO>> searchPaging(@RequestBody ReceiptSourceConfigPagingParam param) {
        return ApiResult.ok(this.receiptSourceConfigService.searchPaging(param));
    }

    @PostMapping(value={"/detail/search"})
    @ApiOperation(value="\u6765\u6e90\u914d\u7f6e\u660e\u7ec6\u5206\u9875\u67e5\u8be2")
    @ApiOperationSupport(order=1)
    public ApiResult<PagingVO<ReceiptSourceConfigDetailPagingRespVO>> detailSearchPaging(@RequestBody @Validated ReceiptSourceConfigPagingParam param) {
        return ApiResult.ok(this.receiptSourceConfigService.detailSearchPaging(param));
    }

    @PostMapping(value={"/generate/table"})
    @ApiOperation(value="\u5355\u636e\u6765\u6e90\u914d\u7f6e\u751f\u6210\u8868\u4f53")
    @ApiOperationSupport(order=1)
    public ApiResult<?> generateTable(@RequestBody GenerateTableParam param) {
        return ApiResult.ok((Object)this.receiptSourceConfigService.generateTable(param));
    }

    @PostMapping(value={"/test"})
    @ApiOperation(value="\u6765\u6e90\u5355\u636e\u6d4b\u8bd5")
    @ApiOperationSupport(order=1)
    public ApiResult<?> test(String sourceNo) {
        return ApiResult.ok((Object)this.receiptSourceConfigService.test(sourceNo));
    }

    public ReceiptSourceConfigController(ReceiptSourceConfigService receiptSourceConfigService) {
        this.receiptSourceConfigService = receiptSourceConfigService;
    }
}

