/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.ucenter.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.dto.AdSpaceDTO;
import com.elitescloud.cloudt.ucenter.api.vo.param.AdSpacePagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.resp.AdSpaceRespVO;
import com.elitescloud.cloudt.ucenter.entity.AdSpaceDO;
import com.elitescloud.cloudt.ucenter.entity.QAdSpaceDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class AdSpaceRepoProc
extends BaseRepoProc<AdSpaceDO> {
    private static final QAdSpaceDO Q_DO = QAdSpaceDO.adSpaceDO;

    protected AdSpaceRepoProc() {
        super((EntityPathBase)Q_DO);
    }

    public PagingVO<AdSpaceDTO> findAdSpacePagingResults(AdSpacePagingParam param) {
        JPAQuery<AdSpaceDTO> query = this.select(AdSpaceDTO.class);
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (!StringUtils.isEmpty((CharSequence)param.getAdSpaceCodeName())) {
            String likeStr = "%" + param.getAdSpaceCodeName() + "%";
            predicates.add(AdSpaceRepoProc.Q_DO.adSpaceCode.like(likeStr).or((Predicate)AdSpaceRepoProc.Q_DO.adSpaceName.like(likeStr)));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getShowStyle())) {
            predicates.add(AdSpaceRepoProc.Q_DO.showStyle.eq((Object)param.getShowStyle()));
        }
        predicates.add(AdSpaceRepoProc.Q_DO.deleteFlag.eq((Object)0).or((Predicate)AdSpaceRepoProc.Q_DO.deleteFlag.isNull()));
        query.where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, Q_DO);
        param.setPaging(query);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{AdSpaceRepoProc.Q_DO.id, AdSpaceRepoProc.Q_DO.adSpaceCode, AdSpaceRepoProc.Q_DO.adSpaceName, AdSpaceRepoProc.Q_DO.adSpaceDesc, AdSpaceRepoProc.Q_DO.sortNo, AdSpaceRepoProc.Q_DO.showStyle})).from((EntityPath)Q_DO);
    }

    public List<AdSpaceRespVO> queryByCodes(List<String> codes) {
        List fetch = ((JPAQuery)((JPAQuery)this.select(AdSpaceRespVO.class).where((Predicate)AdSpaceRepoProc.Q_DO.adSpaceCode.in(codes))).where((Predicate)AdSpaceRepoProc.Q_DO.deleteFlag.eq((Object)0).or((Predicate)AdSpaceRepoProc.Q_DO.deleteFlag.isNull()))).fetch();
        return fetch;
    }

    public Long updateByCode(List<String> code, Integer deleteFlag) {
        Long res = this.jpaQueryFactory.update((EntityPath)Q_DO).set(AdSpaceRepoProc.Q_DO.deleteFlag, (Object)deleteFlag).where(new Predicate[]{AdSpaceRepoProc.Q_DO.adSpaceCode.in(code)}).execute();
        return res;
    }

    private Predicate buildPredicate(AdSpacePagingParam adSpacePagingParam) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andLike(StringUtils.isNotBlank((CharSequence)adSpacePagingParam.getAdSpaceCodeName()), (StringExpression)AdSpaceRepoProc.Q_DO.adSpaceCode, adSpacePagingParam.getAdSpaceCodeName()).buildOr();
        return predicate;
    }
}

