/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.ucenter.rmi;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.core.udc.UdcProvider;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RmiSysUDCService {
    private static final Logger log = LoggerFactory.getLogger(RmiSysUDCService.class);
    @Autowired
    private UdcProvider sysUdcService;

    public Map<String, String> getCodeMap(String domain, String udc) {
        try {
            return this.sysUdcService.getValueMapByUdcCode(domain, udc);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2UDC\u5f02\u5e38:{}", (Object)e.getMessage());
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2UDC\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38");
        }
    }

    public Map<String, Map<String, String>> getCodeMap(String domain, List<String> udcCodes) {
        try {
            return this.sysUdcService.getValueMapByUdcCode(domain, new HashSet<String>(udcCodes));
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2UDC\u5f02\u5e38:{}", (Object)e.getMessage());
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2UDC\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38");
        }
    }
}

