/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.ucenter.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.el.coordinator.boot.fsm.model.dto.FileObjDTO;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.dto.AdInfoDTO;
import com.elitescloud.cloudt.ucenter.api.dto.AdSpaceDTO;
import com.elitescloud.cloudt.ucenter.api.dto.ArticleInfoDTO;
import com.elitescloud.cloudt.ucenter.api.vo.param.AdInfoPagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.AdInfoQueryParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.AdInfoShowParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.AdInfoSortParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.AdSpacePagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.ArticleInfoPagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.LinkAddressPagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.resp.AdInfoDetailRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.AdInfoRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.AdSpaceRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.ArticleLinkRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.AdInfoSaveVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.AdSpaceSaveVO;
import com.elitescloud.cloudt.ucenter.common.constant.UdcEnum;
import com.elitescloud.cloudt.ucenter.convert.AdManageConvert;
import com.elitescloud.cloudt.ucenter.convert.ArticleManageConvert;
import com.elitescloud.cloudt.ucenter.entity.AdInfoDO;
import com.elitescloud.cloudt.ucenter.entity.AdSpaceDO;
import com.elitescloud.cloudt.ucenter.repo.AdInfoRepo;
import com.elitescloud.cloudt.ucenter.repo.AdInfoRepoProc;
import com.elitescloud.cloudt.ucenter.repo.AdSpaceRepo;
import com.elitescloud.cloudt.ucenter.repo.AdSpaceRepoProc;
import com.elitescloud.cloudt.ucenter.repo.ArticleInfoRepoProc;
import com.elitescloud.cloudt.ucenter.service.AdManageService;
import com.elitescloud.cloudt.ucenter.utils.SysGenerator;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdManageServiceImpl
extends BaseServiceImpl
implements AdManageService {
    private static final Logger log = LoggerFactory.getLogger(AdManageServiceImpl.class);
    private static final String UDC_LINK_TYPE = "LINK_TYPE";
    private static final String UDC_SHOW_FLAG = "SHOW_FLAG";
    private static final String UDC_TARGET_TYPE = "TARGET_TYPE";
    private static final String UDC_SOURCE_TYPE = "SOURCE_TYPE";
    @Autowired
    private AdSpaceRepo adSpaceRepo;
    @Autowired
    private AdInfoRepo adInfoRepo;
    @Autowired
    private AdSpaceRepoProc adSpaceRepoProc;
    @Autowired
    private AdInfoRepoProc adInfoRepoProc;
    @Autowired
    private ArticleInfoRepoProc articleInfoRepoProc;
    @Autowired
    private SysGenerator sysGenerator;
    @Autowired
    private FileService<String> fileService;

    @Override
    @SysCodeProc
    public PagingVO<AdSpaceRespVO> adSpacePagingSearch(AdSpacePagingParam param) {
        PagingVO<AdSpaceDTO> result = this.adSpaceRepoProc.findAdSpacePagingResults(param);
        List records = result.getRecords();
        return PagingVO.builder().records(AdManageConvert.INSTANCE.adSpaceDtoSToVoS(records)).total(result.getTotal()).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdateAdSpace(AdSpaceSaveVO saveVO) {
        if (ObjectUtil.isNull((Object)saveVO.getId())) {
            if (this.adSpaceRepo.existsByAdSpaceName(saveVO.getAdSpaceName())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5e7f\u544a\u4f4d\u540d\u79f0\u5df2\u5b58\u5728");
            }
            AdSpaceDO spaceDO = AdManageConvert.INSTANCE.copyAdSpaceSaveToDo(saveVO);
            AdSpaceDO save = (AdSpaceDO)this.adSpaceRepo.save(spaceDO);
            return save.getId();
        }
        Optional optional = this.adSpaceRepo.findById(saveVO.getId());
        if (optional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u627e\u5230\u5e7f\u544a\u4f4d\u4fe1\u606f");
        }
        AdSpaceDO spaceDO = (AdSpaceDO)optional.get();
        spaceDO.setAdSpaceDesc(saveVO.getAdSpaceDesc());
        if (StrUtil.isNotEmpty((CharSequence)saveVO.getShowStyle())) {
            spaceDO.setShowStyle(saveVO.getShowStyle());
        }
        this.adSpaceRepo.save(spaceDO);
        return spaceDO.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> deleteAdInfo(List<Long> ids) {
        List<AdInfoDO> byId = this.adInfoRepo.findAllByIdIn(ids);
        if (CollectionUtil.isNotEmpty(byId)) {
            List<Long> deleteIds = byId.stream().filter(info -> ObjectUtil.equals((Object)info.getShowFlag(), (Object)UdcEnum.AD_SHOW_FLAG_HIDE.getValueCode())).map(info -> info.getId()).collect(Collectors.toList());
            this.adInfoRepo.deleteAdInfoByIds(deleteIds, "1");
            return deleteIds;
        }
        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5e7f\u544a\u4fe1\u606f");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdateAdInfo(AdInfoSaveVO saveVO) {
        AdSpaceDO spaceDO = this.adSpaceRepo.findByAdSpaceCode(saveVO.getAdSpaceCode());
        if (ObjectUtil.isNull((Object)saveVO.getId())) {
            String adCode = this.sysGenerator.generateCode("AD_NO");
            if (this.adInfoRepo.existsByAdCode(adCode)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u751f\u6210\u7684\u5e7f\u544a\u7f16\u53f7\uff1a" + adCode + " \u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53d1\u53f7\u5668\u914d\u7f6e\u662f\u5426\u6b63\u786e");
            }
            saveVO.setAdCode(adCode);
        } else {
            Optional optional = this.adInfoRepo.findById(saveVO.getId());
            if (optional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u627e\u5230\u6307\u5b9a\u5e7f\u544a\u4fe1\u606f");
            }
            AdInfoDO adInfoDO = (AdInfoDO)optional.get();
            if (StrUtil.equals((CharSequence)adInfoDO.getShowFlag(), (CharSequence)UdcEnum.AD_SHOW_FLAG_DISPLAY.getValueCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u7f16\u8f91\u9690\u85cf\u72b6\u6001\u7684\u5e7f\u544a\u4fe1\u606f");
            }
        }
        AdInfoDO adInfoDO = AdManageConvert.INSTANCE.copyAdInfoSaveToDo(saveVO);
        if (ObjectUtil.isNotNull((Object)spaceDO)) {
            adInfoDO.setAdSpaceCode(spaceDO.getAdSpaceCode()).setAdSpaceId(spaceDO.getId()).setAdSpaceName(spaceDO.getAdSpaceName());
        }
        AdInfoDO saveDo = (AdInfoDO)this.adInfoRepo.save(adInfoDO);
        return saveDo.getId();
    }

    @Override
    @SysCodeProc
    public PagingVO<AdInfoRespVO> search(AdInfoPagingParam searchParam) {
        List<AdInfoDO> infoDOS = this.adInfoRepo.findAllByShowFlag(UdcEnum.AD_SHOW_FLAG_DISPLAY.getValueCode());
        List<Long> list = infoDOS.stream().filter(item -> item.getShowEndTime().isBefore(LocalDateTime.now())).filter(item -> StrUtil.equals((CharSequence)UdcEnum.AD_SHOW_FLAG_DISPLAY.getValueCode(), (CharSequence)item.getShowFlag())).map(item -> item.getId()).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(list)) {
            this.adInfoRepo.updateShowFlagByIds(list, UdcEnum.AD_SHOW_FLAG_HIDE.getValueCode());
        }
        PagingVO<AdInfoDTO> result = this.adInfoRepoProc.findAdInfoPagingResults(searchParam);
        List records = result.getRecords();
        return PagingVO.builder().records(AdManageConvert.INSTANCE.adInfoDtoSToVoS(records)).total(result.getTotal()).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Object showUpdate(AdInfoShowParam param) {
        Optional byId = this.adInfoRepo.findById(param.getId());
        if (byId.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6ca1\u6709\u67e5\u8be2\u5230\u5e7f\u544a\u4fe1\u606f");
        }
        LocalDateTime showEndTime = ((AdInfoDO)byId.get()).getShowEndTime();
        if (ObjectUtil.isNotNull((Object)showEndTime) && LocalDateTime.now().isAfter(showEndTime)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u663e\u793a\u65f6\u95f4\u7ef4\u62a4\u6709\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5");
        }
        return this.adInfoRepo.updateShowFlagById(param.getId(), param.getShowFlag());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer sortUpdate(AdInfoSortParam param) {
        return this.adInfoRepo.updateSortNoById(param.getId(), param.getSortNo());
    }

    @Override
    @SysCodeProc
    public AdInfoDetailRespVO queryInfoDetail(Long id) {
        Optional byId = this.adInfoRepo.findById(id);
        if (byId.isPresent()) {
            return AdManageConvert.INSTANCE.infoDoToDetailVo((AdInfoDO)byId.get());
        }
        throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6ca1\u6709\u67e5\u8be2\u5230\u5e7f\u544a\u4fe1\u606f");
    }

    @Override
    @SysCodeProc
    public Object queryLinkAddress(LinkAddressPagingParam param) {
        if (StrUtil.equals((CharSequence)param.getTargetType(), (CharSequence)UdcEnum.WS_TARGET_TYPE_ARTICLE.getValueCode())) {
            ArticleInfoPagingParam pagingParam = ArticleManageConvert.INSTANCE.paramToParam(param);
            PagingVO<ArticleInfoDTO> results = this.articleInfoRepoProc.findArticleInfoPagingResults(pagingParam);
            List<ArticleLinkRespVO> respVoList = ArticleManageConvert.INSTANCE.infoDTOsToVos(results.getRecords());
            return PagingVO.builder().total(results.getTotal()).records(respVoList).build();
        }
        if (StrUtil.equals((CharSequence)param.getTargetType(), (CharSequence)UdcEnum.WS_TARGET_TYPE_AD.getValueCode())) {
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Override
    public List<AdInfoDetailRespVO> queryDetailList(AdInfoQueryParam queryParam) {
        List fileObjs;
        List<AdInfoDO> adList;
        if (queryParam == null) {
            queryParam = new AdInfoQueryParam();
        }
        if ((adList = this.adInfoRepoProc.queryList(queryParam)).isEmpty()) {
            return Collections.emptyList();
        }
        Set fileCodes = adList.stream().flatMap(t -> Stream.of(t.getImgFileCode(), t.getVideoFileCode())).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toSet());
        Map<Object, Object> fileUrlMap = !fileCodes.isEmpty() ? (CollUtil.isNotEmpty((Collection)(fileObjs = (List)this.fileService.queryDto(new ArrayList(fileCodes)).getData())) ? fileObjs.stream().collect(Collectors.toMap(FileObjDTO::getFileCode, FileObjDTO::getUrl, (v1, v2) -> v1)) : Collections.emptyMap()) : Collections.emptyMap();
        Map udcMap = super.udcMap("cloudt-system", Set.of(UDC_LINK_TYPE, UDC_SHOW_FLAG, UDC_TARGET_TYPE, UDC_SOURCE_TYPE));
        return adList.stream().map(t -> {
            AdInfoDetailRespVO adVO = AdManageConvert.INSTANCE.infoDoToDetailVo((AdInfoDO)t);
            if (adVO.getAdLinkType() != null) {
                adVO.setAdLinkTypeName((String)udcMap.getOrDefault(UDC_LINK_TYPE, Collections.emptyMap()).get(adVO.getAdLinkType()));
            }
            if (adVO.getShowFlag() != null) {
                adVO.setShowFlagName((String)udcMap.getOrDefault(UDC_SHOW_FLAG, Collections.emptyMap()).get(adVO.getShowFlag()));
            }
            if (adVO.getTargetType() != null) {
                adVO.setTargetTypeName((String)udcMap.getOrDefault(UDC_TARGET_TYPE, Collections.emptyMap()).get(adVO.getTargetType()));
            }
            if (adVO.getSourceType() != null) {
                adVO.setSourceTypeName((String)udcMap.getOrDefault(UDC_SOURCE_TYPE, Collections.emptyMap()).get(adVO.getSourceType()));
            }
            if (adVO.getImgFileCode() != null) {
                adVO.setImgUrl((String)fileUrlMap.get(adVO.getImgFileCode()));
            }
            if (adVO.getVideoFileCode() != null) {
                adVO.setVideoUrl((String)fileUrlMap.get(adVO.getVideoFileCode()));
            }
            return adVO;
        }).collect(Collectors.toList());
    }
}

