/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.ucenter.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.cloudt.ucenter.common.constant.UdcEnum;
import com.elitescloud.cloudt.ucenter.rmi.RmiSysNextNumberService;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SysGenerator {
    private static final Logger log = LoggerFactory.getLogger(SysGenerator.class);
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final UdcProvider udcProvider;

    public String generateCode(String ruleCode) {
        String code = this.rmiSysNextNumberService.generateCode("yst-ucenter", ruleCode, Collections.emptyList());
        return code;
    }

    public String getUdcName(String udcCode, String valueCode) {
        Set udcCodeSet = Arrays.stream(UdcEnum.values()).map(udcEnum -> udcEnum.getCode()).collect(Collectors.toSet());
        Map udcCodeValueMap = this.udcProvider.getValueMapByUdcCode("yst-ucenter", udcCodeSet);
        Map map = (Map)udcCodeValueMap.get(udcCode);
        return CollectionUtil.isEmpty((Map)map) ? null : (StrUtil.isBlank((CharSequence)valueCode) ? null : (String)map.get(valueCode));
    }

    public SysGenerator(RmiSysNextNumberService rmiSysNextNumberService, UdcProvider udcProvider) {
        this.rmiSysNextNumberService = rmiSysNextNumberService;
        this.udcProvider = udcProvider;
    }
}

