ALTER TABLE sys_tenant_menu_tree
    DROP INDEX idx_tenant_menu_tree_tenant;
ALTER TABLE sys_tenant_menu_tree
    DROP COLUMN sys_tenant_id;
alter table sys_notice
    add column sys bit default 0 comment '是否系统公告';

CREATE TABLE `sys_unify_query_record`
(
    `id`                   bigint NOT NULL COMMENT '记录唯一ID',
    `user_id`              bigint       DEFAULT NULL COMMENT '查询用户ID',
    `query_time`           datetime(6)  DEFAULT NULL COMMENT '查询时间',
    `finish_time`          datetime(6)  DEFAULT NULL COMMENT '查询结束时间',
    `cost_time`            bigint       DEFAULT NULL COMMENT '耗时，毫秒',
    `success`              bit(1)       DEFAULT b'1' COMMENT '是否查询成功',
    `fail_reason`          longtext COMMENT '失败原因',
    `app_code`             varchar(255) DEFAULT NULL COMMENT '所属应用编码',
    `business_object_code` varchar(255) DEFAULT NULL COMMENT '查询业务对象编码',
    `business_fields`      varchar(255) DEFAULT NULL COMMENT '查询业务字段',
    `business_params`      varchar(255) DEFAULT NULL COMMENT '查询业务参数',
    `query_type`           varchar(255) DEFAULT NULL COMMENT '查询类型',
    `sql_txt`              longtext COMMENT 'SQL',
    `sql_params`           longtext COMMENT 'SQL参数',
    `query_result`         longtext COMMENT '查询结果',
    `tenant_id`            bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`        bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`        bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`               varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`       bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`              varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`          datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`       bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`              varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`          datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`          int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`   int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`            bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`          bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`            bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_unifyquery_rd_user` (`user_id`),
    KEY `idx_unifyquery_rd_app` (`app_code`),
    KEY `idx_unifyquery_rd_bus` (`business_object_code`),
    KEY `idx_unifyquery_rd_querytime` (`query_time`)
) COMMENT ='统一查询记录';