CREATE TABLE `sys_warning_rule`
(
    `id`                    bigint       NOT NULL COMMENT '记录唯一ID',
    `rule_code`             varchar(255) NOT NULL COMMENT '规则编码',
    `rule_name`             varchar(255) NOT NULL COMMENT '规则名称',
    `enabled`               bit(1)       DEFAULT b'0' COMMENT '启用状态',
    `description`           varchar(255) DEFAULT NULL COMMENT '规则描述',
    `scene`                 varchar(255) NOT NULL COMMENT '业务场景, [UDC]cloudt-system:WARNING_SCENE',
    `exec_time_type`        varchar(255) NOT NULL COMMENT '执行时间类型',
    `exec_time_values`      varchar(255) DEFAULT NULL COMMENT '执行时间值, 以逗号分隔 (周：[一、二、三、四、五、六、日]; 月[1、2、3、4等]; 自定义[yyyy-MM-dd])',
    `exec_start_time`       time         DEFAULT NULL COMMENT '执行开始时间',
    `excluded_workday`      bit(1)       DEFAULT NULL COMMENT '是否开启工作日免打扰',
    `workday_start_time`    time         DEFAULT NULL COMMENT '工作日免打扰-开始时间',
    `workday_end_time`      time         DEFAULT NULL COMMENT '工作日免打扰-截止时间',
    `notice_rate_value`     varchar(255) DEFAULT NULL COMMENT '通知频率',
    `custom_notice_rate`    int          DEFAULT NULL COMMENT '自定义通知频率值(分钟)',
    `notice_tmpl_code`      varchar(255) DEFAULT NULL COMMENT '消息模板编码',
    `send_types`            varchar(255) DEFAULT NULL COMMENT '推送方式, 多个以逗号分隔',
    `enabled_recv_by_role`  bit(1)       DEFAULT b'0' COMMENT '推送对象-按角色',
    `recv_role_codes`       varchar(255) DEFAULT NULL COMMENT '推送对象-角色编码, 多个以逗号分隔',
    `only_push_warning_obj` bit(1)       DEFAULT b'0' COMMENT '推送对象-仅针对预警对象',
    `enabled_recv_by_user`  bit(1)       DEFAULT b'0' COMMENT '推送对象-按用户',
    `recv_user_ids`         varchar(255) DEFAULT NULL COMMENT '推送对象-用户ID, 多个以逗号分隔',
    `tenant_id`             bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`         bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`         bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`        bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`               varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`           datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`        bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`               varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`           datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`           int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`    int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`             bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`           bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`             bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_warning_rule_code` (`rule_code`),
    KEY `idx_warning_rule_scene` (`scene`)
) COMMENT ='预警规则';

CREATE TABLE `sys_warning_scene_cond`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `rule_code`          varchar(255) NOT NULL COMMENT '规则编码',
    `cond_term`          varchar(255) NOT NULL COMMENT '条件项, [UDC]WARNING_CONDITION',
    `opr_value`          varchar(255) NOT NULL COMMENT '条件值',
    `value_list_json`    longtext COMMENT '数据范围',
    `rel_value`          varchar(255) DEFAULT NULL COMMENT '条件值',
    `sort_no`            int          DEFAULT '0' COMMENT '排序号',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_warning_scene_cond_code` (`rule_code`)
) COMMENT ='预警规则的场景条件';

CREATE TABLE `sys_warning_record`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `rule_code`          varchar(255) NOT NULL COMMENT '规则编码',
    `exec_time`          datetime(6)  NOT NULL COMMENT '执行时间',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `scene`              varchar(255) NOT NULL COMMENT '业务场景, [UDC]cloudt-system:WARNING_SCENE',
    `finish_time`        datetime(6)  NOT NULL COMMENT '执行结束时间',
    `num_total`          int          DEFAULT '0' COMMENT '校验结果数',
    `num_success`        int          DEFAULT '0' COMMENT '校验成功结果数',
    `num_fail`           int          DEFAULT '0' COMMENT '校验失败结果数',
    PRIMARY KEY (`id`),
    KEY `idx_warning_record_code` (`rule_code`),
    KEY `idx_warning_record_exectime` (`exec_time`),
    KEY `idx_warning_record_scene` (`scene`)
) COMMENT ='预警执行记录';

CREATE TABLE `sys_warning_record_detail`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `mas_id`             bigint NOT NULL COMMENT '主表ID',
    `doc_id`             bigint       DEFAULT NULL COMMENT '业务单据ID',
    `doc_code`           varchar(255) DEFAULT NULL COMMENT '业务单据编号',
    `doc_name`           varchar(255) DEFAULT NULL COMMENT '业务单据名称',
    `verify_pass`        bit(1)       DEFAULT b'0' COMMENT '是否校验通过',
    `verify_time`        datetime(6)  DEFAULT NULL COMMENT '校验时间',
    `noticed`            bit(1)       DEFAULT b'0' COMMENT '是否已通知用户',
    `noticed_user_ids`   varchar(255) DEFAULT NULL COMMENT '通知的用户ID',
    `notice_fail_reason` varchar(255) DEFAULT NULL COMMENT '通知失败原因',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_warning_record_d_masid` (`mas_id`),
    KEY `idx_warning_record_d_doccode` (`doc_code`)
) COMMENT ='预警执行记录明细';
CREATE TABLE `sys_warning_record_notice`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `mas_id`             bigint NOT NULL COMMENT '主表ID',
    `notice_user_id`     bigint       DEFAULT NULL COMMENT '通知的用户ID',
    `user_account`       varchar(255) DEFAULT NULL COMMENT '通知的用户账号',
    `notice_tmpl_code`   varchar(255) DEFAULT NULL COMMENT '通知的消息模板编码',
    `notice_channel`     varchar(255) DEFAULT NULL COMMENT '通知的渠道',
    `notice_sent`        bit(1)       DEFAULT b'0' COMMENT '是否已发送',
    `sent_time`          datetime(6)  DEFAULT NULL COMMENT '发送时间',
    `notice_content`     longtext COMMENT '通知内容',
    `fail_reason`        varchar(255) DEFAULT NULL COMMENT '失败原因',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_warning_record_notice_mas` (`mas_id`)
) COMMENT ='预警执行记录的通知信息';