
package com.elitescloud.cloudt.customfield.controller;


import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.MapSearcher;
import cn.zhxu.bs.SearchResult;
import com.elitescloud.boot.core.support.customfield.enums.CustomFieldTypeEnum;
import com.elitescloud.boot.core.support.customfield.model.BasicUdcVO;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.BeanSearcherFactory;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.CloudBeanSearcherEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.customfield.entity.CustomFieldDefinitionDo;
import com.elitescloud.cloudt.customfield.model.CustomFieldDefinitionSaveParam;
import com.elitescloud.cloudt.customfield.model.CustomFieldDefinitionUpdateParam;
import com.elitescloud.cloudt.customfield.sbean.CustomFieldDefinitionQueryBean;
import com.elitescloud.cloudt.customfield.service.CustomFieldDefinitionService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

@Slf4j
@RestController
@RequestMapping("/customFieldDefinition")
@Api(value = "动态自定义字段-字段定义管理", tags = {"动态自定义字段-字段定义管理"})
public class CustomFieldDefinitionController {
   private final CustomFieldDefinitionService customFieldService;
   private BeanSearcher beanSearcher;

   private MapSearcher mapSearcher;

   public CustomFieldDefinitionController(BeanSearcherFactory beanSearcherFactory,
                                          CustomFieldDefinitionService customFieldService) {
      this.customFieldService = customFieldService;
      this.beanSearcher = beanSearcherFactory.getBeanSearcherService(CloudBeanSearcherEnum.BS_TENANT);
      this.mapSearcher = beanSearcherFactory.getMapBeanSearcherService(CloudBeanSearcherEnum.BS_TENANT);
   }


   @PostMapping("/page/searcher")
   @ApiOperation(value = "字段检索Bs方式", notes = "字段检索Bs方式")
   public ApiResult<SearchResult<CustomFieldDefinitionQueryBean>> pageSearcher(
           @RequestBody Map<String, Object> param, HttpServletRequest request) {
      var obj = beanSearcher.search(CustomFieldDefinitionQueryBean.class, param);
      return ApiResult.ok(obj);
   }
   @PostMapping("/createCustomField")
   @ApiOperation(value = "字段新增", notes = "字段新增")
   public ApiResult<Long> createCustomField(@RequestBody CustomFieldDefinitionSaveParam param) {
      return customFieldService.createCustomField(param);
   }
   @PostMapping("/{businessObjectCode}/deleteAndCreateCustomFieldBatch")
   @ApiOperation(value = "批量新增字段，先删除后新增", notes = "批量新增字段，先删除后新增")
   public ApiResult<Long> deleteAndCreateCustomField(@PathVariable String businessObjectCode,@RequestBody List<CustomFieldDefinitionSaveParam> param) {
      return customFieldService.deleteAndCreateCustomField(businessObjectCode,param);
   }

   @GetMapping("/{id}/getCustomFieldById")
   @ApiOperation(value = "字段ID查询字段信息", notes = "字段ID查询字段信息")
   public ApiResult<CustomFieldDefinitionDo> getCustomFieldById(@PathVariable Long id) {
      return ApiResult.ok(customFieldService.getCustomFieldById(id));
   }
   @GetMapping("/{code}/getCustomFieldByCode")
   @ApiOperation(value = "字段编码查询字段信息", notes = "字段编码查询字段信息")
   public ApiResult<CustomFieldDefinitionDo> getCustomFieldByCode(@PathVariable String code) {
      return ApiResult.ok(customFieldService.getCustomFieldByCode(code));
   }

   @PutMapping("/{id}/updateCustomField")
   @ApiOperation(value = "更新字段", notes = "更新字段")
   public ApiResult<Long> updateCustomField(@PathVariable Long id,
                                            @RequestBody CustomFieldDefinitionUpdateParam param) {
      return customFieldService.updateCustomField(id, param);
   }

   @DeleteMapping("/{id}/deleteCustomField")
   @ApiOperation(value = "删除字段", notes = "删除字段")
   public ApiResult<Void> deleteCustomField(@PathVariable Long id) {
      customFieldService.deleteCustomField(id);
      return ApiResult.ok();
   }

   @GetMapping("/udc/fieldTypeEnum")
   @ApiOperation(value = "返回模型字段类型枚举", notes = "返回模型字段类型枚举")
   public ApiResult<List<BasicUdcVO>> getFieldTypeEnum() {
      return ApiResult.ok(CustomFieldTypeEnum.getSysUdcVOList());
   }

}
