package com.elitescloud.cloudt.datadiff.context;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.elitescloud.cloudt.datadiff.vo.AuditDiffVO;
import org.springframework.expression.spel.support.StandardEvaluationContext;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2023/08/29
 */
public class AuditLogContext {

    private static final TransmittableThreadLocal<StandardEvaluationContext> CONTEXT_THREAD_LOCAL = new TransmittableThreadLocal<>();

    public static final String CONTEXT_KEY_NAME_RETURN = "_return";

    public static final String CONTEXT_KEY_NAME_ERROR_MSG = "_errorMsg";

    public static StandardEvaluationContext getContext() {
        return ObjectUtil.defaultIfNull(CONTEXT_THREAD_LOCAL.get(), new StandardEvaluationContext());
    }

    public static void putVariable(String key, Object value) {
        StandardEvaluationContext context = getContext();
        context.setVariable(key, value);
        CONTEXT_THREAD_LOCAL.set(context);
    }

    public static Object getVariable(String key) {
        StandardEvaluationContext context = getContext();
        return context.lookupVariable(key);
    }

    public static void clearContext() {
        CONTEXT_THREAD_LOCAL.remove();
    }

    private static final TransmittableThreadLocal<List<AuditDiffVO>> DIFF_VO_LIST_THREAD_LOCAL = new TransmittableThreadLocal<>();

    public static List<AuditDiffVO> getDiffVOList() {
        return CollUtil.defaultIfEmpty(DIFF_VO_LIST_THREAD_LOCAL.get(), new ArrayList<>());
    }

    public static void addDiff(AuditDiffVO auditDiffVO) {
        if (auditDiffVO != null) {
            List<AuditDiffVO> auditDiffVOList = getDiffVOList();
            auditDiffVOList.add(auditDiffVO);
            DIFF_VO_LIST_THREAD_LOCAL.set(auditDiffVOList);
        }
    }

    public static void clearDiffVOList() {
        DIFF_VO_LIST_THREAD_LOCAL.remove();
    }
}
