package com.elitescloud.cloudt.datadiff.log.domain;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.mapstruct.factory.Mappers;
import com.elitescloud.cloudt.datadiff.log.resp.SysDataModifyLogRespVO;
import com.elitescloud.cloudt.datadiff.log.request.SysDataModifyLogSaveVO;
import com.elitescloud.cloudt.datadiff.log.entity.SysDataModifyLogDO;
import com.elitescloud.cloudt.system.dto.SysDataModifyLogDTO;

import java.util.List;

/**
 *
 * @author nc
 * @since 2025-08-21
 */
@Mapper(config = BaseMapperConfig.class)
public interface SysDataModifyLogConvert{
   SysDataModifyLogConvert INSTANCE = Mappers.getMapper(SysDataModifyLogConvert.class);

   SysDataModifyLogRespVO dtoToRespVO(SysDataModifyLogDTO dto);

   List<SysDataModifyLogRespVO> dosToRespVOS(List<SysDataModifyLogDO> dos);

   SysDataModifyLogDTO doToDto(SysDataModifyLogDO domain);

   List<SysDataModifyLogDTO> dosToDtos(List<SysDataModifyLogDTO> dos);

   SysDataModifyLogDO saveVoToDO(SysDataModifyLogSaveVO saveVO);

   List<SysDataModifyLogDO> saveVosToDOS(List<SysDataModifyLogSaveVO> saveVOS);

   @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
   void copySaveParamToDo(SysDataModifyLogSaveVO saveVO, @MappingTarget SysDataModifyLogDO topicDO);

}