package com.elitescloud.cloudt.datadiff.log.domain;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.datadiff.log.request.SysDataModifyLogPageParamVO;
import com.elitescloud.cloudt.datadiff.log.request.SysDataModifyLogSaveVO;
import com.elitescloud.cloudt.datadiff.log.resp.SysDataModifyLogRespVO;
import com.elitescloud.cloudt.system.dto.SysDataModifyLogDTO;
import com.elitescloud.cloudt.datadiff.log.request.SysDataModifyLogParamVO;
import com.elitescloud.cloudt.datadiff.log.resp.SysDataModifyLogPageRespVO;
import java.util.List;
import java.util.Optional;

/**
 * @author nc
 * @since 2025-08-21
 */
public interface SysDataModifyLogDomainService{

	/**
	 * 分页查询
	 *
	 * @param paramVO
	 * @return
	 */
	PagingVO<SysDataModifyLogPageRespVO> queryList(SysDataModifyLogPageParamVO paramVO);

	/**
	 * 详情查询
	 *
	 * @param id
	 * @return
	 */
	Optional<SysDataModifyLogDTO> findById(Long id);

	/**
	 *
	 * 保存
	 *
	 * @param saveVO 保存值对象
	 * @return 返回保存后的ID
	 */
	Long save(SysDataModifyLogSaveVO saveVO);

	/**
	 * 删除
	 *
	 * @param ids
	 */
	void deleteByIds(List<Long> ids);

	/**
	 * 根据参数查询
	 *
	 * @param paramVO
	 * @return
	 */
	List<SysDataModifyLogRespVO> findByParam(SysDataModifyLogParamVO paramVO);

}
