package com.elitescloud.cloudt.datadiff.log.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;

@Entity
@Table(name = "sys_data_modify_log")
@org.hibernate.annotations.Table(appliesTo = "sys_data_modify_log", comment = "数据变更日志")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class SysDataModifyLogDO extends BaseModel implements Serializable {

    @Serial
    private static final long serialVersionUID = -9120843820421060761L;

    @Comment("业务单据类型(供应商变更,商品变更,客户变更)")
    @Column
    private String masType;

    @Comment("业务单据ID")
    @Column
    private Long masId;

    @Comment("业务数据ID")
    @Column
    private Long dataId;

    @Comment("业务数据编码")
    @Column
    private String dataCode;

    @Comment("变更人id")
    @Column
    private Long modifyPersonId;

    @Comment("变更人")
    @Column
    private String modifyPerson;

    @Comment("变更时间")
    @Column
    private LocalDateTime modifyDate;

    @Comment("变更内容Json")
    @Lob
    private String modifyContentJson;

}
