package com.elitescloud.cloudt.datadiff.log.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.datadiff.log.request.SysDataModifyLogPageParamVO;
import com.elitescloud.cloudt.datadiff.log.request.SysDataModifyLogSaveVO;
import com.elitescloud.cloudt.datadiff.log.resp.SysDataModifyLogRespVO;
import com.elitescloud.cloudt.datadiff.log.resp.SysDataModifyLogPageRespVO;
import java.util.List;
import java.util.Optional;

/**
 * @author nc
 * @since 2025-08-21
 */
public interface SysDataModifyLogService{

	/**
	 * 分页查询
	 *
	 * @param paramVO 查询参数
	 * @return 分页结果
	 */
	PagingVO<SysDataModifyLogPageRespVO> page(SysDataModifyLogPageParamVO paramVO);

	/**
	 * 根据ID查询
	 *
	 * @param id ID
	 * @return 信息
	 */
	Optional<SysDataModifyLogRespVO> findById(Long id);

	/**
	 * 保存
	 *
	 * @param saveVO 保存参数
	 * @return ID
	 */
	Long save(SysDataModifyLogSaveVO saveVO);


	/**
	 * 批量删除
	 *
	 * @param ids ID列表
	 */
	void deleteByIds(List<Long> ids);

}
