package com.elitescloud.cloudt.groupitem;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemPageParamVO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemParamVO;
import com.elitescloud.cloudt.system.dto.resp.SysEmployeeGroupItemPageRespVO;
import com.elitescloud.cloudt.system.dto.resp.SysEmployeeGroupItemRespVO;
import com.elitescloud.cloudt.system.model.entity.QSysEmployeeGroupItemDO;
import com.elitescloud.cloudt.system.util.BeanUtils;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class SysEmployeeGroupItemRepoProc {
    private final JPAQueryFactory jpaQueryFactory;

    private final QSysEmployeeGroupItemDO sysEmployeeGroupItemDO = QSysEmployeeGroupItemDO.sysEmployeeGroupItemDO;

    public long deleteByGroupId(Long groupId) {
        var jpaQuery = jpaQueryFactory.delete(sysEmployeeGroupItemDO)
                .where(sysEmployeeGroupItemDO.employeeGroupId.eq(groupId));
        return  jpaQuery.execute();
    }

    public long countBy(SysEmployeeGroupItemPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(sysEmployeeGroupItemDO.count())
                .from(sysEmployeeGroupItemDO);
        Long count = jpaQuery.where(where(paramVO)).fetchOne();
        return count != null ? count : 0L;
    }

    private final QBean<SysEmployeeGroupItemPageRespVO> pageList = Projections.bean(
            SysEmployeeGroupItemPageRespVO.class,
            sysEmployeeGroupItemDO.id,
            sysEmployeeGroupItemDO.employeeGroupId,
            sysEmployeeGroupItemDO.itemScopeType,
            sysEmployeeGroupItemDO.itemScopeCode,
            sysEmployeeGroupItemDO.itemScopeName,
            sysEmployeeGroupItemDO.itemScopeNameAlias,
            sysEmployeeGroupItemDO.itemScopeParentCode,
            sysEmployeeGroupItemDO.itemScopeParentName,
            sysEmployeeGroupItemDO.itemScopeDescription,
            sysEmployeeGroupItemDO.itemScopeStatus,
            sysEmployeeGroupItemDO.remark,
            sysEmployeeGroupItemDO.createUserId,
            sysEmployeeGroupItemDO.creator,
            sysEmployeeGroupItemDO.createTime,
            sysEmployeeGroupItemDO.modifyUserId,
            sysEmployeeGroupItemDO.updater,
            sysEmployeeGroupItemDO.modifyTime,
            sysEmployeeGroupItemDO.deleteFlag
    );

    public List<SysEmployeeGroupItemPageRespVO> pageBy(SysEmployeeGroupItemPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(pageList)
                .from(sysEmployeeGroupItemDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, sysEmployeeGroupItemDO);
        jpaQuery.where(where(paramVO));
        return jpaQuery.fetch();
   }

   private Predicate where(SysEmployeeGroupItemPageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (paramVO.getEmployeeGroupId() != null) {
            predicates.add(sysEmployeeGroupItemDO.employeeGroupId.eq(paramVO.getEmployeeGroupId()));
        }
        if (StrUtil.isNotBlank(paramVO.getItemScopeType())) {
            predicates.add(sysEmployeeGroupItemDO.itemScopeType.eq(paramVO.getItemScopeType()));
        }
        if (StrUtil.isNotBlank(paramVO.getItemScopeCode())) {
            predicates.add(sysEmployeeGroupItemDO.itemScopeCode.eq(paramVO.getItemScopeCode()));
        }
        if (StrUtil.isNotBlank(paramVO.getItemScopeName())) {
            predicates.add(sysEmployeeGroupItemDO.itemScopeName.eq(paramVO.getItemScopeName()));
        }
        if (StrUtil.isNotBlank(paramVO.getItemScopeNameAlias())) {
            predicates.add(sysEmployeeGroupItemDO.itemScopeNameAlias.eq(paramVO.getItemScopeNameAlias()));
        }
        if (StrUtil.isNotBlank(paramVO.getItemScopeParentCode())) {
            predicates.add(sysEmployeeGroupItemDO.itemScopeParentCode.eq(paramVO.getItemScopeParentCode()));
        }
        if (StrUtil.isNotBlank(paramVO.getItemScopeParentName())) {
            predicates.add(sysEmployeeGroupItemDO.itemScopeParentName.eq(paramVO.getItemScopeParentName()));
        }
        if (StrUtil.isNotBlank(paramVO.getItemScopeDescription())) {
            predicates.add(sysEmployeeGroupItemDO.itemScopeDescription.eq(paramVO.getItemScopeDescription()));
        }
        if (StrUtil.isNotBlank(paramVO.getItemScopeStatus())) {
            predicates.add(sysEmployeeGroupItemDO.itemScopeStatus.eq(paramVO.getItemScopeStatus()));
        }
        return ExpressionUtils.allOf(predicates);
   }

   public long deleteByIds(List<Long> ids) {
       List<Predicate> predicates = new ArrayList<>();
       predicates.add(sysEmployeeGroupItemDO.id.in(ids));
       var delete = jpaQueryFactory.delete(sysEmployeeGroupItemDO)
               .where(ExpressionUtils.allOf(predicates));
       return delete.execute();
   }

   public List<SysEmployeeGroupItemRespVO> findByParam(SysEmployeeGroupItemParamVO paramVO) {
       List<Predicate> predicates = new ArrayList<>();
       var jpaQuery = jpaQueryFactory.select(Projections.bean(SysEmployeeGroupItemRespVO.class,
                sysEmployeeGroupItemDO.id,
                sysEmployeeGroupItemDO.employeeGroupId,
                sysEmployeeGroupItemDO.itemScopeType,
                sysEmployeeGroupItemDO.itemScopeCode,
                sysEmployeeGroupItemDO.itemScopeName,
                sysEmployeeGroupItemDO.itemScopeNameAlias,
                sysEmployeeGroupItemDO.itemScopeParentCode,
                sysEmployeeGroupItemDO.itemScopeParentName,
                sysEmployeeGroupItemDO.itemScopeDescription,
                sysEmployeeGroupItemDO.itemScopeStatus,
                sysEmployeeGroupItemDO.remark,
                sysEmployeeGroupItemDO.createUserId,
                sysEmployeeGroupItemDO.creator,
                sysEmployeeGroupItemDO.createTime,
                sysEmployeeGroupItemDO.modifyUserId,
                sysEmployeeGroupItemDO.updater,
                sysEmployeeGroupItemDO.modifyTime,
                sysEmployeeGroupItemDO.deleteFlag
       )).from(sysEmployeeGroupItemDO);
       SysEmployeeGroupItemPageParamVO sysEmployeeGroupItemPageParamVO=new SysEmployeeGroupItemPageParamVO();
       BeanUtils.copyProperties(paramVO,sysEmployeeGroupItemPageParamVO);
       jpaQuery.where(where(sysEmployeeGroupItemPageParamVO));
       return jpaQuery.fetch();
   }

}