package com.elitescloud.cloudt.groupitem;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemPageParamVO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemSaveHeadVO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemSaveVO;
import com.elitescloud.cloudt.system.dto.resp.SysEmployeeGroupItemPageRespVO;
import com.elitescloud.cloudt.system.dto.resp.SysEmployeeGroupItemRespVO;

import java.util.List;
import java.util.Optional;

/**
 * @author nc
 * @since 2025-09-09
 */
public interface SysEmployeeGroupItemService{

	/**
	 * 分页查询
	 *
	 * @param paramVO 查询参数
	 * @return 分页结果
	 */
	PagingVO<SysEmployeeGroupItemPageRespVO> page(SysEmployeeGroupItemPageParamVO paramVO);

	/**
	 * 根据ID查询
	 *
	 * @param id ID
	 * @return 信息
	 */
	Optional<SysEmployeeGroupItemRespVO> findById(Long id);

	/**
	 * 保存
	 *
	 * @param saveVO 保存参数
	 * @return ID
	 */
	Long save(SysEmployeeGroupItemSaveHeadVO saveVO);


	/**
	 * 批量删除
	 *
	 * @param ids ID列表
	 */
	void deleteByIds(List<Long> ids);

}
