package com.elitescloud.cloudt.groupitem;

import cn.hutool.core.bean.BeanUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemPageParamVO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemParamVO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemSaveHeadVO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemSaveVO;
import com.elitescloud.cloudt.system.dto.resp.SysEmployeeGroupItemPageRespVO;
import com.elitescloud.cloudt.system.dto.resp.SysEmployeeGroupItemRespVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;




/**
 * <p>
 * SysEmployeeGroupItemDO 服务层
 * </p>
 *
 * @author nc
 * @since 2025-09-09
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class SysEmployeeGroupItemServiceImpl implements SysEmployeeGroupItemService{

	private final SysEmployeeGroupItemDomainService sysEmployeeGroupItemDomainService;
	private final SysEmployeeGroupItemRepo sysEmployeeGroupItemRepo;
	private final SysEmployeeGroupItemRepoProc sysEmployeeGroupItemRepoProc;
	@Override
	@SysCodeProc
    public PagingVO<SysEmployeeGroupItemPageRespVO> page(SysEmployeeGroupItemPageParamVO paramVO) {
        return sysEmployeeGroupItemDomainService.queryList(paramVO);
    }

	@Override
	@SysCodeProc
	public Optional<SysEmployeeGroupItemRespVO> findById(Long id) {
		return sysEmployeeGroupItemDomainService.findById(id).map(SysEmployeeGroupItemConvert.INSTANCE::dtoToRespVO);
	}

//	@Override
//	@Transactional(rollbackFor = Exception.class)
//	public Long save(SysEmployeeGroupItemSaveVO saveVO) {
//		if(saveVO.getEmployeeGroupId()==null){
//			throw new BusinessException("员工组ID不能为空");
//		}
//		sysEmployeeGroupItemRepoProc.deleteByGroupId(saveVO.getEmployeeGroupId());
//		return sysEmployeeGroupItemDomainService.save(saveVO);
//	}
	@Override
	@Transactional(rollbackFor = Exception.class)
	public Long save(SysEmployeeGroupItemSaveHeadVO saveVO) {
		if(saveVO.getEmployeeGroupId()==null){
			throw new BusinessException("员工组ID不能为空");
		}
		List<SysEmployeeGroupItemSaveVO> list=saveVO.getItemList();
		if(list==null|| list.isEmpty()){
			throw new BusinessException("员工组范围数据不能为空");
		}
		//读取员工组的全部范围
		SysEmployeeGroupItemParamVO sysEmployeeGroupItemParamVO=new SysEmployeeGroupItemParamVO();
		sysEmployeeGroupItemParamVO.setEmployeeGroupId(saveVO.getEmployeeGroupId());
		List<SysEmployeeGroupItemRespVO> sysEmployeeGroupItemRespVOS=
				sysEmployeeGroupItemDomainService.findByParam(sysEmployeeGroupItemParamVO);
		//循环如果范围类型和编码重复,则不保存
		for (SysEmployeeGroupItemSaveVO item : list){
			boolean flag=true;
			if(sysEmployeeGroupItemRespVOS!=null&& !sysEmployeeGroupItemRespVOS.isEmpty()){
				 for(SysEmployeeGroupItemRespVO vo:sysEmployeeGroupItemRespVOS){
					 if(item.getItemScopeCode().equals(vo.getItemScopeCode())
					 &&item.getItemScopeType().equals(vo.getItemScopeType())){
						 flag=false;
						 break;
					 }
				 }
			}
			if(flag) {
				sysEmployeeGroupItemDomainService.save(item);
			}
		}
		return (long) list.size();
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public void deleteByIds(List<Long> ids) {
		sysEmployeeGroupItemDomainService.deleteByIds(ids);
	}

}
