package com.elitescloud.cloudt.log.controller;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023-11-28 11:58
 */

import cn.zhxu.bs.MapSearcher;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.log.service.OperationLogMqMessageService;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.service.common.constant.BusinessObjectEnum;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.elitescloud.cloudt.common.base.ApiResult;


@Slf4j
@RestController
@RequestMapping(value = "/MQController")
@Api(tags = "【测试】操作日志测试接口")
public class OperationLogMqDemoController {

    private final OperationLogMqMessageService messageService;
    private final MapSearcher mapSearcher;
    public OperationLogMqDemoController(@Autowired(required = false) OperationLogMqMessageService messageService,
                                        MapSearcher mapSearcher) {
        this.messageService = messageService;
        this.mapSearcher = mapSearcher;
    }

    @GetMapping("/sendAsyncOperationLogMqMessage")
    @ApiOperation(value = "异步消息发送测试")
    @ApiOperationSupport(order = 1)
    public ApiResult sendAsyncOperationLogMqMessage() {
       var operationLogDto= messageService.quickNewOperationLogDTO(
               BusinessObjectEnum.TEST,
               "NO001", OperationTypeEnum.ADD,"新增一个单据");
       return messageService.sendAsyncOperationLogMqMessage(operationLogDto);
    }
    @GetMapping("/sendSyncOperationLogMqMessage")
    @ApiOperation(value = "同步消息发送测试")
    @ApiOperationSupport(order = 2)
    public ApiResult sendSyncOperationLogMqMessage() {

        var operationLogDto= messageService.quickNewOperationLogDTO(
                BusinessObjectEnum.SysPlatformUdc,
                "NO002",OperationTypeEnum.ELSE,"操作描述123");
        operationLogDto.setOperationTypeName("自定义操作");
        return messageService.sendSyncOperationLogMqMessage(operationLogDto);
    }


}
