package com.elitescloud.cloudt.system.common;

import cn.hutool.core.util.ObjectUtil;
import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 17:48
 * @Description:
 */
@Data
@ConfigurationProperties(prefix = LoggingProperties.LOGGING_PREFIX)
public class LoggingProperties implements InitializingBean {
    public static final String LOGGING_PREFIX = "cbpl.logging";

    /**
     * 系统日志：协助开发问题定位
     */
    @NestedConfigurationProperty
    private LoggingProperty syslog;

    /**
     * 审计日志：业务单据变更履历
     */
    @NestedConfigurationProperty
    private LoggingProperty audit;

    /**
     * 接口日志：内外部接口的调用
     */
    @NestedConfigurationProperty
    private LoggingProperty infinity;

    /**
     * 埋点日志：辅助业务的统计需求工作
     */
    @NestedConfigurationProperty
    private LoggingProperty track;

    public static LoggingProperty LOG_SYSLOG_CFG;
    public static LoggingProperty LOG_AUDIT_CFG;
    public static LoggingProperty LOG_INFINITY_CFG;
    public static LoggingProperty LOG_TRACK_CFG;

    @Override
    public void afterPropertiesSet() throws Exception {
        // 系统日志
        LOG_SYSLOG_CFG = ObjectUtil.defaultIfNull(syslog, new LoggingProperty());
        LOG_SYSLOG_CFG.setLogType(LogType.SYSLOG);
        // 审计日志
        LOG_AUDIT_CFG = ObjectUtil.defaultIfNull(audit, new LoggingProperty());
        LOG_AUDIT_CFG.setLogType(LogType.AUDIT);
        // 接口日志
        LOG_INFINITY_CFG = ObjectUtil.defaultIfNull(infinity, new LoggingProperty());
        LOG_INFINITY_CFG.setLogType(LogType.INFINITY);
        // 埋点日志
        LOG_TRACK_CFG = ObjectUtil.defaultIfNull(track, new LoggingProperty());
        LOG_TRACK_CFG.setLogType(LogType.TRACK);
    }
}
