package com.elitescloud.cloudt.system.component.service.impl;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.component.param.SysUserComponentPagingParam;
import com.elitescloud.cloudt.system.component.service.SysComponentService;
import com.elitescloud.cloudt.system.service.repo.old.SysUserRepoProc;
import com.elitescloud.cloudt.system.service.vo.component.SysUserComponentPagingVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author Chris
 * 2021-06-02
 */
@Service
public class SysComponentServiceImpl implements SysComponentService {

    @Autowired
    private SysUserRepoProc sysUserRepoProc;

    /**
     * 获取用户分页数据，只能获取被启用的用户 - 放大镜组件
     *
     * @param param 分页条件
     * @return 分页结果
     */
    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    @TenantOrgTransaction(useTenantOrg = false)
    @Override
    public PagingVO<SysUserComponentPagingVO> findSysUserPagingByParam(SysUserComponentPagingParam param) {
        return sysUserRepoProc.findSysUserComPagingByParam(param);
    }
}
