package com.elitescloud.cloudt.system.controller.common.system;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonPublishedNoticePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonPublishedNoticePageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonPublishedNoticeRespVO;
import com.elitescloud.cloudt.system.service.CommonQueryService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/22
 */
@Api(tags = "通用服务查询接口")
@RestController
@RequestMapping(value = "/common/serviceQuery", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class CommonQueryController {

    private final CommonQueryService queryService;

    public CommonQueryController(CommonQueryService queryService) {
        this.queryService = queryService;
    }

    @ApiOperation(value = "分页查询已发布的公告")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/notice/page")
    public ApiResult<PagingVO<CommonPublishedNoticePageRespVO>> pageQueryPublishedNotice(@RequestBody CommonPublishedNoticePageQueryVO queryVO) {
        return queryService.pageQueryPublishedNotice(queryVO);
    }

    @ApiOperation(value = "查看公告详情")
    @ApiOperationSupport(order = 2)
    @ApiImplicitParam(name = "id", value = "公告ID", required = true, dataType = "long")
    @GetMapping(value = "/notice/view")
    public ApiResult<CommonPublishedNoticeRespVO> viewPublishedNotice(@RequestParam(name = "id") @NotNull(message = "公告ID为空") Long id) {
        return queryService.viewPublishedNotice(id);
    }
}
