package com.elitescloud.cloudt.system.controller.devops;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.devops.BasicDataRecordPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.BasicRecordExportPageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.BasicRecordImportPageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.devops.ExportBasicDataSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.devops.ImportBasicDataSaveVO;
import com.elitescloud.cloudt.system.service.SystemDataService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 系统初始化.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/8
 */
@Api(tags = "运维工具")
@RestController
@RequestMapping(value = "/devops/init", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class SystemInitController {

    private final SystemDataService service;

    public SystemInitController(SystemDataService service) {
        this.service = service;
    }

    @ApiOperation(value = "获取数据类型列表")
    @ApiOperationSupport(order = 1)
    @GetMapping(value = "/dataType/all")
    public ApiResult<List<CodeNameParam>> listDataType() {
        return service.listDataType();
    }

    @ApiOperation(value = "导出数据")
    @ApiOperationSupport(order = 2)
    @PostMapping(value = "/export/data")
    public ApiResult<Boolean> exportData(@RequestBody ExportBasicDataSaveVO saveVO) {
        return service.exportData(saveVO);
    }

    @ApiOperation(value = "分页查询导出记录")
    @ApiOperationSupport(order = 3)
    @PostMapping(value = "/export/pageRecord")
    public ApiResult<PagingVO<BasicRecordExportPageRespVO>> pageExportedRecord(@RequestBody BasicDataRecordPageQueryVO queryVO) {
        return service.pageExportedRecord(queryVO);
    }

    @ApiOperation(value = "导入初始化数据")
    @ApiOperationSupport(order = 4)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "file", value = "数据文件", required = true),
    })
    @PostMapping(value = "/import/data")
    public ApiResult<Boolean> importData(@RequestParam(name = "file") @NotNull(message = "请选择文件") MultipartFile file,
                                         ImportBasicDataSaveVO saveVO) {
        return service.importData(file, saveVO);
    }

    @ApiOperation(value = "分页查询导入记录")
    @ApiOperationSupport(order = 5)
    @PostMapping(value = "/import/pageRecord")
    public ApiResult<PagingVO<BasicRecordImportPageRespVO>> pageImportedRecord(@RequestBody BasicDataRecordPageQueryVO queryVO) {
        return service.pageImportedRecord(queryVO);
    }
}
