package com.elitescloud.cloudt.system.controller.mng.sys;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.sys.DataSelectorPagedQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.DataSelectorDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.DataSelectorGroupDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.DataSelectorPagedRespVO;
import com.elitescloud.cloudt.system.model.vo.save.sys.DataSelectorGroupSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.sys.DataSelectorSaveVO;
import com.elitescloud.cloudt.system.service.DataSelectorMngService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/16
 */
@Api(tags = "数据选择器管理")
@RestController
@RequestMapping(value = "/mng/dataSelector", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class DataSelectorMngController {
    private DataSelectorMngService service;

    @ApiOperation(value = "保存分组")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/group/save")
    public ApiResult<Long> saveGroup(@RequestBody @Valid DataSelectorGroupSaveVO saveVO) {
        return service.saveGroup(saveVO);
    }

    @ApiOperation(value = "删除分组")
    @ApiOperationSupport(order = 2)
    @ApiImplicitParam(name = "groupCode", value = "分组编码", required = true)
    @DeleteMapping(value = "/group")
    public ApiResult<String> deleteGroup(@RequestParam(value = "groupCode") @NotBlank(message = "分组编码为空") String groupCode) {
        return service.deleteGroup(groupCode);
    }

    @ApiOperation(value = "修改分组状态")
    @ApiOperationSupport(order = 3)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "groupCode", value = "分组编码", required = true),
            @ApiImplicitParam(name = "enabled", value = "启用状态", defaultValue = "true"),
    })
    @PatchMapping(value = "/group/enabled")
    public ApiResult<String> updateGroupEnabled(@RequestParam(value = "groupCode") @NotBlank(message = "分组编码为空") String groupCode,
                                                @RequestParam(value = "enabled", defaultValue = "true") Boolean enabled) {
        return service.updateGroupEnabled(groupCode, enabled);
    }

    @ApiOperation(value = "修改分组名称")
    @ApiOperationSupport(order = 4)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "groupCode", value = "分组编码", required = true),
            @ApiImplicitParam(name = "name", value = "分组名称", required = true),
    })
    @PatchMapping(value = "/group/name")
    public ApiResult<String> updateGroupName(@RequestParam(value = "groupCode") @NotBlank(message = "分组编码为空") String groupCode,
                                             @RequestParam(value = "name") @NotBlank(message = "分组名称为空") String name) {
        return service.updateGroupName(groupCode, name);
    }

    @ApiOperation(value = "获取分组详细信息")
    @ApiOperationSupport(order = 5)
    @ApiImplicitParam(name = "groupCode", value = "分组编码", required = true)
    @GetMapping(value = "/group")
    public ApiResult<DataSelectorGroupDetailRespVO> getGroupDetail(@RequestParam(value = "groupCode") @NotBlank(message = "分组编码为空") String groupCode) {
        return service.getGroupDetail(groupCode);
    }

    @ApiOperation(value = "获取分组列表")
    @ApiOperationSupport(order = 6)
    @GetMapping(value = "/group/enum")
    public ApiResult<List<IdCodeNameParam>> listGroup() {
        return service.listGroup();
    }

    @ApiOperation(value = "保存数据选择器")
    @ApiOperationSupport(order = 11)
    @PostMapping(value = "/save")
    public ApiResult<Long> save(@RequestBody @Valid DataSelectorSaveVO saveVO) {
        return service.save(saveVO);
    }

    @ApiOperation(value = "获取数据选择器详细信息")
    @ApiOperationSupport(order = 12)
    @ApiImplicitParam(name = "id", value = "选择器ID", required = true)
    @GetMapping(value = "/detail")
    public ApiResult<DataSelectorDetailRespVO> getDetail(@RequestParam(value = "id") @NotNull(message = "选择器ID为空") Long id) {
        return service.getDetail(id);
    }

    @ApiOperation(value = "分页查询数据选择器")
    @ApiOperationSupport(order = 13)
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<DataSelectorPagedRespVO>> pageMng(@RequestBody DataSelectorPagedQueryVO queryVO) {
        return service.pageMng(queryVO);
    }

    @ApiOperation(value = "修改数据选择器状态")
    @ApiOperationSupport(order = 14)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true),
            @ApiImplicitParam(name = "enabled", value = "启用状态", defaultValue = "true"),
    })
    @PatchMapping(value = "/enabled")
    public ApiResult<Long> updateEnabled(@RequestParam(value = "id") @NotNull(message = "ID为空") Long id,
                                         @RequestParam(value = "enabled", defaultValue = "true") Boolean enabled) {
        return service.updateEnabled(id, enabled);
    }

    @ApiOperation(value = "批量删除数据选择器")
    @ApiOperationSupport(order = 15)
    @PostMapping(value = "/delete/batch")
    public ApiResult<Boolean> delete(@RequestBody @NotEmpty(message = "ID为空") List<Long> ids) {
        return service.delete(ids);
    }

    @Autowired
    public void setService(DataSelectorMngService service) {
        this.service = service;
    }
}
