package com.elitescloud.cloudt.system.controller.mng.sys;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.sys.UnifyQueryPagedQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.UnifyQueryDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.UnifyQueryPagedRespVO;
import com.elitescloud.cloudt.system.service.SysUnifyQueryMngService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/7
 */
@Api(tags = "统一查询管理")
@RestController
@RequestMapping(value = "/mng/unifyQuery", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class UnifyQueryMngController {
    private SysUnifyQueryMngService service;

    @ApiOperation(value = "分页查询记录")
    @ApiOperationSupport(order = 11)
    @PostMapping(value = "/record/page")
    public ApiResult<PagingVO<UnifyQueryPagedRespVO>> pageMng(@RequestBody UnifyQueryPagedQueryVO queryVO) {
        return service.pageMng(queryVO);
    }

    @ApiOperation(value = "获取记录详情")
    @ApiOperationSupport(order = 12)
    @ApiImplicitParam(name = "id", value = "记录ID", required = true, dataType = "long")
    @GetMapping(value = "/record/get")
    public ApiResult<UnifyQueryDetailRespVO> get(@RequestParam(name = "id") @NotNull(message = "ID为空") Long id) {
        return service.get(id);
    }

    @Autowired
    public void setService(SysUnifyQueryMngService service) {
        this.service = service;
    }
}
