package com.elitescloud.cloudt.system.controller.mng.test;

import com.elitescloud.boot.excel.common.DataImport;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2/16/2023
 */
@Component
@Log4j2
public class TestImportService implements DataImport<TestData> {

    @Override
    public String getTmplCode() {
        return "system_test_import";
    }

    @Override
    public List<String> executeImport(List<TestData> dataList, int startRowIndex) {
        log.info("导入数据：{}", dataList);
        try {
            TimeUnit.SECONDS.sleep(1);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (startRowIndex > 4) {
            return Arrays.asList(null, "异常信息");
        }
        return Arrays.asList("异常2", null);
    }

    @Override
    public Integer stepSize() {
        return 2;
    }
}
