package com.elitescloud.cloudt.system.controller.openapi;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.SysSiteMsgSaveDTO;
import com.elitescloud.cloudt.system.dto.resp.msg.SysSiteMsgViewedDTO;
import com.elitescloud.cloudt.system.modules.message.service.SiteMsgMngService;
import com.elitescloud.cloudt.system.modules.message.service.SiteMsgQueryService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/11/29
 */
@Api(tags = "站内信")
@RestController
@RequestMapping(value = "/openapi/siteMsg", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class SysSiteMsgOpenApiController {

    @Autowired
    private SiteMsgMngService mngService;
    @Autowired
    private SiteMsgQueryService queryService;

    /**
     * 发送站内信
     *
     * @param saveDTO 站内信信息
     * @return 发送结果
     */
    @PostMapping(value = "/send")
    public ApiResult<String> send(@RequestBody @Valid SysSiteMsgSaveDTO saveDTO) {
        return mngService.send(saveDTO);
    }

    /**
     * 删除站内信
     *
     * @param batchId 批次ID
     * @return 删除结果
     */
    @DeleteMapping(value = "/delete")
    public ApiResult<String> delete(@RequestParam(name = "batchId") @NotBlank(message = "消息批次ID为空") String batchId) {
        return mngService.delete(batchId);
    }

    /**
     * 查询阅读情况
     *
     * @param batchId 批次ID
     * @return 阅读情况
     */
    @GetMapping(value = "/viewed")
    public ApiResult<List<SysSiteMsgViewedDTO>> queryViewedResult(@RequestParam(name = "batchId") @NotBlank(message = "消息批次ID为空") String batchId) {
        return queryService.queryViewedResult(batchId);
    }
}
