package com.elitescloud.cloudt.system.model.bo;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Map;

/**
 * 数据关系的值.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/15
 */
@Getter
@Setter
public class DataRelationInstValueBO implements Serializable {
    private static final long serialVersionUID = 1512405498812568492L;
    /**
     * 数据关系编码
     */
    private String drCode;
    /**
     * 分类编码
     */
    private String catCode;

    /**
     * 主数据的标识
     */
    private String dataKey;

    /**
     * 主数据的属性
     */
    private String dataAttribute;

    /**
     * 主数据的扩展信息
     */
    private Map<String, String> dataExt;
    private transient String dataExtJson;

    /**
     * 关联数据的标识
     */
    private String refDataKey;

    /**
     * 关联数据的属性
     */
    private String refDataAttribute;

    /**
     * 关联数据的扩展信息
     */
    private Map<String, String> refDataExt;
    private transient String refDataExtJson;
}
