package com.elitescloud.cloudt.system.model.bo;

import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * OpenApi信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/4
 */
@Getter
@Setter
public class OpenApiBO {

    /**
     * OpenApi的ID
     */
    private Long id;

    /**
     * 标题
     */
    private String title;

    /**
     * 描述
     */
    private String description;

    /**
     * 版本
     */
    private String version;

    /**
     * OpenAPI构建时间
     */
    private LocalDateTime buildTime;

    /**
     * 项目编码
     */
    private String project;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 环境编码
     */
    private String env;

    /**
     * 环境名称
     */
    private String envName;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 项目版本
     */
    private String projectVersion;

    /**
     * 云梯架构版本
     */
    private String cloudtBootVersion;

    /**
     * 原始数据JSON
     */
    private byte[] originalDataJson;

    /**
     * tag
     */
    private String tagsJson;

    /**
     * 操作接口列表
     */
    private List<Operation> operationList;

    /**
     * 接口参数列表
     */
    private List<ComponentSchema> componentSchemaList;

    /**
     * 业务对象信息
     */
    private Map<String, Object> businessObjectMap;

    /**
     * 操作接口
     */
    @Getter
    @Setter
    public static class Operation {
        /**
         * 操作编码
         */
        private String operationCode;
        /**
         * 操作标识
         */
        private String operationId;
        /**
         * 摘要信息
         */
        private String summary;

        /**
         * 描述
         */
        private String description;

        /**
         * 标签列表
         */
        private String[] tags;

        /**
         * 数据JSON
         */
        private byte[] originalDataJson;

        /**
         * 是否启用
         */
        private Boolean enabled;

        /**
         * 接口地址
         */
        private String url;

        /**
         * 接口方法
         */
        private String method;

        /**
         * 是否含有业务操作
         */
        private Boolean businessOperation;
        /**
         * API类型 null和1标识外部， 2标识内部（openfeign）
         */
        private Integer apiType;

        private String operationGroup;
        private String    returnTypeJson;
        private String    parameterTypesJson;
    }

    /**
     * 操作接口的出入参对象
     */
    @Getter
    @Setter
    public static class ComponentSchema {
        /**
         * schema名称
         */
        private String schemaPath;

        /**
         * schema类型
         */
        private String schemaType;

        /**
         * 数据JSON
         */
        private byte[] originalDataJson;
    }
}
