package com.elitescloud.cloudt.system.model.bo;

import com.elitescloud.cloudt.system.constant.DataPermissionType;
import lombok.Data;

import java.io.Serializable;

/**
 * 角色权限的规则信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/03/25
 */
@Data
public class RolePermissionRuleBO implements Serializable {
    private static final long serialVersionUID = -5022182696315699410L;

    /**
     * 权限规则ID
     */
    private Long id;

    /**
     * 角色编码
     */
    private String rolCode;

    /**
     * 权限类型
     * <p>
     * {@link DataPermissionType}
     */
    private String permissionType;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 菜单编码
     */
    private String menuCode;

    /**
     * 业务对象编码
     */
    private String businessObjectCode;

    /**
     * 业务操作编码
     */
    private String operationCode;
}
