package com.elitescloud.cloudt.system.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @Auther: Mark
 * @Date: 2024/12/13 14:00
 * @Description:
 */
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Entity
@Table(name = "sys_infinity_platform")
@org.hibernate.annotations.Table(appliesTo = "sys_infinity_platform", comment = "接口平台(对接系统)")
@ApiModel("接口平台(对接系统)")
public class InfinityPlatformDO extends BaseModel implements Serializable {

    @ApiModelProperty(value = "平台名称")
    @Column(name = "platform_name", nullable = true, length = 128)
    private String platformName;

    /**
     * 平台编码
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "平台编码")
    @Column(name = "platform_code", nullable = true, length = 64)
    private String platformCode;

    /**
     * 服务url前缀
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "服务url前缀")
    @Column(name = "server_url", nullable = true, length = 255)
    private String serverUrl;

    /**
     * 认证方式
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "认证方式")
    @Column(name = "auth_method", nullable = true, length = 32)
    private String authMethod;

    /**
     * 认证账号
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "认证账号")
    @Column(name = "auth_account", nullable = true, length = 32)
    private String authAccount;

    /**
     * 文档说明(支持markdown)
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "文档说明(支持markdown)")
    @Column(name = "description", nullable = true)
    private String description;
}
