package com.elitescloud.cloudt.system.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.constant.SysAlertType;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;

/**
 * 系统预警提醒配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/26
 */
@Entity
@Table(name = "sys_alert_config", indexes = {
        @Index(name = "idx_alert_cfg_bt", columnList = "businessType"),
})
@Comment("系统预警提醒配置")
@Getter
@Setter
public class SysAlertConfigDO extends BaseModel {
    private static final long serialVersionUID = -5699612407202609214L;

    @Comment(value = "业务类型")
    @Column(nullable = false)
    private String businessType;

    @Comment(value = "是否启用", defaultValue = "1")
    @Column()
    private Boolean enabled;

    /**
     * 提醒方式
     * <p>
     * {@link SysAlertType}
     */
    @Comment(value = "提醒方式")
    @Column(nullable = false)
    private String alertType;

    @Comment(value = "配置内容")
    @Column()
    @Lob
    private String cfgJson;

    @Comment(value = "说明")
    @Column()
    private String description;
}
