package com.elitescloud.cloudt.system.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 系统预警提醒.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/26
 */
@Entity
@Table(name = "sys_alert", indexes = {
        @Index(name = "uq_alert_bt", columnList = "businessType,tenantId", unique = true),
})
@Comment("系统预警提醒")
@Getter
@Setter
public class SysAlertDO extends BaseModel {
    private static final long serialVersionUID = -5699612407202609214L;

    @Comment(value = "业务类型")
    @Column(nullable = false)
    private String businessType;

    @Comment(value = "是否启用", defaultValue = "1")
    @Column()
    private Boolean enabled;

    @Comment(value = "描述")
    @Column()
    private String description;
}
